/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private String projectName;
    private List smlifDocuments;
    private StringBuffer smlModelUnitPaths;
    private IContainer rootDirectory;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected boolean noValidSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorNoSelectionTitle, (String)SMLMessages.errorNoSelection);
            return true;
        }
        this.projectName = null;
        this.smlModelUnitPaths = new StringBuffer();
        this.smlifDocuments = new ArrayList();
        this.rootDirectory = null;
        Iterator selections = this.selection.iterator();
        while (selections.hasNext()) {
            IResource currentSelection = (IResource)selections.next();
            if (this.projectName == null) {
                this.projectName = currentSelection.getProject().getName();
            } else if (!this.projectName.equals(currentSelection.getProject().getName())) {
                MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorNoSelectionTitle, (String)SMLMessages.errorNoSelection);
                return true;
            }
            if (this.rootDirectory == null) {
                this.rootDirectory = this.findParentDirectory(currentSelection);
            } else if (!this.contains(this.rootDirectory, this.findParentDirectory(currentSelection))) {
                this.rootDirectory = this.findMutualContainer(this.rootDirectory, currentSelection);
            }
            this.groupSelections(currentSelection);
        }
        if (this.smlModelUnitPaths.length() > 0) {
            this.smlModelUnitPaths.deleteCharAt(this.smlModelUnitPaths.length() - 1);
        }
        return false;
    }

    private boolean contains(IContainer root, IContainer parent) {
        if (root.equals((Object)parent)) {
            return true;
        }
        while ((parent = parent.getParent()) != null && !root.equals((Object)parent)) {
        }
        return parent != null;
    }

    private IContainer findMutualContainer(IContainer root, IResource resource) {
        IContainer mutualContainer = this.findParentDirectory(resource);
        while (mutualContainer != null && !this.contains(mutualContainer, root)) {
            mutualContainer = root.getParent();
        }
        return mutualContainer;
    }

    private IContainer findParentDirectory(IResource resource) {
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return resource.getParent();
    }

    private void groupSelections(IResource resource) {
        if (resource instanceof IFile) {
            try {
                int documentType = SMLValidatorUtil.identifyDocumentType((IFile)((IFile)resource));
                if (2 == documentType) {
                    this.smlifDocuments.add(resource.getLocation().toString());
                } else if (3 != documentType) {
                    this.smlModelUnitPaths.append(resource.getLocation().toString()).append(",");
                }
            }
            catch (Exception e) {
                SMLValidatorUtil.openErrorWithDetail((String)SMLMessages.errorContentTypeTitle, (String)NLS.bind((String)SMLMessages.errorContentType, (Object)((IFile)resource).getFullPath()), (Throwable)e);
            }
        } else if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    this.groupSelections(children[i]);
                    ++i;
                }
            }
            catch (CoreException e) {
                SMLPlugin.logError(e);
            }
        }
    }

    public String getRootDirectory() {
        return this.rootDirectory == null ? this.projectName : this.rootDirectory.getLocation().toString();
    }

    public String getSmlModelUnitPaths() {
        return this.smlModelUnitPaths.toString();
    }

    public List getSmlifdocuments() {
        return this.smlifDocuments;
    }
}

