/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractFormPage
extends FormPage
implements ModifyListener {
    private boolean enabled = true;

    public AbstractFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        Composite parent = form.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sashForm = ((SMLIFEditor)this.getEditor()).getExtendedToolkit().createSashForm(parent, 256);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftColumn = this.createColumn((Composite)sashForm);
        Composite rightColumn = this.createColumn((Composite)sashForm);
        this.setWeight(sashForm);
        this.createLeftColumn(leftColumn);
        this.createRightColumn(rightColumn);
        form.setEnabled(this.isEnabled());
    }

    protected void setWeight(SashForm sashForm) {
        sashForm.setWeights(new int[]{5, 5});
    }

    public void setErrorMessage(String message) {
        ScrolledForm form = this.getManagedForm().getForm();
        if (message == null) {
            form.setMessage(null, 0);
        } else {
            form.setMessage(message, 3);
        }
    }

    protected abstract void createLeftColumn(Composite var1);

    protected abstract void createRightColumn(Composite var1);

    protected Composite createColumn(Composite parent) {
        Composite column = this.getManagedForm().getToolkit().createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        column.setLayoutData((Object)new GridData(4, 4, true, true));
        return column;
    }

    protected Section createSection(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 256);
        GridData td = new GridData(4, 4, true, true);
        section.setLayoutData((Object)td);
        return section;
    }

    protected Text createTextField(Composite parent, String label, boolean multiLine, String initialValue, ModifyListener modifyListener) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Label lbl = toolkit.createLabel(parent, label);
        GridData lblGD = new GridData(-1, 128, false, false);
        lbl.setLayoutData((Object)lblGD);
        Text text = toolkit.createText(parent, initialValue, multiLine ? 2624 : 0);
        GridData gd = new GridData(4, -1, true, false);
        if (multiLine) {
            gd.heightHint = 200;
        }
        text.setLayoutData((Object)gd);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (modifyListener != null) {
            text.addModifyListener(modifyListener);
        }
        return text;
    }

    protected Text createTextField(Composite parent, String label, String initialValue, ModifyListener modifyListener) {
        return this.createTextField(parent, label, false, initialValue, modifyListener);
    }

    public void modifyText(ModifyEvent e) {
        if (!this.isDirty()) {
            this.getManagedForm().dirtyStateChanged();
        }
    }

    protected void makeSectionReady(Section section, Composite client, String title) {
        section.setClient((Control)client);
        section.setText(title);
        this.getManagedForm().getToolkit().createCompositeSeparator((Composite)section);
        section.setExpanded(true);
    }

    protected void setEnabled(boolean enabled) {
        if (this.getManagedForm() != null) {
            this.getManagedForm().getForm().setEnabled(false);
        }
        this.enabled = enabled;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    protected abstract void updateContent();
}

