/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.cosmos.rm.smlif.internal.SMLImages;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.actions.ValidateResourceAction;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFEditor;
import org.eclipse.cosmos.rm.smlif.internal.importing.ui.ImportFromSMLIFWizard;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverviewPage
extends AbstractFormPage {
    public static final String ID = "org.eclipse.cosmos.rm.smlif.OverviewPage";
    private Text descriptionText;
    private Text nameText;
    private Text versionText;
    private Text displayNameText;
    private Text baseURIText;
    private boolean disableListener;

    public OverviewPage(FormEditor editor) {
        super(editor, ID, SMLMessages.editorOverviewTitle);
    }

    protected void createLeftColumn(Composite parent) {
        this.getManagedForm().addPart((IFormPart)((SMLIFEditor)this.getEditor()).getSmlifFormPart());
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(parent);
        Composite sectionClient = toolkit.createComposite((Composite)section);
        GridLayout sectionClientGL = new GridLayout(2, false);
        sectionClientGL.marginTop = 10;
        sectionClient.setLayout((Layout)sectionClientGL);
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nameText = this.createTextField(sectionClient, SMLMessages.editorName, null, this);
        this.versionText = this.createTextField(sectionClient, SMLMessages.editorVersion, null, this);
        this.displayNameText = this.createTextField(sectionClient, SMLMessages.editorDisplayName, null, this);
        this.baseURIText = this.createTextField(sectionClient, SMLMessages.editorBaseURI, null, this);
        SMLCommonUtil.addURIValidator(this.baseURIText, new SMLPage(this));
        this.descriptionText = this.createTextField(sectionClient, SMLMessages.editorDescription, true, null, this);
        this.makeSectionReady(section, sectionClient, SMLMessages.editorGeneralInformation);
    }

    protected void createRightColumn(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(parent);
        Composite sectionClient = toolkit.createComposite((Composite)section);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 10;
        sectionClient.setLayout((Layout)gl);
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Label linkImage = toolkit.createLabel(sectionClient, "");
        linkImage.setImage(SMLImages.INSTANCE.getImage("validate.gif"));
        Hyperlink validateLink = toolkit.createHyperlink(sectionClient, SMLMessages.editorValidateDocument, 64);
        FontData[] fontData = validateLink.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        validateLink.setFont(new Font(null, fontData));
        validateLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFile fileSelection = OverviewPage.this.getInputFile();
                if (fileSelection != null) {
                    ValidateResourceAction validateAction = new ValidateResourceAction();
                    validateAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)fileSelection));
                    validateAction.run(null);
                }
            }
        });
        linkImage = toolkit.createLabel(sectionClient, "");
        linkImage.setImage(SMLImages.INSTANCE.getImage("phenics.gif"));
        Hyperlink importLink = toolkit.createHyperlink(sectionClient, SMLMessages.editorImportModel, 64);
        importLink.setFont(new Font(null, fontData));
        importLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFile fileSelection = OverviewPage.this.getInputFile();
                if (fileSelection != null) {
                    IWorkbenchWindow window = OverviewPage.this.getSite().getWorkbenchWindow();
                    ImportFromSMLIFWizard wizard = new ImportFromSMLIFWizard(OverviewPage.this.nameText.getText());
                    wizard.init(window.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)fileSelection));
                    WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        });
        this.makeSectionReady(section, sectionClient, SMLMessages.editorActionsTitle);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (!active) {
            return;
        }
        this.disableListener = true;
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        String field = editor.retrieveField(0, "name");
        this.nameText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "version");
        this.versionText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "displayName");
        this.displayNameText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "baseURI");
        this.baseURIText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "description");
        this.descriptionText.setText(field == null ? "" : field);
        this.disableListener = false;
    }

    public void modifyText(ModifyEvent e) {
        if (this.disableListener) {
            return;
        }
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        IDocument document = editor.getSmlifSourcePage().getDocument();
        Node identityNode = SMLCommonUtil.nestedNodeRetrieval(editor.getDocumentNode(), new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", "identity"}}, true, false, null);
        this.modifyTextNode(editor, identityNode, e.widget == this.nameText ? "name" : (e.widget == this.versionText ? "version" : (e.widget == this.displayNameText ? "displayName" : (e.widget == this.baseURIText ? "baseURI" : "description"))), ((Text)e.widget).getText());
        try {
            StringBuffer buffer = new StringBuffer();
            SMLValidatorUtil.serializeNode((StringBuffer)buffer, (Node)editor.getDocumentNode().getOwnerDocument());
            document.set(buffer.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void modifyTextNode(SMLIFEditor editor, Node node, String elementName, String newValue) {
        Node siblingToInsertBefore = this.getSiblingToInsertBefore(node, elementName);
        boolean append = siblingToInsertBefore == null;
        Node childNode = SMLCommonUtil.nestedNodeRetrieval(node, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", elementName}}, true, append, siblingToInsertBefore);
        if (childNode == null) {
            return;
        }
        NodeList children = childNode.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            childNode.removeChild(children.item(i));
            ++i;
        }
        childNode.appendChild(childNode.getOwnerDocument().createTextNode(newValue == null ? "" : newValue));
    }

    private Node getSiblingToInsertBefore(Node parentNode, String elementName) {
        List identityNodeList = this.getIdentityNodeList();
        int elementIndex = identityNodeList.indexOf(elementName);
        if (elementIndex < 0 || elementIndex >= identityNodeList.size() - 1) {
            return null;
        }
        String siblingNodeName = (String)identityNodeList.get(elementIndex + 1);
        Node siblingToInsertSiblingBefore = this.getSiblingToInsertBefore(parentNode, siblingNodeName);
        boolean append = siblingToInsertSiblingBefore == null;
        return SMLCommonUtil.nestedNodeRetrieval(parentNode, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", siblingNodeName}}, true, append, siblingToInsertSiblingBefore);
    }

    private List getIdentityNodeList() {
        String[] array = new String[]{"name", "version", "displayName", "baseURI", "description"};
        return Arrays.asList(array);
    }

    protected void updateContent() {
        if (this.isActive()) {
            this.setActive(true);
        }
    }

    private IFile getInputFile() {
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorNoInputTitle, (String)SMLMessages.errorNoInput);
            return null;
        }
        IFile fileSelection = null;
        fileSelection = input instanceof FileEditorInput ? ((FileEditorInput)input).getFile() : ResourcesPlugin.getWorkspace().getRoot().getFile(((IPathEditorInput)input).getPath());
        return fileSelection;
    }
}

