/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.newfile.ui;

import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewFileWizardIdentityPage
extends WizardPage {
    private Text nameText;
    private Text versionText;
    private Text displayNameText;
    private Text baseURIText;
    private Text descriptionText;

    protected NewFileWizardIdentityPage() {
        super(SMLMessages.newFileWizardIdentityPageName);
        this.setTitle(SMLMessages.newFileWizardIdentityPageTitle);
        this.setDescription(SMLMessages.newFileWizardIdentityPageDescription);
    }

    public void createControl(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridData topComponentData = new GridData(768);
        topComponent.setLayoutData((Object)topComponentData);
        GridLayout topComponentLayout = new GridLayout();
        topComponentLayout.numColumns = 2;
        topComponentLayout.makeColumnsEqualWidth = false;
        topComponent.setLayout((Layout)topComponentLayout);
        this.nameText = this.createTextField(topComponent, SMLMessages.editorName, false);
        this.versionText = this.createTextField(topComponent, SMLMessages.editorVersion, false);
        this.displayNameText = this.createTextField(topComponent, SMLMessages.editorDisplayName, false);
        this.baseURIText = this.createTextField(topComponent, SMLMessages.editorBaseURI, false);
        SMLCommonUtil.addURIValidator(this.baseURIText, new SMLPage(this));
        this.descriptionText = this.createTextField(topComponent, SMLMessages.editorDescription, true);
        this.setControl((Control)topComponent);
        Dialog.applyDialogFont((Control)topComponent);
    }

    private Text createTextField(Composite destGroup, String editorName, boolean multiLine) {
        Label label = new Label(destGroup, 16384);
        label.setText(editorName);
        GridData lblGD = new GridData(-1, 128, false, false);
        label.setLayoutData((Object)lblGD);
        Text text = new Text(destGroup, multiLine ? 2624 : 2048);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        if (multiLine) {
            gridData.heightHint = 200;
        }
        text.setLayoutData((Object)gridData);
        return text;
    }

    public Text getBaseURIText() {
        return this.baseURIText;
    }

    public Text getDescriptionText() {
        return this.descriptionText;
    }

    public Text getDisplayNameText() {
        return this.displayNameText;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public Text getVersionText() {
        return this.versionText;
    }
}

