/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.application.impl;

import java.io.Serializable;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceFacet;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceInstance;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceProperty;
import org.eclipse.cosmos.rm.repository.internal.application.impl.AbstractSMLFragment;
import org.eclipse.cosmos.rm.repository.internal.reference.SMLQualifiedReference;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.w3c.dom.Node;

public class SMLFileResourceFacet
extends AbstractSMLFragment
implements ISMLResourceFacet,
Serializable {
    private static final long serialVersionUID = 3726281149432601361L;
    private ISMLRepository repository;
    private Node root;
    private boolean reference;

    public static SMLFileResourceFacet load(ISMLRepository repository, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        boolean reference = "http://www.cosmos.rm/dataCenter/core".equals(node.getNamespaceURI()) && "facetRef".equals(node.getLocalName());
        return new SMLFileResourceFacet(repository, node, reference);
    }

    private SMLFileResourceFacet(ISMLRepository repository, Node root, boolean reference) {
        this.repository = repository;
        this.root = root;
        this.reference = reference;
    }

    public ISMLResourceFacet resolveReference() {
        if (!this.reference) {
            return this;
        }
        return SMLFileResourceFacet.load(this.repository, new SMLQualifiedReference(this.repository, SMLRepositoryUtil.extractReference(this.root)).resolveReference());
    }

    public ISMLResourceFacet[] retrieveFacets() {
        return SMLRepositoryUtil.retrieveFacets((ISMLResourceInstance)this.getParentDocument(), this.root, this.repository);
    }

    public ISMLResourceProperty[] retrieveProperties() {
        return SMLRepositoryUtil.retrieveProperties(this.repository, (ISMLResourceInstance)this.getParentDocument(), this.root);
    }

    public ISMLResourceInstance[] retrieveResources() {
        return SMLRepositoryUtil.retrieveResources(this.repository, (ISMLResourceInstance)this.getParentDocument(), this.root);
    }

    public boolean isReference() {
        return this.reference;
    }

    protected Node getRootNode() {
        return this.root;
    }
}

