/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.application.impl.SMLFileResourceInstance;
import org.eclipse.cosmos.rm.repository.internal.core.MetadataProcessor;
import org.eclipse.cosmos.rm.repository.internal.operations.AbstractListenerManager;
import org.eclipse.cosmos.rm.repository.internal.operations.FileExportOperation;
import org.eclipse.cosmos.rm.repository.internal.operations.FileImportOperation;
import org.eclipse.cosmos.rm.repository.internal.operations.FileValidateOperation;
import org.eclipse.cosmos.rm.repository.internal.operations.OperationEvent;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileDefinitionDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryConnectionException;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.operations.IProgressListener;
import org.eclipse.cosmos.rm.repository.provisional.operations.ISMLOperation;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLMetadata;
import org.eclipse.cosmos.rm.validation.internal.content.AbstractXMLContentDescriber;

public class FileSystemSMLRepository
extends AbstractListenerManager
implements ISMLRepository,
Serializable {
    private static final long serialVersionUID = -7789205443658521889L;
    private static final String PROPERTY_PREFIX_OBJECT = "object.";
    private static final String PROPERTY_PREFIX_STRING = "string.";
    private static final String PROPERTY_PREFIX_BOOLEAN = "boolean.";
    private static final String PROPERTY_PREFIX_INT = "int.";
    public static final String ATTRIBUTE_CONFIGURATION_PROPERTY = "org.eclipse.cosmos.rm.repository.ATTRIBUTE_CONFIGURATION_PROPERTY";
    private Properties configurationFile;
    private MetadataProcessor metadataProcessor;
    private ISMLDocument[] activeDocuments;
    private Map operations;
    private boolean connected;
    private Map properties;

    public void connect(Map attributes) throws RepositoryConnectionException {
        boolean suppressErrors;
        this.properties = new Hashtable();
        String rootContextDirectory = (String)attributes.get("root.directory");
        String rootContextNode = (String)attributes.get("root.context.node");
        boolean bl = suppressErrors = attributes.get("suppress.connect.errors") == null ? false : (Boolean)attributes.get("suppress.connect.errors");
        if (rootContextDirectory == null) {
            String propertyName = (String)attributes.get(ATTRIBUTE_CONFIGURATION_PROPERTY);
            if (propertyName == null) {
                if (!suppressErrors) {
                    throw new RepositoryConnectionException(RepositoryMessages.repositoryMissingConfiguration);
                }
            } else {
                InputStream is;
                this.configurationFile = new Properties();
                try {
                    is = new FileInputStream(propertyName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    is = this.getClass().getClassLoader().getResourceAsStream(propertyName);
                }
                try {
                    try {
                        this.configurationFile.load(is);
                    }
                    catch (IOException e) {
                        throw new RepositoryConnectionException(e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                rootContextDirectory = this.configurationFile.getProperty("root.directory");
                rootContextNode = this.configurationFile.getProperty("root.context.node");
            }
        }
        if (!(suppressErrors || rootContextDirectory != null && new File(rootContextDirectory).exists())) {
            throw new RepositoryConnectionException(rootContextDirectory == null ? RepositoryMessages.repositoryMissingContextDirectory : RepositoryMessages.repositoryBadRootDirectory);
        }
        rootContextDirectory = rootContextDirectory == null ? rootContextDirectory : rootContextDirectory.replace('\\', '/');
        this.setProperty("root.directory", rootContextDirectory);
        this.setProperty("root.context.node", rootContextNode);
        this.initializeOperations();
        this.connected = true;
    }

    private void initializeOperations() {
        this.operations = new Hashtable();
        this.operations.put("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLExportOperation", new FileExportOperation(this));
        this.operations.put("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLImportOperation", new FileImportOperation(this));
        this.operations.put("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLValidateOperation", new FileValidateOperation(this));
    }

    public void addDocument(ISMLMetadata metadata, InputStream input) throws RepositoryOperationException {
        FileOutputStream fos;
        String rootDirectory;
        String fileName;
        block24: {
            boolean doit;
            fileName = metadata == null ? null : metadata.getId();
            rootDirectory = this.getProperty("root.directory", null);
            if (fileName != null && fileName.length() > 0) {
                fileName = fileName.startsWith("/") ? fileName.substring(1) : fileName;
                fileName = String.valueOf(rootDirectory) + "/" + fileName;
                int lastInx = (fileName = fileName.endsWith("/") ? this.generateTempFileName(fileName, metadata) : fileName).lastIndexOf(47);
                if (lastInx >= 0) {
                    File file = new File(fileName.substring(0, lastInx));
                    boolean createStructure = this.getProperty("org.eclipse.cosmos.rm.repository.CREATE_STRUCTURE", true);
                    if (!file.exists()) {
                        if (!createStructure) {
                            this.notifyListeners((byte)1, file.getAbsolutePath());
                            return;
                        }
                        file.mkdirs();
                    }
                }
            } else {
                fileName = String.valueOf(rootDirectory) + "/" + this.generateTempFileName(rootDirectory, metadata);
            }
            fos = null;
            boolean overwrite = this.getProperty("org.eclipse.cosmos.rm.repository.OVERWRITE_FILES", false);
            if (!new File(fileName).exists() || overwrite || (doit = this.notifyListeners((byte)0, fileName))) break block24;
            try {
                if (fos != null) {
                    fos.close();
                }
                input.close();
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                fos = new FileOutputStream(fileName);
                byte[] buffer = new byte[1024];
                int length = 0;
                while (input.available() > 0) {
                    length = input.read(buffer);
                    fos.write(buffer, 0, length);
                }
                String[] aliases = metadata.getAliases();
                if (aliases != null) {
                    this.metadataProcessor.addAliases(fileName.substring(rootDirectory.length() + 1), aliases);
                    if (metadata.getBoundRules() != null) {
                        Map rules = metadata.getBoundRules();
                        for (String currentKey : rules.keySet()) {
                            List ruleList = (List)rules.get(currentKey);
                            this.metadataProcessor.addRuleBinding(currentKey, ruleList.toArray(new String[ruleList.size()]));
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new RepositoryOperationException(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new RepositoryOperationException(e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (fos != null) {
                    fos.close();
                }
                input.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fos != null) {
                fos.close();
            }
            input.close();
        }
        catch (IOException iOException) {}
    }

    private boolean notifyListeners(byte type, Object data) {
        IProgressListener[] listeners = this.getProgressListeners();
        if (listeners == null) {
            return false;
        }
        OperationEvent importEvent = OperationEvent.opeartionEvent;
        importEvent.type = type;
        importEvent.data = data;
        boolean doit = false;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].operationInterrupted(importEvent);
            doit = doit || importEvent.doit;
            ++i;
        }
        return doit;
    }

    private String generateTempFileName(String folder, ISMLMetadata metadata) {
        String prefix;
        File fileFolder = new File(folder);
        String string = prefix = metadata.getDocumentType() == 0 ? "definition" : "instance";
        if (!fileFolder.exists() || !fileFolder.isDirectory()) {
            return prefix;
        }
        int counter = 0;
        String[] children = fileFolder.list();
        String fileName = String.valueOf(prefix) + counter;
        int i = 0;
        while (i < children.length) {
            int extensionInx = -1;
            extensionInx = children[i].indexOf(46);
            if (extensionInx > 0) {
                children[i] = children[i].substring(0, extensionInx);
            }
            if (children[i].equals(fileName)) {
                fileName = String.valueOf(prefix) + ++counter;
            }
            ++i;
        }
        fileName = String.valueOf(fileName) + (fileName.startsWith("instance") ? ".xml" : ".xsd");
        return fileName;
    }

    public void disconnect() {
        this.connected = false;
        this.metadataProcessor.write();
    }

    public ISMLDocument[] fetchDocuments(ISMLMetadata metadata) throws RepositoryOperationException {
        return this.fetchDocuments(metadata, false);
    }

    private ISMLDocument[] fetchDocuments(ISMLMetadata metadata, boolean rootContext) throws RepositoryOperationException {
        ArrayList documents = new ArrayList();
        boolean processed = this.fetchIdRetrieval(documents, metadata.getId());
        processed = this.fetchDataRetrieval(processed, documents, this.arrayToMap(metadata.getAliases()), true);
        Collection rules = metadata.getBoundRules() == null ? null : metadata.getBoundRules().values();
        String[] rulesStr = SMLRepositoryUtil.toStringArray(rules);
        processed = this.fetchDataRetrieval(processed, documents, this.arrayToMap(rulesStr), false);
        processed = this.fetchDocumentTypeRetrieval(processed, documents, metadata.getDocumentType());
        this.fetchElementNameRetrieval(processed, documents, metadata.getRootElementName(), rootContext);
        return documents.toArray(new ISMLDocument[documents.size()]);
    }

    private boolean fetchIdRetrieval(List documents, String id) throws RepositoryOperationException {
        if (id != null && id.length() > 0) {
            String rootDirectory;
            String fileName = id.replace('\\', '/');
            if (!fileName.startsWith(rootDirectory = this.getProperty("root.directory", null))) {
                fileName = String.valueOf(rootDirectory) + (rootDirectory.endsWith("\\") || rootDirectory.endsWith("/") ? "" : "/") + fileName;
            }
            if (new File(fileName).isDirectory()) {
                this.loadDocuments(documents, fileName, false);
            } else {
                ISMLDocument smlDocument = this.loadDocument(fileName, false);
                if (smlDocument != null) {
                    documents.add(smlDocument);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISMLDocument loadDocument(String fileName, boolean rootContext) throws RepositoryOperationException {
        SMLFileDocument sMLFileDocument;
        File documentFile = new File(fileName = fileName.replace('\\', '/'));
        if (!documentFile.exists()) {
            return null;
        }
        SMLFileMetadata metadata = new SMLFileMetadata();
        metadata.setId(fileName);
        class RootElementExtractor
        extends AbstractXMLContentDescriber {
            private String rootElementName;

            RootElementExtractor() {
            }

            public int determineType(String line) {
                this.rootElementName = this.retrieveElementName(line);
                return 0;
            }
        }
        RootElementExtractor rootElementExtractor = new RootElementExtractor();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            rootElementExtractor.describe(fis, null);
            metadata.setDocumentType("schema".equals(rootElementExtractor.rootElementName) ? 0 : 1);
            metadata.setRootElementName(rootElementExtractor.rootElementName);
            metadata.setRepositoryMetadata(this.metadataProcessor);
            SMLFileDocument document = rootContext ? new SMLFileResourceInstance((ISMLRepository)this, null) : (metadata.getDocumentType() == 0 ? new SMLFileDefinitionDocument(this) : new SMLFileInstanceDocument(this));
            document.setMetadata(metadata);
            sMLFileDocument = document;
        }
        catch (FileNotFoundException e) {
            try {
                throw new RepositoryOperationException(e.getLocalizedMessage(), e);
                catch (IOException e2) {
                    throw new RepositoryOperationException(e2.getLocalizedMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (fis == null) return sMLFileDocument;
            fis.close();
            return sMLFileDocument;
        }
        catch (IOException iOException) {}
        return sMLFileDocument;
    }

    private boolean fetchDataRetrieval(boolean processed, List documents, Map data, boolean alias) {
        if (data == null || data.size() <= 0) {
            return processed;
        }
        if (!processed) {
            documents.addAll(this.metadataProcessor.retrieveDocuments(data, alias));
        }
        boolean foundAlias = false;
        ArrayList<ISMLDocument> finalList = new ArrayList<ISMLDocument>();
        int i = 0;
        int documentCount = documents.size();
        while (i < documentCount) {
            String[] documentData;
            ISMLDocument document = (ISMLDocument)documents.get(i);
            if (alias) {
                documentData = document.getMetadata().getAliases();
            } else {
                Collection rules = document.getMetadata().getBoundRules() == null ? null : document.getMetadata().getBoundRules().values();
                documentData = SMLRepositoryUtil.toStringArray(rules);
            }
            foundAlias = false;
            if (documentData != null) {
                int j = 0;
                while (j < documentData.length) {
                    if (data.get(documentData[j]) != null) {
                        foundAlias = true;
                    }
                    ++j;
                }
            }
            if (foundAlias) {
                finalList.add(document);
            }
            ++i;
        }
        documents.removeAll(documents);
        documents.addAll(finalList);
        return true;
    }

    private Map arrayToMap(String[] data) {
        Hashtable<String, Boolean> dataMap = new Hashtable<String, Boolean>();
        if (data == null) {
            return dataMap;
        }
        int i = 0;
        while (i < data.length) {
            dataMap.put(data[i], Boolean.TRUE);
            ++i;
        }
        return dataMap;
    }

    private boolean fetchDocumentTypeRetrieval(boolean processed, List documents, int documentType) throws RepositoryOperationException {
        if (documentType < 0) {
            return processed;
        }
        if (!processed) {
            this.loadDocuments(documents, this.getProperty("root.directory", null), false);
        }
        ArrayList<ISMLDocument> finalArrayList = new ArrayList<ISMLDocument>();
        int i = 0;
        int documentsCount = documents.size();
        while (i < documentsCount) {
            ISMLDocument document = (ISMLDocument)documents.get(i);
            if (document.getMetadata().getDocumentType() == documentType) {
                finalArrayList.add(document);
            }
            ++i;
        }
        documents.removeAll(documents);
        documents.addAll(finalArrayList);
        return true;
    }

    private void loadDocuments(List documents, String folder, boolean rootContext) throws RepositoryOperationException {
        File folderFile = new File(folder);
        if (!folderFile.exists() || !folderFile.isDirectory()) {
            return;
        }
        File[] children = folderFile.listFiles();
        int i = 0;
        while (i < children.length) {
            ISMLDocument document;
            if (children[i].isDirectory()) {
                this.loadDocuments(documents, children[i].getAbsolutePath(), rootContext);
            } else if (!children[i].getName().startsWith(".") && (document = this.loadDocument(children[i].getAbsolutePath(), rootContext)) != null) {
                documents.add(document);
            }
            ++i;
        }
    }

    private void fetchElementNameRetrieval(boolean processed, List documents, String rootElementName, boolean rootContext) throws RepositoryOperationException {
        if (rootElementName == null || rootElementName.length() <= 0) {
            return;
        }
        if (!processed) {
            this.loadDocuments(documents, this.getProperty("root.directory", null), rootContext);
        }
        ArrayList<ISMLDocument> finalList = new ArrayList<ISMLDocument>();
        int i = 0;
        int documentsCount = documents.size();
        while (i < documentsCount) {
            ISMLDocument document = (ISMLDocument)documents.get(i);
            if (rootElementName.equals(document.getMetadata().getRootElementName())) {
                finalList.add(document);
            }
            ++i;
        }
        documents.removeAll(documents);
        documents.addAll(finalList);
    }

    public ISMLDocument[] getActiveDocuments() {
        return this.activeDocuments;
    }

    public void setActiveDocuments(ISMLDocument[] documents) {
        this.activeDocuments = documents;
    }

    public ISMLOperation getOperation(String id) {
        return id == null ? null : (ISMLOperation)this.operations.get(id);
    }

    public String[] getSupportedOperations() {
        return this.operations.keySet().toArray(new String[this.operations.size()]);
    }

    public boolean isConnection() {
        return this.connected;
    }

    public void removeDocuments(ISMLMetadata metadata) throws RepositoryOperationException {
        ISMLDocument[] documents = this.fetchDocuments(metadata);
        int i = 0;
        while (i < documents.length) {
            File file = new File(documents[i].getMetadata().getId());
            if (file.exists()) {
                file.delete();
            }
            ++i;
        }
    }

    public ISMLDocument[] retrieveRootDocuments() throws RepositoryOperationException {
        String rootContextNode = this.getProperty("root.context.node", null);
        if (rootContextNode == null) {
            throw new RepositoryOperationException(RepositoryMessages.repositoryMissingContextNode);
        }
        StringTokenizer contextNodes = new StringTokenizer(rootContextNode, ",");
        ArrayList<ISMLDocument> documents = new ArrayList<ISMLDocument>();
        while (contextNodes.hasMoreTokens()) {
            SMLFileMetadata metadata = new SMLFileMetadata();
            metadata.setRootElementName(contextNodes.nextToken().trim());
            ISMLDocument[] fetchedDocuments = this.fetchDocuments(metadata, true);
            int i = 0;
            while (i < fetchedDocuments.length) {
                documents.add(fetchedDocuments[i]);
                ++i;
            }
        }
        return documents.toArray(new ISMLDocument[documents.size()]);
    }

    public MetadataProcessor getMetadataProcessor() {
        return this.metadataProcessor;
    }

    private Object getProperty(String prefix, String name, Object defaultValue) {
        if (this.properties == null) {
            return null;
        }
        Object prop = this.properties.get(String.valueOf(prefix) + name);
        return prop == null ? defaultValue : prop;
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.getProperty(PROPERTY_PREFIX_OBJECT, name, defaultValue);
    }

    public String getProperty(String name, String defaultValue) {
        return (String)this.getProperty(PROPERTY_PREFIX_STRING, name, defaultValue);
    }

    public boolean getProperty(String name, boolean defaultValue) {
        return (Boolean)this.getProperty(PROPERTY_PREFIX_BOOLEAN, name, new Boolean(defaultValue));
    }

    public int getProperty(String name, int defaultValue) {
        return (Integer)this.getProperty(PROPERTY_PREFIX_INT, name, new Integer(defaultValue));
    }

    private void setProperty(String prefix, String name, Object value) {
        if (this.properties == null || name == null || value == null) {
            return;
        }
        this.properties.put(String.valueOf(prefix) + name, value);
    }

    public void setProperty(String name, Object value) {
        this.setProperty(PROPERTY_PREFIX_OBJECT, name, value);
    }

    public void setProperty(String name, String value) {
        String oldValue = this.getProperty(name, null);
        this.setProperty(PROPERTY_PREFIX_STRING, name, value);
        if ((value == null ? oldValue != null : !value.equals(oldValue)) && "root.directory".equals(name)) {
            this.metadataProcessor = new MetadataProcessor(this);
        }
    }

    public void setProperty(String name, boolean value) {
        this.setProperty(PROPERTY_PREFIX_BOOLEAN, name, new Boolean(value));
    }

    public void setProperty(String name, int value) {
        this.setProperty(PROPERTY_PREFIX_INT, name, new Integer(value));
    }
}

