/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.repository.internal.core.MetadataProcessor;
import org.eclipse.cosmos.rm.repository.internal.operations.ModelUnit;
import org.eclipse.cosmos.rm.repository.internal.operations.SMLIFFileHandler;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportOperation {
    private FileSystemSMLRepository repository;

    public ImportOperation(FileSystemSMLRepository repository) {
        this.repository = repository;
    }

    public void importFromFileSystemFile(String resource, String destination) throws RepositoryOperationException {
        if (SMLRepositoryUtil.isNullOrEmpty(resource)) {
            throw new RepositoryOperationException(RepositoryMessages.importErrorNullSmlifFileName);
        }
        if (destination == null) {
            throw new RepositoryOperationException(RepositoryMessages.importErrorNullTargetDirName);
        }
        SMLIFFileHandler handler = new SMLIFFileHandler();
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(resource, (DefaultHandler)handler);
            MetadataProcessor processor = this.repository.getMetadataProcessor();
            byte[] byArray = new byte[5];
            byArray[1] = 1;
            byArray[2] = 4;
            byArray[3] = 3;
            byArray[4] = 2;
            processor.setFields(byArray, new String[]{handler.getName(), handler.getDisplayName(), handler.getBaseURI(), handler.getDescription(), handler.getVersion()});
            for (RuleBinding ruleBinding : handler.getRuleBindingMappings()) {
                processor.addRuleBinding(ruleBinding.getAlias(), new String[]{ruleBinding.getRule()});
            }
            for (ModelUnit modelUnit : handler.getModelUnits()) {
                String targetFile = String.valueOf(destination) + "/" + modelUnit.getFileName();
                this.repository.addDocument(new SMLFileMetadata(targetFile, 1, null, modelUnit.getAliases().toArray(new String[modelUnit.getAliases().size()]), null), new ByteArrayInputStream(modelUnit.getFileContents().toString().getBytes()));
            }
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryOperationException(e.getLocalizedMessage(), e);
        }
        catch (SAXException e) {
            throw new RepositoryOperationException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryOperationException(e.getLocalizedMessage(), e);
        }
    }
}

