/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.reference;

import java.net.URI;
import org.eclipse.cosmos.rm.repository.internal.reference.SMLDocumentReference;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointer;
import org.w3c.dom.Node;

public class SMLQualifiedReference {
    private ISMLRepository repository;
    private String documentReference;
    private String xpointer;

    public SMLQualifiedReference(ISMLRepository repository, String reference) {
        this.repository = repository;
        int anchorInx = reference.indexOf(35);
        this.documentReference = anchorInx >= 0 ? reference.substring(0, anchorInx) : reference;
        this.xpointer = anchorInx >= 0 ? reference.substring(anchorInx + 1) : null;
    }

    public Node resolveReference() {
        try {
            SMLDocumentReference docReference = new SMLDocumentReference(this.repository, this.documentReference);
            docReference.setBase(new URI(""));
            Node documentNode = docReference.retrieveDocumentDOM();
            if (this.xpointer == null || documentNode == null) {
                return documentNode;
            }
            return (Node)XPointer.compile((String)this.xpointer).evaluate((Object)documentNode.getFirstChild());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDocumentReference() {
        return this.documentReference;
    }

    public void setDocumentReference(String documentReference) {
        this.documentReference = documentReference;
    }

    public String getXpointer() {
        return this.xpointer;
    }

    public void setXpointer(String xpointer) {
        this.xpointer = xpointer;
    }
}

