/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import org.eclipse.core.resources.IResource;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.osgi.util.NLS;

public abstract class TextOutput
extends AbstractValidationOutput {
    public void writeMessageToSource(IValidationMessage validationMessage) {
        Object resource = validationMessage.getAttribute("attribute.resource");
        int lineNumber = validationMessage.getAttribute("attribute.line.number", -1);
        int severity = validationMessage.getAttribute("attribute.severity", 0);
        String validationMsg = validationMessage.getAttribute("attribute.message", "");
        String message = this.formatMessage(resource instanceof IResource ? (IResource)resource : null, lineNumber, severity == 2 ? SMLMessages.outputSeverityError : (severity == 1 ? SMLMessages.outputSeverityWarning : SMLMessages.outputSeverityInfo), validationMsg);
        this.writeMessage(message);
    }

    public String formatMessage(IResource resource, int lineNumber, String severity, String validationMsg) {
        StringBuffer formattedMessage = new StringBuffer("");
        if (resource != null) {
            formattedMessage.append(resource.getFullPath().toString()).append(" ");
        }
        if (lineNumber > 0) {
            formattedMessage.append(NLS.bind((String)SMLMessages.outputLineNumber, (Object)String.valueOf(lineNumber))).append(" ");
        }
        formattedMessage.append(NLS.bind((String)SMLMessages.outputSeverity, (Object)severity)).append(" ").append(validationMsg);
        return formattedMessage.toString();
    }

    protected abstract void writeMessage(String var1);
}

