/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.core.IValidationListener;
import org.eclipse.cosmos.rm.validation.internal.core.IValidator;
import org.eclipse.cosmos.rm.validation.internal.core.ValidationEvent;

public abstract class AbstractValidator
implements IValidator {
    private IValidationOutput validationOutput;
    private Collection validationListeners;
    private IProgressMonitor monitor;

    public void initialize(Map validationAttribute) {
        this.validationOutput = (IValidationOutput)validationAttribute.get("validation.output");
        this.monitor = (IProgressMonitor)validationAttribute.get("validation.progress");
    }

    public IValidationOutput getValidationOutput() {
        return this.validationOutput;
    }

    public void setValidationOutput(IValidationOutput validationOutput) {
        this.validationOutput = validationOutput;
    }

    public final void addValidationListener(IValidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    protected final void fireValidationEventOccurred(ValidationEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners != null) {
            for (IValidationListener listener : this.validationListeners) {
                listener.validationErrorOccurred(event);
            }
        }
    }

    protected void setTaskName(String name) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.setTaskName(name);
    }
}

