/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IdentityConstraintDataBuilder
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder";
    private IdentityConstraintStructure identityStruct = new IdentityConstraintStructure();
    private IdentityConstraintDecl identityDecl;
    private boolean elementHit;
    private boolean annotationHit;
    private boolean appInfoHit;
    private LinkedList documentNodeInx = new LinkedList();
    private boolean documentElementHit;
    private boolean dataElementHit;
    private List currentAliases;
    private String currentAlias;
    private boolean aliasElementHit;
    private int currentInx;
    private int currentDepth = -1;
    private String currentURI;
    private String currentElementName;
    private int orphanInx = 0;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        byte currentPhase = this.getCurrentPhase();
        switch (currentPhase) {
            case 1: {
                this.handleDefinitionStartElement(uri, localName, attributes);
                break;
            }
            case 16: {
                this.handleInstanceStartElement(uri, localName, attributes);
                break;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        byte currentPhase = this.getCurrentPhase();
        switch (currentPhase) {
            case 1: {
                this.handleDefinitionCloseElement(uri, localName);
                break;
            }
            case 16: {
                this.handleInstanceCloseElement(uri, localName);
                break;
            }
        }
    }

    private boolean validField(String field) {
        return field != null && field.length() > 0;
    }

    private void handleDefinitionStartElement(String uri, String localName, Attributes attributes) {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if (!this.elementHit && "element".equals(localName)) {
                this.elementHit = true;
                this.currentURI = this.getTargetNamespace();
                this.currentElementName = attributes.getValue("name");
                this.currentElementName = this.currentElementName == null ? attributes.getValue("http://www.w3.org/2001/XMLSchema", "name") : this.currentElementName;
            } else if (this.elementHit && "annotation".equals(localName)) {
                this.annotationHit = true;
            } else if (this.annotationHit && "appinfo".equals(localName)) {
                this.appInfoHit = true;
            }
            return;
        }
        if (this.appInfoHit && "http://schemas.serviceml.org/sml/2007/02".equals(uri)) {
            boolean isUnique;
            boolean isKey = "key".equals(localName);
            boolean isKeyRef = !isKey && "keyref".equals(localName);
            boolean bl = isUnique = !isKeyRef && !isKey && "unique".equals(localName);
            if (isKey || isKeyRef || isUnique) {
                String name = this.retrieveAttribute(attributes, "http://schemas.serviceml.org/sml/2007/02", "name");
                if (!this.validField(name)) {
                    return;
                }
                this.identityDecl = new IdentityConstraintDecl(name);
                final Map clonedPrefixMap = (Map)((Hashtable)super.getPrefixMap()).clone();
                this.identityDecl.setNamespaceContext(new NamespaceContext(){

                    public String getNamespaceURI(String prefix) {
                        String uri = (String)clonedPrefixMap.get(prefix);
                        return uri == null ? "" : uri;
                    }

                    public String getPrefix(String arg0) {
                        return null;
                    }

                    public Iterator getPrefixes(String arg0) {
                        return null;
                    }
                });
                this.identityDecl.setType((byte)(isKey ? 0 : (isKeyRef ? 1 : 2)));
                if (isKeyRef) {
                    this.identityDecl.setReference(this.retrieveAttribute(attributes, "http://schemas.serviceml.org/sml/2007/02", "refer"));
                }
            } else if (this.identityDecl != null) {
                if ("selector".equals(localName)) {
                    String selector = attributes.getValue("xpath");
                    selector = selector == null ? attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "xpath") : selector;
                    this.identityDecl.setSelector(selector);
                } else if ("field".equals(localName)) {
                    String field = attributes.getValue("xpath");
                    field = field == null ? attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "xpath") : field;
                    this.identityDecl.addField(field);
                }
            }
        }
    }

    private String retrieveAttribute(Attributes attributes, String uri, String localName) {
        String value = attributes.getValue(localName);
        return value == null ? attributes.getValue(uri, localName) : value;
    }

    private void handleDefinitionCloseElement(String uri, String localName) {
        if ("http://schemas.serviceml.org/sml/2007/02".equals(uri)) {
            if (this.appInfoHit && this.identityDecl != null) {
                boolean isKey = "key".equals(localName);
                boolean isKeyref = "keyref".equals(localName);
                boolean isUnique = "unique".equals(localName);
                if (isKey || isKeyref || isUnique) {
                    if (this.validField(this.identityDecl.getSelector()) && this.identityDecl.getFields().size() > 0) {
                        this.identityStruct.addDeclaration(this.currentURI, this.currentElementName, this.identityDecl);
                    }
                    this.identityDecl = null;
                }
            } else if (this.appInfoHit && "appinfo".equals(localName)) {
                this.appInfoHit = false;
            } else if (this.annotationHit && "annotation".equals(localName)) {
                this.annotationHit = false;
            }
        } else if ("http://www.w3.org/2001/XMLSchema".equals(uri) && this.elementHit && "element".equals(localName)) {
            this.elementHit = false;
        }
    }

    private void handleInstanceStartElement(String uri, String localName, Attributes attributes) {
        block9: {
            block7: {
                block10: {
                    block8: {
                        if (!"http://schemas.serviceml.org/smlif/2007/02".equals(uri)) break block7;
                        if (this.documentElementHit || !"document".equals(localName)) break block8;
                        this.documentElementHit = true;
                        if (this.currentAliases != null) {
                            this.currentAliases.clear();
                        }
                        break block9;
                    }
                    if (!this.documentElementHit || !"data".equals(localName)) break block10;
                    this.dataElementHit = true;
                    break block9;
                }
                if (!this.documentElementHit || !"alias".equals(localName)) break block9;
                this.aliasElementHit = true;
                break block9;
            }
            if (this.dataElementHit) {
                ++this.currentDepth;
                this.currentInx = this.documentNodeInx.size() - 1 < this.currentDepth ? 0 : (Integer)this.documentNodeInx.get(this.currentDepth) + 1;
                this.documentNodeInx.add(new Integer(this.currentInx));
                if (this.identityStruct.isConstrained(uri, localName)) {
                    int[] primitiveIndices = new int[this.documentNodeInx.size()];
                    int i = 0;
                    while (i < primitiveIndices.length) {
                        primitiveIndices[i] = (Integer)this.documentNodeInx.get(i);
                        ++i;
                    }
                    if (this.currentAliases == null || this.currentAliases.isEmpty()) {
                        this.identityStruct.addOrphanedConstrainedInstance(this.orphanInx++, primitiveIndices);
                    } else {
                        i = 0;
                        int aliasCount = this.currentAliases.size();
                        while (i < aliasCount) {
                            this.identityStruct.addConstrainedInstance((String)this.currentAliases.get(i), primitiveIndices);
                            ++i;
                        }
                    }
                }
            }
        }
    }

    private void handleInstanceCloseElement(String uri, String localName) {
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
                this.currentDepth = -1;
                this.documentNodeInx = new LinkedList();
            } else if (this.aliasElementHit && "alias".equals(localName)) {
                this.aliasElementHit = false;
                if (this.currentAlias != null) {
                    if (this.currentAliases == null) {
                        this.currentAliases = new ArrayList();
                    }
                    this.currentAliases.add(this.currentAlias);
                }
                this.currentAlias = null;
            }
        } else if (this.dataElementHit) {
            --this.currentDepth;
            if (this.documentNodeInx.size() - this.currentDepth >= 3) {
                this.documentNodeInx.removeLast();
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.aliasElementHit) {
            this.currentAlias = this.currentAlias == null ? new String(ch, start, length) : String.valueOf(this.currentAlias) + new String(ch, start, length);
        }
    }

    public Object getDataStructure() {
        return this.identityStruct;
    }

    public static class IdentityConstraintDecl {
        public static final byte KEY_TYPE = 0;
        public static final byte KEY_REF_TYPE = 1;
        public static final byte UNIQUE_TYPE = 2;
        private byte type;
        private String name;
        private List fields;
        private String selector;
        private NamespaceContext namespaceContext;
        private String reference;

        public IdentityConstraintDecl(String name) {
            this.name = name;
            this.fields = new ArrayList();
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public List getFields() {
            return this.fields;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setFields(List fields) {
            this.fields = fields;
        }

        public void addField(String field) {
            this.fields.add(field);
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) {
            this.namespaceContext = namespaceContext;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }
    }

    public static class IdentityConstraintStructure {
        private Map declarations = new Hashtable();
        private Map constrainedInstances = new Hashtable();
        private Map orphanedConstrainedInstances = new Hashtable();

        public void addDeclaration(String uri, String localName, IdentityConstraintDecl identityDecl) {
            Map declarationsPerURI = SMLValidatorUtil.retrieveNestedMap(this.declarations, uri, true);
            ArrayList<IdentityConstraintDecl> listOfConstraints = (ArrayList<IdentityConstraintDecl>)declarationsPerURI.get(localName);
            if (listOfConstraints == null) {
                listOfConstraints = new ArrayList<IdentityConstraintDecl>();
                declarationsPerURI.put(localName, listOfConstraints);
            }
            listOfConstraints.add(identityDecl);
        }

        public void addConstrainedInstance(String alias, int[] indices) {
            this.addToNestedList(this.constrainedInstances, alias, indices);
        }

        public void addOrphanedConstrainedInstance(int orphanInx, int[] indices) {
            this.addToNestedList(this.orphanedConstrainedInstances, String.valueOf(orphanInx), indices);
        }

        private void addToNestedList(Map map, String key, Object value) {
            ArrayList<Object> nestedList = (ArrayList<Object>)map.get(key);
            if (nestedList == null) {
                nestedList = new ArrayList<Object>();
                map.put(key, nestedList);
            }
            nestedList.add(value);
        }

        public boolean isConstrained(String uri, String localName) {
            return this.retrieveConstraint(uri, localName) != null;
        }

        public IdentityConstraintDecl[] retrieveConstraint(String uri, String localName) {
            if (uri == null || localName == null) {
                return null;
            }
            Map declarationsPerURI = (Map)this.declarations.get(uri);
            List constraints = declarationsPerURI == null ? null : (List)declarationsPerURI.get(localName);
            return constraints == null ? null : constraints.toArray(new IdentityConstraintDecl[constraints.size()]);
        }

        public Map getConstrainedInstances() {
            return this.constrainedInstances;
        }

        public Map getDeclarations() {
            return this.declarations;
        }

        public Map getOrphanedConstrainedInstances() {
            return this.orphanedConstrainedInstances;
        }

        public void setConstrainedInstances(Map constrainedInstances) {
            this.constrainedInstances = constrainedInstances;
        }

        public void setDeclarations(Map declarations) {
            this.declarations = declarations;
        }

        public void setOrphanedConstrainedInstances(Map orphanedConstrainedInstances) {
            this.orphanedConstrainedInstances = orphanedConstrainedInstances;
        }
    }
}

