/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NamespaceContextBuilder
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.NamespaceContextBuilder";
    private MappedNamespaceContext mappedNamespace = new MappedNamespaceContext();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public Object getDataStructure() {
        return this.mappedNamespace;
    }

    public static class MappedNamespaceContext
    implements NamespaceContext {
        private Map contextWithURIKey;
        private Map contextWithPrefixKey;

        public String getNamespaceURI(String prefix) {
            if (this.contextWithPrefixKey == null) {
                return null;
            }
            String uri = (String)this.contextWithPrefixKey.get(prefix);
            return uri == null ? "" : uri;
        }

        public String getPrefix(String uri) {
            return (String)this.getPrefixGeneric(uri, true);
        }

        public Iterator getPrefixes(String uri) {
            return (Iterator)this.getPrefixGeneric(uri, false);
        }

        private Object getPrefixGeneric(String uri, boolean first) {
            if (this.contextWithURIKey == null) {
                return null;
            }
            List prefixes = (List)this.contextWithURIKey.get(uri);
            if (prefixes != null && prefixes.size() > 0) {
                return first ? prefixes.get(0) : prefixes.iterator();
            }
            return null;
        }

        public void addEntry(String prefix, String uri) {
            ArrayList<String> listOfPrefix;
            if (this.contextWithURIKey == null) {
                this.contextWithURIKey = new Hashtable();
            }
            if (this.contextWithPrefixKey == null) {
                this.contextWithPrefixKey = new Hashtable();
            }
            if ((listOfPrefix = (ArrayList<String>)this.contextWithURIKey.get(uri)) == null) {
                listOfPrefix = new ArrayList<String>();
                this.contextWithURIKey.put(uri, listOfPrefix);
            }
            listOfPrefix.add(prefix);
            this.contextWithPrefixKey.put(prefix, uri);
        }
    }
}

