/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import org.eclipse.hyades.logging.adapter.util.AdapterMigrationException;
import org.eclipse.hyades.logging.adapter.util.IComponentMigrator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OutputterMigrator
implements IComponentMigrator {
    public Element migrate(Element oldOutputterConfiguration) throws AdapterMigrationException {
        boolean migrated = false;
        Element newOutputterConfiguration = null;
        try {
            Document doc = oldOutputterConfiguration.getOwnerDocument();
            newOutputterConfiguration = (Element)oldOutputterConfiguration.cloneNode(false);
            if (newOutputterConfiguration.hasAttribute("type")) {
                newOutputterConfiguration.removeAttribute("type");
                migrated = true;
            }
            NodeList outputterNodes = oldOutputterConfiguration.getChildNodes();
            int k = 0;
            while (k < outputterNodes.getLength()) {
                Element outputterNode;
                if (outputterNodes.item(k).getNodeType() == 1 && ((outputterNode = (Element)outputterNodes.item(k)).getTagName().equals("op:SingleFileOutputterType") || outputterNode.getTagName().equals("op:LoggingAgentOutputterType"))) {
                    NamedNodeMap outputterTypeAttributeList = outputterNode.getAttributes();
                    int outputterTypeAttributeCount = outputterTypeAttributeList.getLength();
                    int j = 0;
                    while (j < outputterTypeAttributeCount) {
                        Node outputterTypeAttribute = outputterTypeAttributeList.item(j);
                        String propertyName = outputterTypeAttribute.getNodeName();
                        String propertyValue = outputterTypeAttribute.getNodeValue();
                        Element outputterProperty = doc.createElement("pu:Property");
                        outputterProperty.setAttribute("propertyValue", propertyValue);
                        outputterProperty.setAttribute("propertyName", propertyName);
                        newOutputterConfiguration.appendChild(outputterProperty);
                        ++j;
                    }
                    if (outputterTypeAttributeCount > 0) {
                        migrated = true;
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            throw new AdapterMigrationException("bad error", e);
        }
        if (!migrated) {
            newOutputterConfiguration = null;
        }
        return newOutputterConfiguration;
    }
}

