/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractQuery;
import org.eclipse.cosmos.dc.common.api.impl.SimpleDataQueryResult;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.BrokerImpl;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedParameter;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.spec.capabilitiy.ManagementDomainCapability;
import org.w3c.dom.Element;

@ManagedResource
public class ManagementDomain
extends AbstractQuery
implements ManagementDomainCapability {
    private static Class[] supportedTypes = new Class[]{String.class};
    private static String[] supportedDialects = new String[]{"SDMX"};
    public static final String CFG_NAMESPACE = "http://cosmos.eclipse.org/ManagementDomain/1.0";
    public static final String NAMESPACE = "http://cosmos.eclipse.org/dc/managementdomain";
    public static final QName BROKERS_QNAME = new QName("http://cosmos.eclipse.org/dc/managementdomain", "Brokers");
    public static final QName BROKER_QNAME = new QName("http://cosmos.eclipse.org/dc/managementdomain", "Broker");
    public static final QName MGMTDOMAIN_CLASS_QNAME = new QName("http://cosmos.eclipse.org/dc/managementdomain", "Classification");
    private SqlMapClient sqlMapper;
    @ManagedProperty(resourceID=true)
    private String identifier;

    public String getIdentifier() {
        return "ManagementDomainIdentifierValue";
    }

    public ManagementDomain(ContributionManager manager, Element binding) {
        super(manager);
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/local/registry/persistence/sql/SqlMapConfig.xml");
                this.sqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
                reader.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class type = classArray[n];
                if (((IDataFilterService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataTransformService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n3 = classArray.length;
            while (n < n3) {
                Class type = classArray[n];
                if (((IDataTransformService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataResponseService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n4 = classArray.length;
            while (n < n4) {
                Class type = classArray[n];
                if (((IDataResponseService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public String[] getSupportedDialects() {
        return supportedDialects;
    }

    public String[] getSupportedResponses() {
        return null;
    }

    public IDataQueryResult pageQuery(String dialect, String response, String queryString, String dataSource, int max, int start) throws Exception {
        return null;
    }

    public IDataQueryResult query(String dialect, String response, String queryString, String dataSource) throws Exception {
        return null;
    }

    public boolean supportedQuery(String dialect, String response) {
        return false;
    }

    public Class[] getOutputTypes() {
        return null;
    }

    public IDataQueryResult getBrokers(@ManagedParameter(displayName="brokerName") String brokerName, @ManagedParameter(displayName="classification") String classification) throws Exception {
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        Element brNames = XmlUtils.createElement((QName)BROKERS_QNAME);
        List obs = null;
        if (classification == null) {
            obs = brokerName == null ? this.sqlMapper.queryForList("getAllBrokers") : this.sqlMapper.queryForList("getBrokerByName", (Object)brokerName);
        } else if (brokerName == null) {
            obs = this.sqlMapper.queryForList("getBrokers", (Object)classification);
        } else {
            BrokerImpl broker = new BrokerImpl();
            broker.setName(brokerName);
            broker.setClassification(classification);
            obs = this.sqlMapper.queryForList("getBrokerByNameClass", (Object)broker);
        }
        result.setRawResponseCollection(new ArrayList());
        for (BrokerImpl ob : obs) {
            Element brElement = XmlUtils.createElement((QName)BROKER_QNAME);
            brElement.setAttribute("name", ob.getName());
            Date date = ob.getLastMsgTime();
            SimpleDateFormat sdf = new SimpleDateFormat();
            brElement.setAttribute("lastmsgtime", sdf.format(date));
            Element dmClass = XmlUtils.createElement((QName)MGMTDOMAIN_CLASS_QNAME);
            dmClass.setTextContent(ob.getClassification());
            brElement.appendChild(dmClass);
            Element brEPR = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "EndpointReference"));
            Element brAddress = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "Address"));
            brAddress.setTextContent(ob.getEndpointAddress());
            Element brRef = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters"));
            Element brResid = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "ResourceId"));
            brResid.setTextContent(ob.getEndpointResourceId());
            brRef.appendChild(brResid);
            brEPR.appendChild(brAddress);
            brEPR.appendChild(brRef);
            brElement.appendChild(brEPR);
            brNames.appendChild(brElement);
        }
        result.setRawResponse((Object)brNames);
        return result;
    }

    public boolean registerBroker(@ManagedParameter(displayName="endpointAddress") String endpointAddress, @ManagedParameter(displayName="endpointResourceId") String endpointResourceId, @ManagedParameter(displayName="brokerName") String brokerName, @ManagedParameter(displayName="classification") String classification) throws Exception {
        BrokerImpl broker = new BrokerImpl();
        broker.setEndpointAddress(endpointAddress);
        broker.setEndpointResourceId(endpointResourceId);
        broker.setName(brokerName);
        broker.setClassification(classification);
        broker.setLastMsgTime(new Date());
        this.sqlMapper.insert("addBroker", (Object)broker);
        return true;
    }

    public boolean deregisterBroker(@ManagedParameter(displayName="brokerName") String brokerName) throws Exception {
        int rowcount = this.sqlMapper.delete("deleteBroker", (Object)brokerName);
        return rowcount == 1;
    }

    public boolean pingManagementDomain(@ManagedParameter(displayName="brokerName") String brokerName) throws Exception {
        BrokerImpl broker = new BrokerImpl();
        broker.setName(brokerName);
        broker.setLastMsgTime(new Date());
        int rowcount = this.sqlMapper.update("pingManagementDomain", (Object)broker);
        return rowcount == 1;
    }
}

