DRIVER 'org.apache.derby.jdbc.EmbeddedDriver';
CONNECT 'jdbc:derby:D:/cosmos2/workspace3/database/cosmosdb';

CREATE TABLE "Correlation_Temp" ("correlationContainer" INTEGER,"objId" INTEGER,"creationTime" double,"agentIndex" INTEGER );
CREATE TABLE "Correlation_Params"  ("correlationContainer" INTEGER NOT NULL, "agentPath" VARCHAR(255) NOT NULL, "deltaTime" DOUBLE NOT NULL WITH DEFAULT 0,"agentIndex" INTEGER );

CREATE TABLE "AbstractDefaultEvent" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "agent" INT,  "agent_TYPE" SMALLINT,  "agent_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "AbstractTRCCollectionBoundary" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "startTime" DOUBLE PRECISION DEFAULT 0.0,  "collectionMode" VARCHAR(255) DEFAULT 'HEAP_STATISTICS_ONLY',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "configuration" INT,  "configuration_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "AbstractTRCDescription" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "agent" INT,  "agent_TYPE" SMALLINT,  "agent_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "AbstractTRCProcess" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "AbstractTRCView" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "ArithmeticExpression" (  "p_p" VARCHAR(255),  "operator" VARCHAR(255) DEFAULT 'ADD',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "ArithmeticExpression_arguments" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "BinaryExpression" (  "p_p" VARCHAR(255),  "operator" VARCHAR(255) DEFAULT 'LT',  "caseInsensitive" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "instanceQuery" INT,  "instanceQuery_TYPE" SMALLINT,  "instanceQuery_Order" INT,  "leftOperand" INT,  "leftOperand_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "BinaryExpression_rightOperands" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "CBEAvailableSituation" (  "p_p" VARCHAR(255),  "operationDisposition" VARCHAR(255),  "processingDisposition" VARCHAR(255),  "availabilityDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBECommonBaseEvent" (  "p_p" VARCHAR(255),  "localInstanceId" VARCHAR(255),  "globalInstanceId" VARCHAR(255),  "creationTime" DOUBLE PRECISION DEFAULT 0.0,  "timeZone" SMALLINT DEFAULT 0,  "severity" SMALLINT DEFAULT 0,  "priority" SMALLINT DEFAULT 0,  "msg" VARCHAR(8000),  "repeatCount" SMALLINT DEFAULT 0,  "elapsedTime" BIGINT DEFAULT 0,  "sequenceNumber" BIGINT DEFAULT 0,  "version" VARCHAR(255) DEFAULT 'commonbaseevent1_0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "reporterComponentId" INT,  "reporterComponentId_TYPE" SMALLINT,  "sourceComponentId" INT,  "sourceComponentId_TYPE" SMALLINT,  "msgDataElement" INT,  "msgDataElement_TYPE" SMALLINT,  "situation" INT,  "situation_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBECommonBaseEvent_contextDataElements" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "CBECommonBaseEvent_otherData" (  "Id" INT,  "Value" VARCHAR(8000),  "Order" INT);
CREATE TABLE "CBEComponentIdentification" (  "p_p" VARCHAR(255),  "location" VARCHAR(255),  "locationType" VARCHAR(255),  "application" VARCHAR(255),  "executionEnvironment" VARCHAR(255),  "component" VARCHAR(255),  "subComponent" VARCHAR(255),  "componentIdType" VARCHAR(255),  "instanceId" VARCHAR(255),  "processId" VARCHAR(255),  "threadId" VARCHAR(255),  "componentType" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEConfigureSituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEConnectSituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "situationDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEContextDataElement" (  "p_p" VARCHAR(255),  "contextId" VARCHAR(255),  "type" VARCHAR(255),  "name" VARCHAR(255),  "contextValue" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBECreateSituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEDefaultElement" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEDefaultElement_children" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "CBEDefaultElement_values" (  "Id" INT,  "Value" VARCHAR(8000),  "Order" INT);
CREATE TABLE "CBEDefaultEvent" (  "p_p" VARCHAR(255),  "extensionName" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEDefaultEvent_extendedProperties" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "CBEDependencySituation" (  "p_p" VARCHAR(255),  "dependencyDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEDestroySituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEExtendedDataElement" (  "p_p" VARCHAR(255),  "type" VARCHAR(255),  "hexValue" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEFeatureSituation" (  "p_p" VARCHAR(255),  "featureDisposition" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEMsgDataElement" (  "p_p" VARCHAR(255),  "msgId" VARCHAR(255),  "msgIdType" VARCHAR(255),  "msgCatalogId" VARCHAR(255),  "msgCatalog" VARCHAR(255),  "msgLocale" VARCHAR(255),  "msgCatalogType" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEMsgDataElement_msgCatalogTokens" (  "Id" INT,  "Value" VARCHAR(8000),  "Order" INT);
CREATE TABLE "CBEOtherSituation" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEOtherSituation_anyData" (  "Id" INT,  "Value" VARCHAR(8000),  "Order" INT);
CREATE TABLE "CBEReportSituation" (  "p_p" VARCHAR(255),  "reportCategory" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBERequestSituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "situationQualifier" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBESituation" (  "p_p" VARCHAR(255),  "categoryName" VARCHAR(255),  "reasoningScope" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEStartSituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "situationQualifier" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CBEStopSituation" (  "p_p" VARCHAR(255),  "successDisposition" VARCHAR(255),  "situationQualifier" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CorrelationContainer" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "correlationContainerProxy" INT,  "correlationContainerProxy_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CorrelationContainerProxy" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "creationTime" BIGINT DEFAULT 0,  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "monitor" INT,  "monitor_TYPE" SMALLINT,  "monitor_Order" INT,  "correlationEngine" INT,  "correlationEngine_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CorrelationContainerProxy_correlatedAgents" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "CorrelationEngine" (  "p_p" VARCHAR(255),  "type" VARCHAR(255),  "name" VARCHAR(255),  "id" VARCHAR(255),  "description" VARCHAR(255),  "databaseId" INT NOT NULL PRIMARY KEY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CorrelationEntry" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "correlationContainer" INT,  "correlationContainer_TYPE" SMALLINT,  "correlationContainer_Order" INT,  "key" INT,  "key_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CorrelationEntry_value" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "CorrelationQuery" (  "p_p" VARCHAR(255),  "correlationContainerURI" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "CorrelationQuery_deltaTime" (  "Id" INT,  "Value" DOUBLE PRECISION,  "Order" INT);
CREATE TABLE "CorrelationSourceInfo" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "targetInfo" INT,  "targetInfo_TYPE" SMALLINT,  "targetInfo_Order" INT,  "owner" INT,  "owner_TYPE" SMALLINT,  "reference" INT,  "reference_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EAnnotation" (  "p_p" VARCHAR(255),  "source" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eModelElement" INT,  "eModelElement_TYPE" SMALLINT,  "eModelElement_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EAnnotation_contents" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "EAnnotation_details" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "EAnnotation_references" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "EAttribute" (  "p_p" VARCHAR(255),  "emf_iD" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EClass" (  "p_p" VARCHAR(255),  "abstract" CHAR(1) DEFAULT '0',  "interface" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EClass_eSuperTypes" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "EClassifier" (  "p_p" VARCHAR(255),  "instanceClassName" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "ePackage" INT,  "ePackage_TYPE" SMALLINT,  "ePackage_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EDataType" (  "p_p" VARCHAR(255),  "serializable" CHAR(1) DEFAULT '1',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EEnum" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EEnumLiteral" (  "p_p" VARCHAR(255),  "value" INT DEFAULT 0,  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eEnum" INT,  "eEnum_TYPE" SMALLINT,  "eEnum_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EFactory" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EModelElement" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "ENamedElement" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EObject" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EOperation" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eContainingClass" INT,  "eContainingClass_TYPE" SMALLINT,  "eContainingClass_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EOperation_eExceptions" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "EPackage" (  "p_p" VARCHAR(255),  "nsURI" VARCHAR(255),  "nsPrefix" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eSuperPackage" INT,  "eSuperPackage_TYPE" SMALLINT,  "eSuperPackage_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EParameter" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eOperation" INT,  "eOperation_TYPE" SMALLINT,  "eOperation_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EReference" (  "p_p" VARCHAR(255),  "containment" CHAR(1) DEFAULT '0',  "resolveProxies" CHAR(1) DEFAULT '1',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eOpposite" INT,  "eOpposite_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EStringToStringMapEntry" (  "p_p" VARCHAR(255),  "key" VARCHAR(255),  "value" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "EStructuralFeature" (  "p_p" VARCHAR(255),  "changeable" CHAR(1) DEFAULT '1',  "volatile" CHAR(1) DEFAULT '0',  "transient" CHAR(1) DEFAULT '0',  "defaultValueLiteral" VARCHAR(255),  "unsettable" CHAR(1) DEFAULT '0',  "derived" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eContainingClass" INT,  "eContainingClass_TYPE" SMALLINT,  "eContainingClass_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "ETypedElement" (  "p_p" VARCHAR(255),  "ordered" CHAR(1) DEFAULT '1',  "unique" CHAR(1) DEFAULT '1',  "lowerBound" INT DEFAULT 0,  "upperBound" INT DEFAULT 1,  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "eType" INT,  "eType_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "Id_Table" (  "Id" INT);
CREATE TABLE "InstanceQuery" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "LogicalExpression" (  "p_p" VARCHAR(255),  "operator" VARCHAR(255) DEFAULT 'NOT',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "LogicalExpression_arguments" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "NumericFunction" (  "p_p" VARCHAR(255),  "function" VARCHAR(255) DEFAULT 'MAX',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "NumericFunction_arguments" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "Operand" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "query" INT,  "query_TYPE" SMALLINT,  "query_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "OrderByElement" (  "p_p" VARCHAR(255),  "operator" VARCHAR(255) DEFAULT 'ASC',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "searchQuery" INT,  "searchQuery_TYPE" SMALLINT,  "searchQuery_Order" INT,  "operand" INT,  "operand_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "Proxy_Table" (  "URI" VARCHAR(255),  "Table_Name" VARCHAR(255),  "Id" INT,  "Proxy_URI" VARCHAR(255));
CREATE TABLE "Query" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "distinct" CHAR(1) DEFAULT '0',  "count" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "query" INT,  "query_TYPE" SMALLINT,  "query_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "QueryResult" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "query" INT,  "query_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "QueryResult_resultEntries" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "Query_sources" (  "Id" INT,  "Value" VARCHAR(8000),  "Order" INT);
CREATE TABLE "Resource_Table" (  "URI" VARCHAR(255),  "Table_Name" VARCHAR(255),  "Id" INT);
CREATE TABLE "ResultEntry" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SDBDirective" (  "p_p" VARCHAR(255),  "id" VARCHAR(255),  "description" VARCHAR(255),  "directiveString" VARCHAR(255),  "databaseId" INT NOT NULL PRIMARY KEY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SDBMatchPattern" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "value" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SDBRuntime" (  "p_p" VARCHAR(255),  "id" VARCHAR(255),  "name" VARCHAR(255),  "symptomUrl" VARCHAR(255),  "localExternalFileLocation" VARCHAR(255),  "description" VARCHAR(255),  "databaseId" INT NOT NULL PRIMARY KEY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SDBRuntime_directives" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "SDBRuntime_solutions" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "SDBRuntime_symptoms" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "SDBSolution" (  "p_p" VARCHAR(255),  "description" VARCHAR(255),  "id" VARCHAR(255),  "databaseId" INT NOT NULL PRIMARY KEY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SDBSolution_directives" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT,  "Source_Order" INT);
CREATE TABLE "SDBSymptom" (  "p_p" VARCHAR(255),  "description" VARCHAR(255),  "id" VARCHAR(255),  "databaseId" INT NOT NULL PRIMARY KEY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SDBSymptom_patterns" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "SDBSymptom_solutions" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT,  "Source_Order" INT);
CREATE TABLE "SimpleOperand" (  "p_p" VARCHAR(255),  "rawValue" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "feature" INT,  "feature_TYPE" SMALLINT,  "type" INT,  "type_TYPE" SMALLINT,  "valueType" INT,  "valueType_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "SimpleSearchQuery" (  "p_p" VARCHAR(255),  "maxElements" INT DEFAULT 0,  "startWith" INT DEFAULT 0,  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "whereExpression" INT,  "whereExpression_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCAgent" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "type" VARCHAR(255) DEFAULT '_unknown',  "runtimeId" VARCHAR(255),  "startTime" DOUBLE PRECISION DEFAULT 0.0,  "stopTime" DOUBLE PRECISION DEFAULT 0.0,  "collectionMode" VARCHAR(255) DEFAULT 'HEAP_STATISTICS_ONLY',  "version" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "view" INT,  "view_TYPE" SMALLINT,  "process" INT,  "process_TYPE" SMALLINT,  "agentProxy" INT,  "agentProxy_TYPE" SMALLINT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCAgentProxy" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "type" VARCHAR(255) DEFAULT '_unknown',  "runtimeId" VARCHAR(255),  "startTime" DOUBLE PRECISION DEFAULT 0.0,  "stopTime" DOUBLE PRECISION DEFAULT 0.0,  "collectionMode" VARCHAR(255) DEFAULT 'HEAP_STATISTICS_ONLY',  "deltaTime" DOUBLE PRECISION DEFAULT 0.0,  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "processProxy" INT,  "processProxy_TYPE" SMALLINT,  "processProxy_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCAgentProxy_annotations" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "TRCAgentProxy_internalCorrelations" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT);
CREATE TABLE "TRCAgentProxy_relatedAgentProxies" (  "Source_Id" INT,  "Source_TYPE" SMALLINT,  "Target_Order" INT,  "Target_TYPE" SMALLINT,  "Target_Id" INT,  "Source_Order" INT);
CREATE TABLE "TRCAnnotation" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCAnnotation_values" (  "Id" INT,  "Value" VARCHAR(255),  "Order" INT);
CREATE TABLE "TRCConfiguration" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "active" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "agentProxy" INT,  "agentProxy_TYPE" SMALLINT,  "agentProxy_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCEnvironmentVariable" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "value" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "processProxy" INT,  "processProxy_TYPE" SMALLINT,  "processProxy_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCExecParameter" (  "p_p" VARCHAR(255),  "key" VARCHAR(255),  "value" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "processProxy" INT,  "processProxy_TYPE" SMALLINT,  "processProxy_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCFilter" (  "p_p" VARCHAR(255),  "type" VARCHAR(255),  "pattern" VARCHAR(255),  "mode" VARCHAR(255),  "active" CHAR(1),  "operation" VARCHAR(255) DEFAULT '',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "configuration" INT,  "configuration_TYPE" SMALLINT,  "configuration_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCMonitor" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "startTime" DOUBLE PRECISION DEFAULT 0.0,  "stopTime" DOUBLE PRECISION DEFAULT 0.0,  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCNode" (  "p_p" VARCHAR(255),  "runtimeId" VARCHAR(255),  "timezone" DOUBLE PRECISION DEFAULT 0.0,  "port" INT DEFAULT 10002,  "deltaTime" DOUBLE PRECISION DEFAULT 0.0,  "name" VARCHAR(255),  "description" VARCHAR(255),  "ipAddress" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "monitor" INT,  "monitor_TYPE" SMALLINT,  "monitor_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCOption" (  "p_p" VARCHAR(255),  "key" VARCHAR(255),  "value" VARCHAR(8000),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "configuration" INT,  "configuration_TYPE" SMALLINT,  "configuration_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TRCProcessProxy" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "runtimeId" VARCHAR(255),  "pid" INT DEFAULT 0,  "classpath" VARCHAR(255),  "parameters" VARCHAR(255),  "launchMode" INT DEFAULT 0,  "location" VARCHAR(255),  "vmArguments" VARCHAR(255),  "active" CHAR(1) DEFAULT '0',  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "node" INT,  "node_TYPE" SMALLINT,  "node_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "TimeBasedCorrelationQuery" (  "p_p" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "UnresolvedCorrelation" (  "p_p" VARCHAR(255),  "contextId" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "agent" INT,  "agent_TYPE" SMALLINT,  "agent_Order" INT,  "Is_EMF_Proxy" CHAR(1));
CREATE TABLE "WhereExpression" (  "p_p" VARCHAR(255),  "name" VARCHAR(255),  "id" INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,  "Is_EMF_Proxy" CHAR(1));

CREATE  INDEX ADE_PP ON "AbstractDefaultEvent" ("id" ASC, "p_p" ASC, "agent" ASC, "agent_Order" ASC);
CREATE  INDEX DEF_PP ON "CBEDefaultEvent" ("p_p" ASC);
CREATE  INDEX CBE_PP ON "CBECommonBaseEvent" ("p_p" ASC);
CREATE  INDEX EDE_PP ON "CBEExtendedDataElement" ("p_p" ASC);
CREATE  INDEX SIT_PP ON "CBESituation" ("p_p" ASC);
CREATE  INDEX SITREP_PP ON "CBEReportSituation" ("p_p" ASC);
CREATE  INDEX COMPIND_PP ON "CBEComponentIdentification" ("p_p" ASC);
CREATE  INDEX CONTDE_PP ON "CBEContextDataElement" ("p_p" ASC);
CREATE  INDEX AGENT_PP ON "TRCAgent" ("p_p" ASC);

CREATE  INDEX DEF_V ON "CBEDefaultElement_values" ("Id" ASC, "Order" ASC);
CREATE  INDEX CBE_OD ON "CBECommonBaseEvent_otherData" ("Id" ASC, "Order" ASC);

CREATE  INDEX DEF_C ON "CBEDefaultElement_children" ("Source_Id" ASC, "Target_Order" ASC, "Target_Id" ASC);
CREATE  INDEX DEF_EP ON "CBEDefaultEvent_extendedProperties" ("Source_Id" ASC, "Target_Order" ASC, "Target_Id" ASC);
CREATE  INDEX EDE_CDE ON "CBECommonBaseEvent_contextDataElements" ("Source_Id" ASC, "Target_Order" ASC, "Target_Id" ASC);

CREATE  INDEX CORR_EN ON "CorrelationEntry" ("p_p" ASC,"correlationContainer" ASC);
CREATE  INDEX CORR_ENV ON "CorrelationEntry_value" ("Source_Id" ASC, "Target_Order" ASC, "Target_Id" ASC);

CREATE  INDEX CBE_TIME ON "CBECommonBaseEvent" ("creationTime" ASC, "sequenceNumber" ASC);
CREATE  INDEX CORR_TMP ON "Correlation_Temp" ("creationTime" ASC);

CREATE  INDEX PROX_TB ON "Proxy_Table" ("URI" ASC, "Table_Name" ASC, "Id" ASC,"Proxy_URI" ASC );
CREATE  INDEX RES_TB ON "Resource_Table" ("URI" ASC, "Table_Name" ASC, "Id" ASC );

CREATE  INDEX SIT_AVAIL ON "CBEAvailableSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_CONF ON "CBEConfigureSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_CONN ON "CBEConnectSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_CRE ON "CBECreateSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_DEP ON "CBEDependencySituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_DESTR ON "CBEDestroySituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_FEAT ON "CBEFeatureSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_OTHER ON "CBEOtherSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_OTHER_ANY ON "CBEOtherSituation_anyData" ("Id" ASC);
CREATE  INDEX SIT_REP ON "CBEReportSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_REQ ON "CBERequestSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_START ON "CBEStartSituation" ("id" ASC,"p_p" ASC);
CREATE  INDEX SIT_STOP ON "CBEStopSituation" ("id" ASC,"p_p" ASC);

