/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi.builders.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.Constants;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class XmlPrimtiveAssertion
implements Assertion {
    OMElement element;
    boolean isOptional;

    public XmlPrimtiveAssertion(OMElement element) {
        this.setValue(element);
        this.setOptionality(element);
    }

    public QName getName() {
        return this.element != null ? this.element.getQName() : null;
    }

    public void setValue(OMElement element) {
        this.element = element;
    }

    public OMElement getValue() {
        return this.element;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public PolicyComponent normalize() {
        if (this.isOptional) {
            Policy policy = new Policy();
            ExactlyOne exactlyOne = new ExactlyOne();
            All all = new All();
            OMElement omElement = this.element.cloneOMElement();
            omElement.removeAttribute(omElement.getAttribute(Constants.Q_ELEM_OPTIONAL_ATTR));
            all.addPolicyComponent(new XmlPrimtiveAssertion(omElement));
            exactlyOne.addPolicyComponent(all);
            exactlyOne.addPolicyComponent(new All());
            policy.addPolicyComponent(exactlyOne);
            return policy;
        }
        return this;
    }

    public PolicyComponent normalize(boolean isDeep) {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        if (this.element == null) {
            throw new RuntimeException("Wrapped Element is not set");
        }
        this.element.serialize(writer);
    }

    public final short getType() {
        return 5;
    }

    private void setOptionality(OMElement element) {
        OMAttribute attribute = element.getAttribute(Constants.Q_ELEM_OPTIONAL_ATTR);
        this.isOptional = attribute != null ? new Boolean(attribute.getAttributeValue()) : false;
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (policyComponent.getType() != 5) {
            return false;
        }
        return this.getName().equals(((Assertion)policyComponent).getName());
    }
}

