/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IArchiveLockManager;

class DocArchiveLockManager
implements IArchiveLockManager {
    protected static Logger log;
    protected HashMap channels = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.archive.DocArchiveLockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz.getName());
    }

    DocArchiveLockManager() {
    }

    protected synchronized FileChannel getChannel(String name) throws IOException {
        Channel channel = (Channel)this.channels.get(name);
        if (channel == null) {
            channel = new Channel();
            channel.file = new RandomAccessFile(name, "rw");
            channel.channel = channel.file.getChannel();
            this.channels.put(name, channel);
        }
        ++channel.refCount;
        return channel.channel;
    }

    protected synchronized void releaseChannel(String name) {
        Channel channel = (Channel)this.channels.get(name);
        if (channel != null) {
            --channel.refCount;
            if (channel.refCount == 0) {
                this.channels.remove(name);
                try {
                    channel.file.close();
                    new File(name).delete();
                }
                catch (IOException ex) {
                    log.log(Level.FINE, "failed to close the file", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object lock(String name) throws IOException {
        channel = this.getChannel(name);
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var3_3 = channel;
                synchronized (var3_3) {
                    try {
                        fLock = channel.lock();
                        lock = new Lock();
                        lock.name = name;
                        lock.lock = fLock;
                        return lock;
                    }
                    catch (OverlappingFileLockException v0) {
                        try {
                            channel.wait();
                        }
                        catch (InterruptedException v1) {}
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ex) {
            this.releaseChannel(name);
            throw ex;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object lockObj) {
        if (lockObj instanceof Lock) {
            Lock lock = (Lock)lockObj;
            FileLock fLock = lock.lock;
            FileChannel channel = fLock.channel();
            try {
                fLock.release();
            }
            catch (Exception ex) {
                log.log(Level.FINE, "exception occus while release the lock", ex);
            }
            FileChannel fileChannel = channel;
            synchronized (fileChannel) {
                channel.notify();
            }
            this.releaseChannel(lock.name);
        }
    }

    private class Channel {
        RandomAccessFile file;
        FileChannel channel;
        int refCount;

        private Channel() {
        }
    }

    private class Lock {
        String name;
        FileLock lock;

        private Lock() {
        }
    }
}

