/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencable;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefValue;

public abstract class ReferencableStructure
extends Structure
implements IReferencable {
    public static final String LIB_REFERENCE_MEMBER = "libReference";
    protected ArrayList clients = new ArrayList();
    protected StructRefValue libReference = null;
    protected ArrayList clientStructures = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.ReferencableStructure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public boolean isReferencable() {
        return true;
    }

    public void addClient(DesignElement client, String propName) {
        this.clients.add(new BackRef(client, propName));
    }

    public void dropClient(DesignElement client) {
        int i = 0;
        while (i < this.clients.size()) {
            if (((BackRef)this.clients.get((int)i)).element == client) {
                this.clients.remove(i);
                return;
            }
            ++i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public List getClientList() {
        return this.clients;
    }

    public boolean hasReferences() {
        return !this.clients.isEmpty();
    }

    public void broadcast(NotificationEvent ev) {
        ev.setDeliveryPath(5);
        int i = 0;
        while (i < this.clients.size()) {
            ((BackRef)this.clients.get((int)i)).element.broadcast(ev);
            ++i;
        }
    }

    public abstract boolean isReferencableProperty(String var1);

    protected Object getIntrinsicProperty(String propName) {
        if (LIB_REFERENCE_MEMBER.equalsIgnoreCase(propName)) {
            return this.libReference;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Object getProperty(Module module, PropertyDefn propDefn) {
        ReferencableStructure refStruct;
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        Object value = this.getLocalProperty(module, propDefn);
        if (value != null) {
            return value;
        }
        if (this.libReference != null && (refStruct = this.libReference.getTargetStructure()) != null) {
            Library root = null;
            if (module != null) {
                root = module.getLibraryWithNamespace(this.libReference.getLibraryNamespace(), 1);
            }
            if ((value = refStruct.getProperty(root, propDefn)) != null) {
                return value;
            }
        }
        if (value == null) {
            return propDefn.getDefault();
        }
        return value;
    }

    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        if (this.libReference != null && !this.libReference.isResolved()) {
            PropertyDefn libRefDefn = (PropertyDefn)this.getDefn().getMember(LIB_REFERENCE_MEMBER);
            if (!$assertionsDisabled && libRefDefn == null) {
                throw new AssertionError();
            }
            StructRefPropertyType type = (StructRefPropertyType)libRefDefn.getType();
            type.resolve(module, libRefDefn, this.libReference);
            if (this.libReference.isResolved()) {
                this.libReference.getTargetStructure().addClientStructure(this);
            }
        }
        return super.getLocalProperty(module, propDefn);
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (LIB_REFERENCE_MEMBER.equalsIgnoreCase(propName)) {
            this.updateReference(this.libReference, (StructRefValue)value);
            this.libReference = (StructRefValue)value;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void updateReference(StructRefValue oldRef, StructRefValue newRef) {
        ReferencableStructure target;
        if (oldRef != null && (target = oldRef.getTargetStructure()) != null) {
            target.dropClientStructure(this);
        }
        if (newRef != null && (target = newRef.getTargetStructure()) != null) {
            target.addClientStructure(this);
        }
    }

    public List validate(Module module, DesignElement element) {
        ArrayList<SemanticError> errors = new ArrayList<SemanticError>();
        StructRefValue ref = (StructRefValue)this.getLocalProperty(module, LIB_REFERENCE_MEMBER);
        if (ref != null && !ref.isResolved()) {
            errors.add(new SemanticError(element, new String[]{this.getDefn().getName(), this.getReferencableProperty(), this.libReference.getQualifiedReference()}, "Error.SemanticError.INVALID_LIBRARY_REFERENCE"));
            return errors;
        }
        return errors;
    }

    protected Object clone() throws CloneNotSupportedException {
        ReferencableStructure struct = (ReferencableStructure)super.clone();
        struct.libReference = null;
        struct.clients = new ArrayList();
        struct.clientStructures = new ArrayList();
        if (this.libReference == null) {
            return struct;
        }
        Iterator propIter = this.getDefn().getPropertyIterator();
        block0: while (propIter.hasNext()) {
            PropertyDefn prop = (PropertyDefn)propIter.next();
            if (struct.getLocalProperty(null, prop) != null || LIB_REFERENCE_MEMBER.equals(prop.getName())) continue;
            StructRefValue libRef = this.libReference;
            while (libRef != null) {
                ReferencableStructure libStructure = libRef.getTargetStructure();
                if (libStructure == null) {
                    struct.libReference = new StructRefValue(this.libReference.getLibraryNamespace(), this.libReference.getName());
                    return struct;
                }
                Object value = libStructure.getLocalProperty(null, prop);
                if (value != null) {
                    struct.setProperty(prop, value);
                    continue block0;
                }
                libRef = (StructRefValue)libStructure.getLocalProperty(null, LIB_REFERENCE_MEMBER);
            }
        }
        return struct;
    }

    public void addClientStructure(Structure struct) {
        this.clientStructures.add(struct);
    }

    public void dropClientStructure(Structure struct) {
        if (!$assertionsDisabled && !this.clientStructures.contains(struct)) {
            throw new AssertionError();
        }
        this.clientStructures.remove(struct);
    }

    public List getClientStructures() {
        return this.clientStructures;
    }
}

