/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.net.URL;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.command.CssCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;

public class CssStyleSheetHandleAdapter {
    private final Module module;
    private final DesignElement element;

    public CssStyleSheetHandleAdapter(Module module, DesignElement element) {
        this.module = module;
        this.element = element;
    }

    public final void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(sheetHandle.getStyleSheet());
    }

    public final void addCss(String fileName) throws SemanticException {
        if (fileName == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(fileName);
    }

    public final void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.dropCss(sheetHandle.getStyleSheet());
    }

    public final boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        if (sheetHandle == null) {
            return false;
        }
        String fileName = sheetHandle.getFileName();
        CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), fileName);
        return sheet != null;
    }

    public final boolean canAddCssStyleSheet(String fileName) {
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        if (fileName == null) {
            return false;
        }
        URL url = this.module.findResource(fileName, 3);
        if (url == null) {
            return false;
        }
        CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url.getFile());
        return sheet == null;
    }

    public final boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        if (sheetHandle == null) {
            return false;
        }
        String fileName = sheetHandle.getFileName();
        return this.canAddCssStyleSheet(fileName);
    }

    public final void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.reloadCss(sheetHandle.getStyleSheet());
    }
}

