/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ThemeStyleNameValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.interfaces.IThemeModel;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.util.ModelUtil;

public class Theme
extends ReferenceableElement
implements IThemeModel,
ICssStyleSheetOperation {
    private List cachedStyleNames = new ArrayList();
    private ICssStyleSheetOperation operation = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.elements.Theme");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Theme() {
        this.initSlots();
    }

    public Theme(String theName) {
        super(theName);
        this.initSlots();
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTheme(this);
    }

    public String getElementName() {
        return "Theme";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ThemeHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ThemeHandle(module, this);
        }
        return (ThemeHandle)this.handle;
    }

    public ContainerSlot getSlot(int slot) {
        if (!$assertionsDisabled && slot != 0) {
            throw new AssertionError();
        }
        return this.slots[0];
    }

    public List getAllStyles() {
        ArrayList<StyleElement> styleList = new ArrayList<StyleElement>();
        styleList.addAll(CssNameManager.getStyles(this));
        int i = 0;
        while (i < this.slots[0].getCount()) {
            StyleElement tmpStyle = (StyleElement)this.slots[0].getContent(i);
            int pos = ModelUtil.getStylePosition(styleList, tmpStyle.getFullName());
            if (pos == -1) {
                styleList.add(tmpStyle);
            } else {
                styleList.remove(pos);
                styleList.add(tmpStyle);
            }
            ++i;
        }
        return styleList;
    }

    public StyleElement findStyle(String styleName) {
        if (styleName == null) {
            return null;
        }
        List styles = this.getAllStyles();
        int i = 0;
        while (i < styles.size()) {
            StyleElement style = (StyleElement)styles.get(i);
            if (styleName.equals(style.getFullName())) {
                return style;
            }
            ++i;
        }
        return null;
    }

    public List checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        List tmpErrors = super.checkContent(module, containerInfo, content);
        if (!tmpErrors.isEmpty()) {
            return tmpErrors;
        }
        tmpErrors.addAll(ThemeStyleNameValidator.getInstance().validateForAddingStyle((ThemeHandle)this.getHandle(module), content.getFullName()));
        return tmpErrors;
    }

    public int dropCss(CssStyleSheet css) {
        if (this.operation == null) {
            return -1;
        }
        return this.operation.dropCss(css);
    }

    public void addCss(CssStyleSheet css) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.addCss(css);
    }

    public void insertCss(CssStyleSheet css, int index) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.insertCss(css, index);
    }

    public List getCsses() {
        if (this.operation == null) {
            return Collections.EMPTY_LIST;
        }
        return this.operation.getCsses();
    }

    public void makeUniqueName(DesignElement element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof StyleElement)) {
            return;
        }
        if (element.getRoot() != null) {
            return;
        }
        String name = StringUtil.trimString(element.getName());
        if ((name = NamePropertyType.validateName(name)) == null) {
            name = ModelMessages.getMessage("New." + element.getDefn().getName()).trim();
        }
        List styles = this.slots[0].getContents();
        ArrayList<String> ns = new ArrayList<String>(styles.size());
        int i = 0;
        while (i < styles.size()) {
            ns.add(((StyleElement)styles.get(i)).getName());
            ++i;
        }
        int index = 0;
        String baseName = name;
        while (this.cachedStyleNames.contains(name) || ns.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        element.setName(name.trim());
        this.cachedStyleNames.add(name);
    }

    public void dropCachedName(String name) {
        this.cachedStyleNames.remove(name);
    }
}

