/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.BooleanPropertyType;
import org.eclipse.birt.report.model.metadata.ChoicePropertyType;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ClassInfo;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.ContentElementPropertyType;
import org.eclipse.birt.report.model.metadata.DateTimePropertyType;
import org.eclipse.birt.report.model.metadata.DimensionPropertyType;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyType;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ExpressionPropertyType;
import org.eclipse.birt.report.model.metadata.ExtendsPropertyType;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.FloatPropertyType;
import org.eclipse.birt.report.model.metadata.HTMLPropertyType;
import org.eclipse.birt.report.model.metadata.IntegerPropertyType;
import org.eclipse.birt.report.model.metadata.ListPropertyType;
import org.eclipse.birt.report.model.metadata.LiteralStringPropertyType;
import org.eclipse.birt.report.model.metadata.MemberKeyPropertyType;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.NumberPropertyType;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ResourceKeyPropertyType;
import org.eclipse.birt.report.model.metadata.ScriptPropertyType;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;
import org.eclipse.birt.report.model.metadata.StringPropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.metadata.URIPropertyType;
import org.eclipse.birt.report.model.metadata.XMLPropertyType;
import org.eclipse.birt.report.model.metadata.validators.IValueValidator;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;

public final class MetaDataDictionary
implements IMetaDataDictionary {
    private static MetaDataDictionary instance;
    private HashMap elementNameMap = new HashMap();
    private Map elementXmlNameMap = new HashMap();
    private HashMap extensionNameMap = null;
    private ElementDefn style = null;
    private PropertyType[] propertyTypes = new PropertyType[25];
    private HashMap choiceSets = new HashMap();
    private HashMap structures = new HashMap();
    private Map classes = new LinkedHashMap();
    private boolean useElementID = false;
    private HashMap predefinedStyles = new HashMap();
    private Map valueValidators = new HashMap();
    private Map semanticValidators = new HashMap();
    private boolean useValidationTrigger = false;
    private IEncryptionHelper encryptionHelper = SimpleEncryptionHelper.getInstance();
    private IScriptableObjectClassInfo scriptableFactory = null;
    private Map extensionFactoryStyles = null;
    private Map functions = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.metadata.MetaDataDictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new MetaDataDictionary();
    }

    private MetaDataDictionary() {
        this.addPropertyType(new StringPropertyType());
        this.addPropertyType(new LiteralStringPropertyType());
        this.addPropertyType(new NumberPropertyType());
        this.addPropertyType(new IntegerPropertyType());
        this.addPropertyType(new DimensionPropertyType());
        this.addPropertyType(new ColorPropertyType());
        this.addPropertyType(new ChoicePropertyType());
        this.addPropertyType(new BooleanPropertyType());
        this.addPropertyType(new ExpressionPropertyType());
        this.addPropertyType(new HTMLPropertyType());
        this.addPropertyType(new ResourceKeyPropertyType());
        this.addPropertyType(new URIPropertyType());
        this.addPropertyType(new DateTimePropertyType());
        this.addPropertyType(new XMLPropertyType());
        this.addPropertyType(new NamePropertyType());
        this.addPropertyType(new FloatPropertyType());
        this.addPropertyType(new ElementRefPropertyType());
        this.addPropertyType(new StructPropertyType());
        this.addPropertyType(new ExtendsPropertyType());
        this.addPropertyType(new ScriptPropertyType());
        this.addPropertyType(new StructRefPropertyType());
        this.addPropertyType(new ListPropertyType());
        this.addPropertyType(new MemberKeyPropertyType());
        this.addPropertyType(new ElementPropertyType());
        this.addPropertyType(new ContentElementPropertyType());
    }

    private void addPropertyType(PropertyType propType) {
        int typeCode = propType.getTypeCode();
        if (!$assertionsDisabled && this.propertyTypes[typeCode] != null) {
            throw new AssertionError();
        }
        this.propertyTypes[typeCode] = propType;
    }

    public static MetaDataDictionary getInstance() {
        return instance;
    }

    public IElementDefn getElement(String name) {
        return this.elementNameMap.get(name) == null ? (this.extensionNameMap == null ? null : this.extensionNameMap.get(name)) : this.elementNameMap.get(name);
    }

    public IElementDefn getElementByXmlName(String name) {
        return (IElementDefn)this.elementXmlNameMap.get(name);
    }

    void build() throws MetaDataException {
        this.buildPropertyTypes();
        this.buildElementDefinitions();
        this.buildXmlNameMaps();
        this.validateConstants();
        this.buildStructures();
    }

    private void buildXmlNameMaps() {
        Iterator iter = this.elementNameMap.values().iterator();
        while (iter.hasNext()) {
            ElementDefn tmpDefn = (ElementDefn)iter.next();
            this.elementXmlNameMap.put(tmpDefn.getXmlName(), tmpDefn);
        }
    }

    private void validateConstants() throws MetaDataException {
        int i = 0;
        while (i < this.propertyTypes.length) {
            if (!$assertionsDisabled && this.propertyTypes[i].getTypeCode() != i) {
                throw new AssertionError();
            }
            ++i;
        }
        this.validateElement("Style");
        this.validateElement("ReportElement");
        this.validateElement("ReportDesign");
    }

    private void validateElement(String name) throws MetaDataException {
        if (this.getElement(name) == null) {
            throw new MetaDataException(new String[]{name}, "ELEMENT_NAME_CONST");
        }
    }

    private void buildPropertyTypes() {
        int i = 0;
        while (i < this.propertyTypes.length) {
            this.propertyTypes[i].build();
            ++i;
        }
    }

    private void buildElementDefinitions() throws MetaDataException {
        this.style = (ElementDefn)this.getElement("Style");
        if (this.style == null) {
            throw new MetaDataException("STYLE_TYPE_MISSING");
        }
        this.style.build();
        ElementDefn report = (ElementDefn)this.getElement("ReportDesign");
        if (report == null) {
            throw new MetaDataException("CONSTRUCTOR_EXISTING");
        }
        report.build();
        Iterator iter = this.elementNameMap.values().iterator();
        while (iter.hasNext()) {
            ElementDefn tmpDefn = (ElementDefn)iter.next();
            tmpDefn.build();
        }
    }

    private void buildStructures() throws MetaDataException {
        Iterator iter = this.structures.values().iterator();
        while (iter.hasNext()) {
            StructureDefn type = (StructureDefn)iter.next();
            type.build();
        }
    }

    public PropertyType getPropertyType(int type) {
        if (!($assertionsDisabled || type >= 0 && type < this.propertyTypes.length)) {
            throw new AssertionError();
        }
        return this.propertyTypes[type];
    }

    public List getPropertyTypes() {
        return Arrays.asList(this.propertyTypes);
    }

    public PropertyType getPropertyType(String xmlName) {
        int i = 0;
        while (i < this.propertyTypes.length) {
            if (this.propertyTypes[i].getName().equalsIgnoreCase(xmlName)) {
                return this.propertyTypes[i];
            }
            ++i;
        }
        return null;
    }

    public IElementDefn getStyle() {
        return this.style;
    }

    public static void reset() {
        instance = new MetaDataDictionary();
    }

    void addElementDefn(ElementDefn type) throws MetaDataException {
        String name = type.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_ELEMENT_NAME");
        }
        if (this.elementNameMap.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_ELEMENT_NAME");
        }
        this.elementNameMap.put(name, type);
    }

    public void enableElementID() {
        this.useElementID = true;
    }

    public boolean useID() {
        return this.useElementID;
    }

    void addPredefinedStyle(PredefinedStyle style) throws MetaDataException {
        String name = style.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_STYLE_NAME");
        }
        if (this.predefinedStyles.get(name) != null) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_STYLE_NAME");
        }
        this.predefinedStyles.put(name, style);
    }

    public PredefinedStyle getPredefinedStyle(String name) {
        return (PredefinedStyle)this.predefinedStyles.get(name);
    }

    public boolean isEmpty() {
        return this.elementNameMap.isEmpty() && this.predefinedStyles.isEmpty();
    }

    void addChoiceSet(ChoiceSet choiceSet) throws MetaDataException {
        String name = choiceSet.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_CHOICE_SET_NAME");
        }
        if (this.choiceSets.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_CHOICE_SET_NAME");
        }
        this.choiceSets.put(name, choiceSet);
    }

    public IChoiceSet getChoiceSet(String choiceSetName) {
        String newName = choiceSetName;
        if ("aggregationFunction".equalsIgnoreCase(newName)) {
            newName = "aggregationFunction";
        }
        return (ChoiceSet)this.choiceSets.get(newName);
    }

    void addStructure(StructureDefn struct) throws MetaDataException {
        String name = struct.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_STRUCT_NAME");
        }
        if (this.structures.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_STRUCT_NAME");
        }
        this.structures.put(name, struct);
    }

    public IStructureDefn getStructure(String name) {
        return (IStructureDefn)this.structures.get(name);
    }

    public List getElements() {
        return new ArrayList(this.elementNameMap.values());
    }

    public List getStructures() {
        return new ArrayList(this.structures.values());
    }

    public List getPredefinedStyles() {
        return new ArrayList(this.predefinedStyles.values());
    }

    public List getClasses() {
        return new ArrayList(this.classes.values());
    }

    public IClassInfo getClass(String name) {
        return (ClassInfo)this.classes.get(name);
    }

    void addClass(ClassInfo classDefn) throws MetaDataException {
        if (StringUtil.isBlank(classDefn.getName())) {
            throw new MetaDataException("MISSING_CLASS_NAME");
        }
        if (this.classes.get(classDefn.getName()) != null) {
            throw new MetaDataException(new String[]{classDefn.getName()}, "DUPLICATE_CLASS_NAME");
        }
        this.classes.put(classDefn.getName(), classDefn);
    }

    public List getExtensions() {
        if (this.extensionNameMap == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.extensionNameMap.values());
    }

    public IElementDefn getExtension(String name) {
        if (this.extensionNameMap == null) {
            return null;
        }
        return (IElementDefn)this.extensionNameMap.get(name);
    }

    void addExtension(ExtensionElementDefn extDefn) throws MetaDataException {
        if (!$assertionsDisabled && extDefn == null) {
            throw new AssertionError();
        }
        if (StringUtil.isBlank(extDefn.getName())) {
            throw new MetaDataException("MISSING_EXTENSION_NAME");
        }
        if (this.extensionNameMap == null) {
            this.extensionNameMap = new HashMap();
        }
        if (this.elementNameMap.get(extDefn.getName()) != null || this.extensionNameMap.get(extDefn.getName()) != null) {
            throw new MetaDataException(new String[]{extDefn.getName()}, "DUPLICATE_EXTENSION_NAME");
        }
        this.extensionNameMap.put(extDefn.getName(), extDefn);
    }

    void addValueValidator(IValueValidator validator) throws MetaDataException {
        String name = validator.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_VALIDATOR_NAME");
        }
        if (this.valueValidators.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_VALIDATOR_NAME");
        }
        this.valueValidators.put(name, validator);
    }

    public IValueValidator getValueValidator(String name) {
        return (IValueValidator)this.valueValidators.get(name);
    }

    public void addSemanticValidator(AbstractSemanticValidator validator) throws MetaDataException {
        String name = validator.getName();
        if (StringUtil.isBlank(name)) {
            throw new MetaDataException("MISSING_VALIDATOR_NAME");
        }
        if (this.semanticValidators.containsKey(name)) {
            throw new MetaDataException(new String[]{name}, "DUPLICATE_VALIDATOR_NAME");
        }
        this.semanticValidators.put(name, validator);
    }

    public AbstractSemanticValidator getSemanticValidator(String name) {
        return (AbstractSemanticValidator)this.semanticValidators.get(name);
    }

    public boolean useValidationTrigger() {
        return this.useValidationTrigger;
    }

    public void setUseValidationTrigger(boolean useValidationTrigger) {
        this.useValidationTrigger = useValidationTrigger;
    }

    public IEncryptionHelper getEncryptionHelper() {
        return this.encryptionHelper;
    }

    void setEncryptionHelper(IEncryptionHelper encryptionHelper) {
        this.encryptionHelper = encryptionHelper;
    }

    public IScriptableObjectClassInfo getScriptableFactory() {
        return this.scriptableFactory;
    }

    void setScriptableFactory(IScriptableObjectClassInfo scriptableFactory) {
        this.scriptableFactory = scriptableFactory;
    }

    public List getExtensionFactoryStyles() {
        if (this.extensionFactoryStyles != null) {
            return new ArrayList(this.extensionFactoryStyles.values());
        }
        return Collections.EMPTY_LIST;
    }

    void addExtensionFactoryStyle(Style style) {
        if (this.extensionFactoryStyles == null) {
            this.extensionFactoryStyles = new HashMap();
        }
        if (this.extensionFactoryStyles.containsKey(style.getName())) {
            MetaLogManager.log("the extension predefined style has duplicated name, will be ignored.");
        } else {
            this.extensionFactoryStyles.put(style.getName(), style);
        }
    }

    public List getFunctions() {
        if (this.functions == null) {
            this.functions = new LinkedHashMap();
            ArrayList<String> names = new ArrayList<String>();
            IChoice[] choices = this.getChoiceSet("aggregationFunction").getChoices();
            int i = 0;
            while (i < choices.length) {
                IChoice choice = choices[i];
                names.add(choice.getName());
                ++i;
            }
            IClassInfo clazz = this.getClass("Total");
            MetaDataDictionary.addMatchedFunctions(this.functions, clazz.getMethods(), names);
            clazz = this.getClass("Finance");
            MetaDataDictionary.addMatchedFunctions(this.functions, clazz.getMethods(), names);
            names.clear();
        }
        if (!$assertionsDisabled && this.functions == null) {
            throw new AssertionError();
        }
        ArrayList retList = new ArrayList();
        retList.addAll(this.functions.values());
        return retList;
    }

    private static void addMatchedFunctions(Map methods, List clazzMethods, List names) {
        int i = 0;
        while (i < clazzMethods.size()) {
            IMethodInfo info = (IMethodInfo)clazzMethods.get(i);
            if (names.contains(info.getName())) {
                methods.put(info.getName(), info);
            }
            ++i;
        }
    }
}

