/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.tptp.gla.components.source;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractSource;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.spi.ComponentEventSource;
import org.eclipse.cosmos.dc.common.spi.ComponentListener;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.tptp.gla.components.source.internal.GLAController;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;

@ManagedResource
public class CBESource
extends AbstractSource
implements IContextListener,
ComponentEventSource {
    private IComponent terminalComponent;
    private GLAController controller;
    private Class[] outputTypes = new Class[]{byte[].class, CommonBaseEvent.class};
    private DataSource datasource;
    private ArrayList<ComponentListener> listenerList = new ArrayList();
    private Thread monitorThread;
    private Date startDate;
    private Date lastDate;

    public CBESource(ContributionManager manager, Element binding) {
        super(manager);
        this.controller = new GLAController(binding);
        try {
            IContext[] contexts;
            this.controller.prepareAdapter(true);
            IContext[] iContextArray = contexts = this.controller.getContexts();
            int n = 0;
            int n2 = iContextArray.length;
            while (n < n2) {
                IContext context = iContextArray[n];
                IComponent[] components = context.getComponents();
                this.terminalComponent = components[components.length - 1];
                context.setContextListener((IContextListener)this);
                ++n;
            }
        }
        catch (AdapterException e) {
            e.printStackTrace();
        }
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            return ((IDataFilterService)target).acceptType(byte[].class) || ((IDataFilterService)target).acceptType(CommonBaseEvent.class);
        }
        if (target instanceof IDataTransformService) {
            return ((IDataTransformService)target).acceptType(byte[].class) || ((IDataTransformService)target).acceptType(CommonBaseEvent.class);
        }
        if (target instanceof IDataSinkService) {
            return ((IDataSinkService)target).acceptType(byte[].class) || ((IDataSinkService)target).acceptType(CommonBaseEvent.class);
        }
        return false;
    }

    @ManagedOperation
    public boolean cancel() throws Exception {
        this.controller.stop();
        return true;
    }

    @ManagedOperation
    public boolean connect() throws Exception {
        return true;
    }

    @ManagedOperation
    public boolean disconnect() throws Exception {
        return false;
    }

    @ManagedOperation
    public boolean pause() throws Exception {
        this.controller.stop();
        return true;
    }

    @ManagedOperation
    public boolean resume() throws Exception {
        this.controller.start();
        return true;
    }

    @ManagedOperation
    public boolean run() throws Exception {
        this.controller.start();
        this.monitorThread = new Thread(new GLAMonitor(this.controller, this, this.listenerList));
        this.monitorThread.start();
        return true;
    }

    public Class[] getOutputTypes() {
        return this.outputTypes;
    }

    public String[] getTargetContextUniqueIds() {
        return null;
    }

    public void postProcessEventItems(IComponent component, Object[] results) {
        if (!component.equals(this.terminalComponent)) {
            return;
        }
        if (results != null) {
            Object[] objectArray = results;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object result = objectArray[n];
                if (result != null) {
                    if (this.startDate == null) {
                        this.startDate = new Date(((CommonBaseEvent)result).getCreationTimeAsLong());
                        for (ComponentListener listener : this.listenerList) {
                            listener.event(2, (Object)this, (Object)this.startDate);
                        }
                    }
                    this.lastDate = new Date(((CommonBaseEvent)result).getCreationTimeAsLong());
                    this.dispatch(result);
                }
                ++n;
            }
        }
    }

    public void preProcessEventItems(IComponent component, Object[] msgs) {
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void addListener(ComponentListener listener) {
        this.listenerList.add(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GLAMonitor
    implements Runnable {
        GLAController controller;
        ArrayList<ComponentListener> listenerList;
        CBESource source;

        public GLAMonitor(GLAController controller, CBESource source, ArrayList<ComponentListener> listenerList) {
            this.controller = controller;
            this.listenerList = listenerList;
            this.source = source;
        }

        @Override
        public void run() {
            boolean allDone;
            block2: do {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                Status[] stats = this.controller.getStatus();
                allDone = true;
                Status[] statusArray = stats;
                int n = 0;
                int n2 = statusArray.length;
                while (n < n2) {
                    Status status = statusArray[n];
                    if (!"AdapterContext".equals(status.getName()) && status.isActive()) {
                        allDone = false;
                        continue block2;
                    }
                    ++n;
                }
            } while (!allDone);
            for (ComponentListener listener : this.listenerList) {
                listener.event(3, (Object)this.source, (Object)this.source.lastDate);
                listener.event(0, (Object)this.source);
            }
        }
    }
}

