/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IComponentBroker;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.util.EventQueue;

public class ComponentBroker
implements IComponentBroker {
    private Object lock;
    private EventConsumer[] consumers = null;
    private IComponentBroker nextBroker = null;
    private IContextListener listener;

    public ComponentBroker(String name, IContextListener listener) {
        this.listener = listener;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventConsumer(IComponent con) {
        if (this.consumers == null) {
            this.consumers = new EventConsumer[1];
            this.consumers[0] = new EventConsumer(con);
        } else {
            Object object = this.lock;
            synchronized (object) {
                EventConsumer[] replacement = new EventConsumer[this.consumers.length + 1];
                int i = 0;
                while (i < this.consumers.length) {
                    replacement[i] = this.consumers[i];
                    ++i;
                }
                replacement[this.consumers.length] = new EventConsumer(con);
                this.consumers = replacement;
            }
        }
    }

    public void setNextBroker(IComponentBroker nextBroker) {
        this.nextBroker = nextBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvents(Object[] obj) {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.consumers.length) {
                boolean added = false;
                do {
                    try {
                        this.consumers[i].queue.addItem(obj);
                        added = true;
                    }
                    catch (InterruptedException interruptedException) {}
                } while (!added);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.consumers.length) {
                this.consumers[i].start();
                ++i;
            }
        }
    }

    public void flushAndTerminate() throws InterruptedException {
        int i = 0;
        while (i < this.consumers.length) {
            this.consumers[i].flushAndTerminate();
            ++i;
        }
        if (this.nextBroker != null) {
            this.nextBroker.flushAndTerminate();
        }
    }

    private class EventConsumer {
        private IComponent entity;
        private EventConsumerThread thread;
        private EventQueue queue = new EventQueue();

        private EventConsumer(IComponent e) {
            this.entity = e;
        }

        public void flushAndTerminate() throws InterruptedException {
            this.queue.flush();
            this.thread.terminate();
        }

        public void start() {
            this.thread = new EventConsumerThread(this);
            this.thread.setName(this.entity.getName());
            this.thread.start();
        }
    }

    private class EventConsumerThread
    extends Thread {
        private EventConsumer consumer;
        private boolean stopping = false;
        private boolean stopped = false;
        private Object stopLock;

        public EventConsumerThread(EventConsumer consumer) {
            this.consumer = consumer;
            this.stopLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            this.stopping = true;
            Object object = this.stopLock;
            synchronized (object) {
                if (!this.stopped) {
                    try {
                        this.stopLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopping) {
                Object[] values = null;
                try {
                    values = this.consumer.queue.getItem();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (ComponentBroker.this.listener != null) {
                    try {
                        ComponentBroker.this.listener.preProcessEventItems(this.consumer.entity, values);
                    }
                    catch (Throwable throwable) {}
                }
                Object[] oa = null;
                if (values != null) {
                    oa = ((IProcessUnit)this.consumer.entity).processEventItems(values);
                }
                if (oa == null) continue;
                if (ComponentBroker.this.listener != null) {
                    try {
                        ComponentBroker.this.listener.postProcessEventItems(this.consumer.entity, oa);
                    }
                    catch (Throwable throwable) {}
                }
                if (ComponentBroker.this.nextBroker == null) continue;
                ComponentBroker.this.nextBroker.queueEvents(oa);
            }
            this.stopped = true;
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notifyAll();
            }
        }
    }
}

