/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.BindingService;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.cosmos.dc.common.spi.ServiceRegistry;
import org.eclipse.cosmos.dc.common.spi.impl.ContextDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.ContextHelper;
import org.eclipse.cosmos.dc.common.spi.impl.InboundDataContext;
import org.eclipse.cosmos.dc.common.spi.impl.OutboundDataContext;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(advertise=true, advertisementConsumer="Dispatch-Consumer")
public class Runtime
implements RuntimeHost {
    private ServiceRegistry serviceRegistry;
    private ContributionManager manager;
    private RuntimeHost _proxy;
    @ManagedFrameworkAutowire(name="ProviderRegistry")
    private ProviderRegistry registry;
    private int activeCollectorCount = 0;
    @ManagedRelation(name="context", type="context", namespace="http://www.eclipse.org/xmlns/cosmos/1.0", relatedClassName="org.eclipse.cosmos.dc.common.spi.IDataCollectionContext")
    HashMap<String, IDataCollectionContext> contextMap = new HashMap();
    @ManagedProperty(resourceID=true)
    private String identifier;

    public String getIdentifier() {
        return "RuntimeIdentifierValue";
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setManager(ContributionManager manager) {
        this.manager = manager;
        this._proxy = (RuntimeHost)manager.manage((Object)this);
    }

    public Runtime() {
    }

    public Runtime(ServiceRegistry serviceRegistry, ContributionManager manager) {
        this.serviceRegistry = serviceRegistry;
        this.manager = manager;
        this._proxy = (RuntimeHost)manager.manage((Object)this);
    }

    @Override
    public void addContext(IDataCollectionContext context) {
        this.contextMap.put(context.getName(), context);
    }

    @Override
    public void removeContext(IDataCollectionContext context) {
        this.contextMap.remove(context.getName());
    }

    @Override
    public IDataCollectionContext getContextForName(String name) {
        return this.contextMap.get(name);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public int getActiveCollectorCount() {
        return this.activeCollectorCount;
    }

    @Override
    public IDataCollectionContext loadContext(String contextPath) {
        URL resource = this.getClass().getClassLoader().getResource("/META-INF/cosmos/" + contextPath);
        if (resource != null) {
            try {
                return this.loadContextFromStream(resource.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IDataCollectionContext loadContextFromStream(InputStream contextStream) throws Exception {
        Document doc = XmlUtils.createDocument((InputStream)contextStream);
        doc.setDocumentURI("http://www.eclipse.org/xmlns/cosmos/1.0");
        ContextDescriptor descriptor = ContextHelper.getContextDescriptor(doc);
        if (this.getContextForName(descriptor.getName()) != null) {
            return this.getContextForName(descriptor.getName());
        }
        if (descriptor.isInbound()) {
            InboundDataContext context = new InboundDataContext(this, this.manager);
            context.load(doc);
            this.manager.manage((Object)context);
            this._proxy.addContext(context);
            context.materialize();
            return context;
        }
        if (descriptor.isOutbound()) {
            OutboundDataContext context = new OutboundDataContext(this, this.manager);
            context.load(doc);
            this.manager.manage((Object)context);
            this._proxy.addContext(context);
            context.materialize();
            return context;
        }
        throw new Exception("Invalid Context specified " + descriptor.getName());
    }

    @Override
    public void unloadContext(String name) {
    }

    public BindingService getBindingServiceForNamespace(String namespace) {
        BindingService service;
        if (this.serviceRegistry != null && (service = this.serviceRegistry.getBindingServiceForNamespace(namespace)) != null) {
            service.setManager(this.manager);
            service.setRegistry(this.registry);
            return service;
        }
        return null;
    }

    @Override
    public Collection<IDataCollectionContext> getContexts() {
        return this.contextMap.values();
    }

    @Override
    public ProviderRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ProviderRegistry registry) {
        this.registry = registry;
    }
}

