/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterGroup;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.ExportedColumn;
import org.eclipse.birt.report.service.api.ExportedResultSet;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.service.api.ToC;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.ResultSet;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtViewerReportService
implements IViewerReportService {
    static final /* synthetic */ boolean $assertionsDisabled;

    public BirtViewerReportService(ServletContext servletContext) {
        try {
            ReportEngineService.initEngineInstance(servletContext);
        }
        catch (BirtException birtException) {
            birtException.printStackTrace();
        }
    }

    public String runReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map) throws ReportServiceException {
        return this.runReport(iViewerReportDesignHandle, string, inputOptions, map, null);
    }

    public String runReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map, Map map2) throws ReportServiceException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
        HashMap hashMap = viewerAttributeBean.getParameters();
        if (map != null) {
            hashMap.putAll(map);
        }
        Map map3 = viewerAttributeBean.getDisplayTexts();
        if (map2 != null) {
            map3.putAll(map2);
        }
        IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
        try {
            ReportEngineService.getInstance().runReport(httpServletRequest, iReportRunnable, string, locale, hashMap, map3);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
        return string;
    }

    public IViewerReportDesignHandle getReportDesignHandle(String string, InputOptions inputOptions) {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        String string2 = iReportDocument.getReportRunnable().getReportName();
        iReportDocument.close();
        BirtViewerReportDesignHandle birtViewerReportDesignHandle = new BirtViewerReportDesignHandle(null, string2);
        return birtViewerReportDesignHandle;
    }

    public ByteArrayOutputStream getPage(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        String string3 = (String)inputOptions.getOption("format");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        Boolean bl2 = (Boolean)inputOptions.getOption("svgFlag");
        Long l = Long.valueOf(string2);
        Boolean bl3 = (Boolean)inputOptions.getOption("rtl");
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = ReportEngineService.getInstance().renderReport(httpServletRequest, iReportDocument, string3, l, bl, bl2, list, locale, bl3);
            return byteArrayOutputStream2;
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
        finally {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
        }
    }

    public ByteArrayOutputStream getPageByBookmark(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        long l = this.getPageNumberByBookmark(string, string2, inputOptions);
        return this.getPage(string, l + "", inputOptions, list);
    }

    public ByteArrayOutputStream getPageByObjectId(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        return null;
    }

    public ByteArrayOutputStream getReportlet(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.renderReportlet(string, string2, inputOptions, list, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    public void renderReportlet(String string, String string2, InputOptions inputOptions, List list, OutputStream outputStream) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        String string3 = (String)inputOptions.getOption("format");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean bl2 = bl == null ? false : bl;
        Boolean bl3 = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean bl4 = bl3 == null ? false : bl3;
        Boolean bl5 = (Boolean)inputOptions.getOption("rtl");
        String string4 = (String)inputOptions.getOption("servletPath");
        try {
            ReportEngineService.getInstance().renderReportlet(outputStream, httpServletRequest, iReportDocument, string2, string3, bl2, bl4, null, locale, bl5, string4);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
        finally {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
        }
    }

    public void renderReport(String string, int n, String string2, InputOptions inputOptions, OutputStream outputStream) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean bl2 = bl == null ? true : bl;
        Boolean bl3 = (Boolean)inputOptions.getOption("svgFlag");
        boolean bl4 = bl3 == null ? false : bl3;
        Boolean bl5 = (Boolean)inputOptions.getOption("rtl");
        String string3 = (String)inputOptions.getOption("format");
        String string4 = (String)inputOptions.getOption("servletPath");
        try {
            ReportEngineService.getInstance().renderReport(outputStream, httpServletRequest, iReportDocument, string3, n, string2, bl2, bl4, null, locale, bl5, string4);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
        finally {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
        }
    }

    public void renderReport(String string, int n, InputOptions inputOptions, OutputStream outputStream) throws ReportServiceException {
        this.renderReport(string, n, null, inputOptions, outputStream);
    }

    public void extractResultSet(String string, String string2, Collection collection, Set set, InputOptions inputOptions, OutputStream outputStream) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        Locale locale = (Locale)inputOptions.getOption("locale");
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        try {
            ReportEngineService.getInstance().extractData(iReportDocument, string2, collection, locale, outputStream, ParameterAccessor.getExportEncoding(httpServletRequest), ParameterAccessor.getSep(httpServletRequest));
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
        finally {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
        }
    }

    public List getResultSetsMetadata(String string, InputOptions inputOptions) throws ReportServiceException {
        ResultSet[] resultSetArray;
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        if (iReportDocument == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.EXTRACT_DATA_NO_DOCUMENT"));
        }
        try {
            resultSetArray = ReportEngineService.getInstance().getResultSets(iReportDocument);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
        finally {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
        }
        if (resultSetArray == null || resultSetArray.length < 0) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.EXTRACT_DATA_NO_RESULT_SET"));
        }
        return this.transformResultSetArray(resultSetArray);
    }

    public List getResultSetsMetadata(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        return null;
    }

    public void getImage(String string, String string2, OutputStream outputStream, InputOptions inputOptions) throws ReportServiceException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
            ReportEngineService.getInstance().renderImage(string2, httpServletRequest, outputStream);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
    }

    public ToC getTOC(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        TOCNode tOCNode = null;
        if (iReportDocument != null) {
            Locale locale = null;
            if (inputOptions != null) {
                locale = (Locale)inputOptions.getOption("locale");
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ITOCTree iTOCTree = iReportDocument.getTOCTree("viewer", ULocale.forLocale((Locale)locale));
            tOCNode = string2 != null ? iTOCTree.findTOC(string2) : iTOCTree.findTOC(null);
        }
        if (tOCNode == null) {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_TOC"));
        }
        if (iReportDocument != null) {
            iReportDocument.close();
        }
        return BirtViewerReportService.transformTOCNode(tOCNode);
    }

    public String findTocByName(String string, String string2, InputOptions inputOptions) {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        String string3 = null;
        if (iReportDocument != null) {
            Locale locale = null;
            if (inputOptions != null) {
                locale = (Locale)inputOptions.getOption("locale");
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ITOCTree iTOCTree = iReportDocument.getTOCTree("viewer", ULocale.forLocale((Locale)locale));
            if (!$assertionsDisabled && iTOCTree == null) {
                throw new AssertionError();
            }
            List list = iTOCTree.findTOCByValue((Object)string2);
            if (list != null && list.size() > 0) {
                return ((TOCNode)list.get(0)).getBookmark();
            }
            iReportDocument.close();
        }
        return string3;
    }

    public long getPageCount(String string, InputOptions inputOptions, OutputOptions outputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        long l = 1L;
        if (iReportDocument != null) {
            l = iReportDocument.getPageCount();
            iReportDocument.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getParameterDefinitions(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions, boolean bl) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                Collection collection = iGetParameterDefinitionTask.getParameterDefns(true);
                Collection collection2 = BirtViewerReportService.convertEngineParameters(collection, bl);
                return collection2;
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return null;
    }

    public Map getParameterValues(String string, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        Map map = iReportDocument.getParameterValues();
        iReportDocument.close();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSelectionListForCascadingGroup(IViewerReportDesignHandle iViewerReportDesignHandle, String string, Object[] objectArray, InputOptions inputOptions) throws ReportServiceException {
        HttpServletRequest httpServletRequest;
        IGetParameterDefinitionTask iGetParameterDefinitionTask;
        block7: {
            Collection collection;
            iGetParameterDefinitionTask = null;
            httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
            try {
                iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
                if (iGetParameterDefinitionTask == null) break block7;
                ViewerAttributeBean viewerAttributeBean = this.getViewerAttrBean(inputOptions);
                if (viewerAttributeBean != null) {
                    iGetParameterDefinitionTask.setLocale(viewerAttributeBean.getLocale());
                    iGetParameterDefinitionTask.setParameterValues((Map)viewerAttributeBean.getParameters());
                }
                BirtUtility.addTask(httpServletRequest, (IEngineTask)iGetParameterDefinitionTask);
                iGetParameterDefinitionTask.evaluateQuery(string);
                Collection collection2 = iGetParameterDefinitionTask.getSelectionListForCascadingGroup(string, objectArray);
                collection = BirtViewerReportService.convertEngineParameterSelectionChoice(collection2);
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                BirtUtility.removeTask(httpServletRequest);
                if (iGetParameterDefinitionTask != null) {
                    iGetParameterDefinitionTask.close();
                }
                throw throwable;
            }
            BirtUtility.removeTask(httpServletRequest);
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
            return collection;
        }
        Object var11_11 = null;
        BirtUtility.removeTask(httpServletRequest);
        if (iGetParameterDefinitionTask != null) {
            iGetParameterDefinitionTask.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getParameterSelectionList(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions, String string) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                ViewerAttributeBean viewerAttributeBean = this.getViewerAttrBean(inputOptions);
                if (viewerAttributeBean != null) {
                    iGetParameterDefinitionTask.setLocale(viewerAttributeBean.getLocale());
                    iGetParameterDefinitionTask.setParameterValues((Map)viewerAttributeBean.getParameters());
                }
                Collection collection = iGetParameterDefinitionTask.getSelectionList(string);
                Collection collection2 = BirtViewerReportService.convertEngineParameterSelectionChoice(collection);
                return collection2;
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return null;
    }

    private IGetParameterDefinitionTask getParameterDefinitionTask(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask;
        IReportRunnable iReportRunnable;
        if (iViewerReportDesignHandle.getContentType() == "rptRunnableObject") {
            iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
            iGetParameterDefinitionTask = ReportEngineService.getInstance().createGetParameterDefinitionTask(iReportRunnable, inputOptions);
        } else {
            try {
                iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle.getFileName(), inputOptions);
            }
            catch (EngineException engineException) {
                throw new ReportServiceException(engineException.getLocalizedMessage(), engineException.getCause());
            }
        }
        if (iGetParameterDefinitionTask != null) {
            iReportRunnable = (HttpServletRequest)inputOptions.getOption("request");
            HashMap<String, IReportRunnable> hashMap = new HashMap<String, IReportRunnable>();
            hashMap.put("BIRT_VIEWER_HTTPSERVET_REQUEST", iReportRunnable);
            iGetParameterDefinitionTask.setAppContext(hashMap);
        }
        return iGetParameterDefinitionTask;
    }

    public long getPageNumberByBookmark(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        long l = iReportDocument.getPageNumber(string2);
        iReportDocument.close();
        return l;
    }

    public long getPageNumberByObjectId(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        long l = iReportDocument.getPageNumber(string2);
        iReportDocument.close();
        return l;
    }

    public void runAndRenderReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map, OutputStream outputStream, List list) throws ReportServiceException {
        this.runAndRenderReport(iViewerReportDesignHandle, string, inputOptions, map, outputStream, list, null);
    }

    public void runAndRenderReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map, OutputStream outputStream, List list, Map map2) throws ReportServiceException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        Boolean bl2 = (Boolean)inputOptions.getOption("svgFlag");
        String string2 = (String)inputOptions.getOption("format");
        Boolean bl3 = (Boolean)inputOptions.getOption("rtl");
        String string3 = (String)inputOptions.getOption("servletPath");
        try {
            ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
            String string4 = ParameterAccessor.htmlDecode(viewerAttributeBean.getReportTitle());
            IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
            ReportEngineService.getInstance().runAndRenderReport(httpServletRequest, iReportRunnable, outputStream, string2, locale, bl3, map, bl, bl2, map2, string3, string4);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage(), remoteException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameterDefaultValue(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        Object object = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                object = iGetParameterDefinitionTask.getDefaultValue(string);
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return object;
    }

    public void setContext(Object object, InputOptions inputOptions) throws BirtException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        ServletContext servletContext = (ServletContext)object;
        ReportEngineService.getInstance().setEngineContext(servletContext, httpServletRequest);
    }

    public IReportRunnable getReportRunnable(IViewerReportDesignHandle iViewerReportDesignHandle, Map map) throws ReportServiceException {
        IReportRunnable iReportRunnable;
        if (iViewerReportDesignHandle.getContentType() == "rptRunnableObject") {
            iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
        } else {
            try {
                iReportRunnable = ReportEngineService.getInstance().openReportDesign(iViewerReportDesignHandle.getFileName(), map);
            }
            catch (EngineException engineException) {
                throw new ReportServiceException(engineException.getLocalizedMessage(), engineException.getCause());
            }
        }
        return iReportRunnable;
    }

    private static ToC transformTOCNode(TOCNode tOCNode) {
        ToC toC = new ToC(tOCNode.getNodeID(), tOCNode.getDisplayString(), tOCNode.getBookmark(), BirtUtility.getTOCStyle(tOCNode));
        toC.setChildren(BirtViewerReportService.getToCChildren(tOCNode));
        return toC;
    }

    private static List getToCChildren(TOCNode tOCNode) {
        if (tOCNode.getChildren() == null) {
            return null;
        }
        List list = tOCNode.getChildren();
        ArrayList<ToC> arrayList = new ArrayList<ToC>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TOCNode tOCNode2 = (TOCNode)iterator.next();
            ToC toC = new ToC(tOCNode2.getNodeID(), tOCNode2.getDisplayString(), tOCNode2.getBookmark(), BirtUtility.getTOCStyle(tOCNode2));
            toC.setChildren(BirtViewerReportService.getToCChildren(tOCNode2));
            arrayList.add(toC);
        }
        return arrayList;
    }

    private IGetParameterDefinitionTask getParameterDefinitionTask(String string, InputOptions inputOptions) throws EngineException {
        IReportRunnable iReportRunnable = ReportEngineService.getInstance().openReportDesign(string, this.getModuleOptions(inputOptions));
        IGetParameterDefinitionTask iGetParameterDefinitionTask = ReportEngineService.getInstance().createGetParameterDefinitionTask(iReportRunnable, inputOptions);
        return iGetParameterDefinitionTask;
    }

    private List transformResultSetArray(ResultSet[] resultSetArray) {
        ArrayList<ExportedResultSet> arrayList = new ArrayList<ExportedResultSet>();
        for (int i = 0; i < resultSetArray.length; ++i) {
            ResultSet resultSet = resultSetArray[i];
            String string = resultSet.getQueryName();
            Column[] columnArray = resultSet.getColumn();
            ArrayList<ExportedColumn> arrayList2 = new ArrayList<ExportedColumn>();
            for (int j = 0; j < columnArray.length; ++j) {
                Column column = columnArray[j];
                ExportedColumn exportedColumn = new ExportedColumn(column.getName(), column.getLabel(), column.getVisibility());
                arrayList2.add(exportedColumn);
            }
            ExportedResultSet exportedResultSet = new ExportedResultSet(string, arrayList2);
            arrayList.add(exportedResultSet);
        }
        return arrayList;
    }

    private String getReportDesignName(InputOptions inputOptions) {
        HttpServletRequest httpServletRequest;
        String string = null;
        if (inputOptions != null && (httpServletRequest = (HttpServletRequest)inputOptions.getOption("request")) != null) {
            ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
            if (!$assertionsDisabled && viewerAttributeBean == null) {
                throw new AssertionError();
            }
            string = viewerAttributeBean.getReportDesignName();
            if (string != null && (string.endsWith("\\") || string.endsWith("/"))) {
                string = null;
            }
        }
        return string;
    }

    private static Collection convertEngineParameters(Collection collection, boolean bl) {
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParameterGroupDefinition parameterGroupDefinition;
            IScalarParameterDefn iScalarParameterDefn;
            Object e = iterator.next();
            if (e instanceof IScalarParameterDefn) {
                iScalarParameterDefn = (IScalarParameterDefn)e;
                parameterGroupDefinition = null;
                ParameterDefinition parameterDefinition = BirtViewerReportService.convertScalarParameter(iScalarParameterDefn, parameterGroupDefinition);
                arrayList.add(parameterDefinition);
                continue;
            }
            if (!(e instanceof IParameterGroupDefn)) continue;
            iScalarParameterDefn = (IParameterGroupDefn)e;
            parameterGroupDefinition = BirtViewerReportService.convertParameterGroup((IParameterGroupDefn)iScalarParameterDefn);
            arrayList.add(parameterGroupDefinition);
        }
        if (bl) {
            return arrayList;
        }
        return BirtViewerReportService.flattenGroups(arrayList);
    }

    private static List flattenGroups(List list) {
        if (list == null || list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ParameterGroupDefinition) {
                ParameterGroupDefinition parameterGroupDefinition = (ParameterGroupDefinition)e;
                arrayList.addAll(parameterGroupDefinition.getParameters());
                continue;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    private static List convertParametersInGroup(Collection collection, ParameterGroupDefinition parameterGroupDefinition) {
        if (collection == null) {
            return null;
        }
        ArrayList<ParameterDefinition> arrayList = new ArrayList<ParameterDefinition>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IScalarParameterDefn iScalarParameterDefn = (IScalarParameterDefn)iterator.next();
            ParameterDefinition parameterDefinition = BirtViewerReportService.convertScalarParameter(iScalarParameterDefn, parameterGroupDefinition);
            arrayList.add(parameterDefinition);
        }
        return arrayList;
    }

    private static ParameterGroupDefinition convertParameterGroup(IParameterGroupDefn iParameterGroupDefn) {
        boolean bl = iParameterGroupDefn instanceof ICascadingParameterGroup;
        String string = iParameterGroupDefn.getName();
        String string2 = iParameterGroupDefn.getDisplayName();
        String string3 = iParameterGroupDefn.getHelpText();
        String string4 = iParameterGroupDefn.getPromptText();
        ParameterGroupDefinition parameterGroupDefinition = new ParameterGroupDefinition(string, string2, string4, null, bl, string3);
        List list = BirtViewerReportService.convertParametersInGroup(iParameterGroupDefn.getContents(), parameterGroupDefinition);
        parameterGroupDefinition.setParameters(list);
        return parameterGroupDefinition;
    }

    private static ParameterDefinition convertScalarParameter(IScalarParameterDefn iScalarParameterDefn, ParameterGroupDefinition parameterGroupDefinition) {
        ReportElementHandle reportElementHandle = iScalarParameterDefn.getHandle();
        ScalarParameterHandle scalarParameterHandle = null;
        if (reportElementHandle instanceof ScalarParameterHandle) {
            scalarParameterHandle = (ScalarParameterHandle)reportElementHandle;
        }
        String string = iScalarParameterDefn.getName();
        long l = scalarParameterHandle != null ? scalarParameterHandle.getID() : 0L;
        String string2 = scalarParameterHandle == null ? "" : scalarParameterHandle.getPattern();
        String string3 = iScalarParameterDefn.getDisplayFormat();
        String string4 = iScalarParameterDefn.getDisplayName();
        String string5 = iScalarParameterDefn.getHelpText();
        String string6 = iScalarParameterDefn.getPromptText();
        int n = iScalarParameterDefn.getDataType();
        String string7 = scalarParameterHandle == null ? null : scalarParameterHandle.getValueExpr();
        int n2 = iScalarParameterDefn.getControlType();
        boolean bl = iScalarParameterDefn.isHidden();
        boolean bl2 = iScalarParameterDefn.allowNull();
        boolean bl3 = iScalarParameterDefn.allowBlank();
        boolean bl4 = iScalarParameterDefn.isRequired();
        boolean bl5 = scalarParameterHandle == null ? false : scalarParameterHandle.isMustMatch();
        boolean bl6 = iScalarParameterDefn.isValueConcealed();
        boolean bl7 = scalarParameterHandle == null ? false : scalarParameterHandle.distinct();
        ParameterDefinition parameterDefinition = new ParameterDefinition(l, string, string2, string3, string4, string5, string6, n, string7, n2, bl, bl2, bl3, bl4, bl5, bl6, bl7, parameterGroupDefinition, null);
        return parameterDefinition;
    }

    private static Collection convertEngineParameterSelectionChoice(Collection collection) {
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ParameterSelectionChoice> arrayList = new ArrayList<ParameterSelectionChoice>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IParameterSelectionChoice iParameterSelectionChoice = (IParameterSelectionChoice)iterator.next();
            ParameterSelectionChoice parameterSelectionChoice = new ParameterSelectionChoice(iParameterSelectionChoice.getLabel(), iParameterSelectionChoice.getValue());
            arrayList.add(parameterSelectionChoice);
        }
        return arrayList;
    }

    private Map getModuleOptions(InputOptions inputOptions) {
        ViewerAttributeBean viewerAttributeBean = this.getViewerAttrBean(inputOptions);
        if (viewerAttributeBean != null) {
            return viewerAttributeBean.getModuleOptions();
        }
        return null;
    }

    private ViewerAttributeBean getViewerAttrBean(InputOptions inputOptions) {
        HttpServletRequest httpServletRequest;
        if (inputOptions != null && (httpServletRequest = (HttpServletRequest)inputOptions.getOption("request")) != null) {
            return (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
        }
        return null;
    }

    static {
        $assertionsDisabled = !BirtViewerReportService.class.desiredAssertionStatus();
    }
}

