/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReferenceExtractor
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ReferenceExtractor";
    private boolean uriElementHit;
    private StringBuffer currentReference = new StringBuffer();
    private List references = new ArrayList();

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("http://schemas.serviceml.org/sml/2007/02".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = true;
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("http://schemas.serviceml.org/sml/2007/02".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = false;
            this.references.add(new ReferenceDescriptor(this.getFilePath(), this.locator.getLineNumber(), this.currentReference.toString()));
            this.currentReference = new StringBuffer();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.uriElementHit) {
            String string = new String(ch, start, length);
            if (this.currentReference.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentReference.append(' ');
            }
            this.currentReference.append(string.trim());
        }
    }

    public Object getDataStructure() {
        return this.references;
    }

    public static class ReferenceDescriptor {
        private int lineNumber;
        private String filePath;
        private String reference;

        public ReferenceDescriptor(String filePath, int lineNumber, String reference) {
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.reference = reference;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getReference() {
            return this.reference;
        }
    }
}

