/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class DocumentDOMBuilder
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.XMLDefaultHandler";
    public static final String NO_ALIAS = "no_alias";
    private Document document;
    private Map domDocumentMap;
    private List documentsWithNoAlias;
    private Node rootElement;
    private Stack elementStack = new Stack();
    private List aliasesList;
    private String currentAlias;
    private boolean cdataStarted;
    private boolean aliasElementHit;
    private boolean documentElementHit;
    private boolean dataElementHit;
    private boolean instanceElementHit;
    private Map lineNumberMap;
    private boolean definitionElementHit;

    public DocumentDOMBuilder() {
        this.domDocumentMap = new Hashtable();
        this.documentsWithNoAlias = new ArrayList();
        this.domDocumentMap.put(NO_ALIAS, this.documentsWithNoAlias);
        this.currentAlias = "";
        this.aliasesList = new ArrayList();
        this.lineNumberMap = new Hashtable();
        this.instanceElementHit = false;
        this.definitionElementHit = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.dataElementHit) {
            boolean importElement;
            if (this.document == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                try {
                    this.document = factory.newDocumentBuilder().newDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.setErrorMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, SMLMessages.errorCreatingDocument));
                    this.setStructureValidity(false);
                    return;
                }
            }
            Element element = this.document.createElementNS(uri, qName);
            if (this.locator != null) {
                this.setLocation(element, new ElementLocation(this.getFilePath(), this.locator.getLineNumber()));
            }
            boolean needSchemaLocation = importElement = "import".equals(localName);
            boolean smlNamespace = false;
            int i = 0;
            while (i < attributes.getLength()) {
                if (importElement && "schemaLocation".equals(attributes.getLocalName(i))) {
                    needSchemaLocation = false;
                }
                if (importElement && "namespace".equals(attributes.getLocalName(i)) && "http://schemas.serviceml.org/sml/2007/02".equals(attributes.getValue(i))) {
                    smlNamespace = true;
                }
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                ++i;
            }
            if (smlNamespace && needSchemaLocation) {
                element.setAttribute("schemaLocation", "http://schemas.serviceml.org/sml/2007/02");
            }
            if (this.rootElement == null) {
                this.rootElement = element;
            } else {
                ((Element)this.elementStack.peek()).appendChild(element);
            }
            this.elementStack.push(element);
        }
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if ("alias".equals(localName)) {
                this.aliasElementHit = true;
            } else if ("instances".equals(localName)) {
                this.instanceElementHit = true;
            } else if ("definitions".equals(localName)) {
                this.definitionElementHit = true;
            } else if ("document".equals(localName)) {
                this.documentElementHit = true;
            } else if (this.documentElementHit && "data".equals(localName)) {
                this.dataElementHit = true;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if ("alias".equals(localName)) {
                if (this.currentAlias.length() > 0) {
                    this.aliasesList.add(this.currentAlias);
                }
                this.currentAlias = "";
                this.aliasElementHit = false;
            } else if (this.instanceElementHit && "instances".equals(localName)) {
                this.instanceElementHit = false;
            } else if (this.definitionElementHit && "definitions".equals(localName)) {
                this.definitionElementHit = false;
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
            } else if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
                if (this.rootElement != null) {
                    if (this.rootElement.getLastChild() != null && this.rootElement.getLastChild().getNodeType() == 3 && "".equals(this.rootElement.getLastChild().getNodeValue().trim())) {
                        this.rootElement.removeChild(this.rootElement.getLastChild());
                    }
                    this.document.appendChild(this.rootElement);
                    if (this.instanceElementHit) {
                        if (this.aliasesList.size() <= 0) {
                            this.documentsWithNoAlias.add(this.rootElement);
                        }
                        int i = 0;
                        int aliasCount = this.aliasesList.size();
                        while (i < aliasCount) {
                            this.domDocumentMap.put(this.aliasesList.get(i), this.rootElement);
                            ++i;
                        }
                    }
                }
                this.aliasesList.clear();
                this.rootElement = null;
                this.document = null;
            }
        }
        if (this.dataElementHit) {
            this.elementStack.pop();
        }
    }

    public void characters(char[] characters, int start, int length) {
        if (this.aliasElementHit) {
            this.currentAlias = String.valueOf(this.currentAlias) + new String(characters, start, length);
        } else if (this.dataElementHit) {
            boolean isBufferEmpty;
            if (this.rootElement == null) {
                return;
            }
            String buffValue = new String(characters, start, length);
            boolean isBufferJustWhiteSpace = "".equals(buffValue.trim());
            boolean bl = isBufferEmpty = buffValue.length() <= 0;
            if (this.cdataStarted && isBufferEmpty || !this.cdataStarted && isBufferJustWhiteSpace) {
                this.cdataStarted = false;
                return;
            }
            Text text = this.document.createTextNode(buffValue);
            this.cdataStarted = true;
            if (this.elementStack.size() <= 0) {
                this.rootElement.appendChild(text);
            } else {
                Node node = (Node)this.elementStack.peek();
                node.getOwnerDocument().adoptNode(text);
                node.appendChild(text);
            }
        }
    }

    public void comment(char[] characters, int start, int length) {
        if (this.dataElementHit) {
            if (this.rootElement == null) {
                return;
            }
            String buffValue = new String(characters, start, length);
            Comment text = this.document.createComment(buffValue);
            this.cdataStarted = true;
            if (this.elementStack.size() <= 0) {
                this.rootElement.appendChild(text);
            } else {
                ((Node)this.elementStack.peek()).appendChild(text);
            }
        }
    }

    public Object getDataStructure() {
        return this.domDocumentMap;
    }

    public byte getPhase() {
        return 3;
    }

    public ElementLocation getLocation(Element element) {
        return (ElementLocation)this.lineNumberMap.get(element);
    }

    public void setLocation(Element element, ElementLocation location) {
        this.lineNumberMap.put(element, location);
    }
}

