/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.File;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.RowFile;

class MergeTempFileUtil {
    private String tempDirStr;
    private ResultObjectUtil resultObjectUtil;
    private int curLevel = 0;
    private int curIndex = 0;
    private static final String tempFilePrefix = "data";

    MergeTempFileUtil(String tempDirStr, ResultObjectUtil resultObjectUtil) {
        this.tempDirStr = tempDirStr;
        this.resultObjectUtil = resultObjectUtil;
        File tempDir = new File(tempDirStr);
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
    }

    RowFile newTempFile(int cacheSize) {
        return new RowFile(new File(this.tempDirStr, "data_" + this.curLevel + "_" + this.curIndex++), this.resultObjectUtil, cacheSize);
    }

    void newMergeLevel() {
        ++this.curLevel;
        this.curIndex = 0;
    }

    void clearTempDir() {
        File tempDir = new File(this.tempDirStr);
        if (tempDir.exists()) {
            tempDir.delete();
        }
    }
}

