/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.DateGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.DateTimeUtil;

class YearGroupCalculator
extends DateGroupCalculator {
    public YearGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
    }

    public Object calculate(Object value) {
        if (value == null) {
            return new Double(-1.0);
        }
        if (this.intervalStart == null) {
            return new Double(Math.floor(DateTimeUtil.diffYear(defaultStart, (Date)value) / this.getDateIntervalRange()));
        }
        if (DateTimeUtil.diffYear((Date)this.intervalStart, (Date)value) < 0) {
            return new Double(-1.0);
        }
        return new Double(Math.floor(DateTimeUtil.diffYear((Date)this.intervalStart, (Date)value) / this.getDateIntervalRange()));
    }
}

