/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrResultRowComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrValueOnlyResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggregationResultRowNavigator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AxisQualifier;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.SortKey;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.WrapperedDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class AggregationSortHelper {
    public static IAggregationResultSet sort(IAggregationResultSet base, SortKey[] sortKeys) throws IOException, DataException {
        AggregationSortHelper.createFilteredResultSet(sortKeys);
        IDiskArray baseDiskArray = AggregationSortHelper.getDiskArrayFromAggregationResultSet(base);
        IDiskArray keyDiskArray = AggregationSortHelper.populateAggrDiskArray(base, sortKeys);
        CompareUtil.sort(new WrapperedDiskArray(baseDiskArray, keyDiskArray), new AggrResultRowComparator(AggregationSortHelper.populateNewSortKeys(base, sortKeys)), AggregationResultRow.getCreator());
        return new AggregationResultSet(base.getAggregationDefinition(), baseDiskArray, base.getKeyNames(), base.getAggributeNames());
    }

    private static IDiskArray populateAggrDiskArray(IAggregationResultSet base, SortKey[] sortKeys) throws IOException {
        BufferedStructureArray keyDiskArray = new BufferedStructureArray(AggregationResultRow.getCreator(), 4096);
        int i = 0;
        while (i < base.length()) {
            base.seek(i);
            keyDiskArray.add(new AggrValueOnlyResultRow(AggregationSortHelper.toObjArray(AggregationSortHelper.createMatchedAggrRow(base, sortKeys))));
            ++i;
        }
        return keyDiskArray;
    }

    private static List createMatchedAggrRow(IAggregationResultSet base, SortKey[] sortKeys) throws IOException {
        ArrayList<Object> keyValues = new ArrayList<Object>();
        int x = 0;
        while (x < sortKeys.length) {
            SortKey key = sortKeys[x];
            Object[] values = new Object[key.getLevelKeyIndex() + 1 - key.getLevelKeyOffset()];
            boolean[] direction = new boolean[key.getLevelKeyIndex() + 1 - key.getLevelKeyOffset()];
            int y = key.getLevelKeyOffset();
            while (y < key.getLevelKeyIndex() + 1) {
                DimLevel level = sortKeys[x].getTargetResultSet().getLevel(y);
                values[y - key.getLevelKeyOffset()] = base.getLevelKeyValue(base.getLevelIndex(level))[0];
                direction[y - key.getLevelKeyOffset()] = base.getSortType(base.getLevelIndex(level)) != 1;
                ++y;
            }
            int i = 0;
            while (i < key.getAggrKeys().length) {
                IAggregationResultRow row = AggregationSortHelper.getNextMatchRow(key.getFilteredResultSet()[i], values, direction, key);
                keyValues.add(row == null ? null : row.getAggregationValues()[key.getAggrKeys()[i]]);
                ++i;
            }
            ++x;
        }
        return keyValues;
    }

    private static IAggregationResultRow getNextMatchRow(AggregationResultRowNavigator orderedArray, Object[] values, boolean[] dirs, SortKey sk) throws IOException {
        IAggregationResultRow currentRow = orderedArray.getCurrentRow();
        if (currentRow == null) {
            return null;
        }
        Object[] currentValues = new Object[values.length];
        int y = 0;
        while (y < currentValues.length) {
            currentValues[y] = currentRow.getLevelMembers()[sk.getLevelKeyOffset() + y].getKeyValues()[0];
            ++y;
        }
        int i = CompareUtil.compare(values, currentValues, dirs);
        if (i < 0) {
            return null;
        }
        if (i == 0) {
            return currentRow;
        }
        if (i > 0) {
            orderedArray.next();
            return AggregationSortHelper.getNextMatchRow(orderedArray, values, dirs, sk);
        }
        return null;
    }

    private static List populateNewSortKeys(IAggregationResultSet base, SortKey[] sortKeys) {
        SortKey[] sks = new SortKey[base.getLevelCount()];
        int i = 0;
        while (i < sks.length) {
            int j = 0;
            while (j < sortKeys.length) {
                int levelIndexInBase = base.getLevelIndex(sortKeys[j].getLevel());
                if (i == levelIndexInBase) {
                    sks[i] = sortKeys[j];
                }
                if (i < levelIndexInBase) break;
                ++j;
            }
            ++i;
        }
        AggregationSortHelper.populateEmptySortKey(base, sks);
        return AggregationSortHelper.createNewSortKeys(base, sks);
    }

    private static List createNewSortKeys(IAggregationResultSet base, SortKey[] sks) {
        ArrayList<SortKey> newSortKeys = new ArrayList<SortKey>();
        int offset = 0;
        int i = 0;
        while (i < sks.length) {
            DimLevel level = sks[i].getTargetResultSet().getLevel(sks[i].getLevelKeyIndex());
            int levelKeyIndex = base.getLevelIndex(level);
            int[] aggrKeyIndex = new int[sks[i].getAggrKeys().length];
            int j = 0;
            while (j < sks[i].getAggrKeys().length) {
                aggrKeyIndex[j] = sks[i].getAggrKeys()[j] + offset;
                ++j;
            }
            offset += sks[i].getAggrKeys().length;
            SortKey sk = new SortKey(aggrKeyIndex, sks[i].getAggrSortDirection(), levelKeyIndex, 0, sks[i].getTargetResultSet(), sks[i].getAxisQualifiers());
            newSortKeys.add(sk);
            ++i;
        }
        return newSortKeys;
    }

    private static void populateEmptySortKey(IAggregationResultSet base, SortKey[] sks) {
        int i = 0;
        while (i < sks.length) {
            if (sks[i] == null) {
                sks[i] = new SortKey(new int[0], new boolean[0], i, 0, base, new AxisQualifier[0]);
            }
            ++i;
        }
    }

    private static IDiskArray getDiskArrayFromAggregationResultSet(IAggregationResultSet base) throws IOException {
        BufferedStructureArray diskArray = new BufferedStructureArray(AggregationResultRow.getCreator(), 4096);
        int j = 0;
        while (j < base.length()) {
            base.seek(j);
            IAggregationResultRow temp = base.getCurrentRow();
            diskArray.add(temp);
            ++j;
        }
        base.seek(0);
        return diskArray;
    }

    private static void createFilteredResultSet(SortKey[] aggr) throws IOException, DataException {
        int i = 0;
        while (i < aggr.length) {
            IAggregationResultSet rSet = aggr[i].getTargetResultSet();
            AggregationSortHelper.filterResultSet(rSet, aggr[i]);
            ++i;
        }
    }

    private static void filterResultSet(IAggregationResultSet rSet, SortKey key) throws IOException, DataException {
        IDiskArray[] diskArray = new IDiskArray[key.getAxisQualifiers().length];
        AggregationResultRowNavigator[] result = new AggregationResultRowNavigator[key.getAxisQualifiers().length];
        int i = 0;
        while (i < diskArray.length) {
            diskArray[i] = new BufferedStructureArray(AggregationResultRow.getCreator(), 4096);
            ++i;
        }
        int j = 0;
        while (j < rSet.length()) {
            rSet.seek(j);
            int[] index = key.getAxisQualifiers()[0].getLevelIndex();
            Object[] values = new Object[index.length];
            int i2 = 0;
            while (i2 < index.length) {
                values[i2] = rSet.getLevelKeyValue(index[i2])[0];
                ++i2;
            }
            i2 = 0;
            while (i2 < key.getAxisQualifiers().length) {
                if (CompareUtil.compare(values, key.getAxisQualifiers()[i2].getLevelValue()) == 0) {
                    IAggregationResultRow temp = rSet.getCurrentRow();
                    diskArray[i2].add(temp);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = new AggregationResultRowNavigator(diskArray[i2]);
                ++i2;
            }
            ++j;
        }
        key.setFilteredResultSet(result);
    }

    static Object[] toObjArray(List l) {
        Object[] objs = new Object[l.size()];
        int i = 0;
        while (i < objs.length) {
            objs[i] = l.get(i);
            ++i;
        }
        return objs;
    }

    static boolean[] toDirectionArray(List sortKeys) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        int i = 0;
        while (i < sortKeys.size()) {
            SortKey sk = (SortKey)sortKeys.get(i);
            int j = 0;
            while (j < sk.getAggrSortDirection().length) {
                result.add(new Boolean(sk.getAggrSortDirection()[j]));
                ++j;
            }
            result.add(new Boolean(sk.getLevelSortDirection()));
            ++i;
        }
        boolean[] objs = new boolean[result.size()];
        int i2 = 0;
        while (i2 < objs.length) {
            objs[i2] = (Boolean)result.get(i2);
            ++i2;
        }
        return objs;
    }
}

