/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTaskV0;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTaskV1;

public class DataExtractionTask
implements IDataExtractionTask {
    IDataExtractionTask task;

    public DataExtractionTask(IReportEngine engine, IReportRunnable runnable, IReportDocument reader) throws EngineException {
        String version = reader.getVersion();
        if ("2.1.0".equals(version) || "1.2.1".equals(version) || "1.0.0".equals(version)) {
            this.task = new DataExtractionTaskV0(engine, runnable, reader);
        } else if ("2.1.3-2.2RC0".equals(version)) {
            this.task = new DataExtractionTaskV1(engine, runnable, reader);
        }
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.task.addScriptableJavaObject(jsName, obj);
    }

    public void cancel() {
        this.task.cancel();
    }

    public void cancel(Object signal) {
        this.task.cancel(signal);
    }

    public void close() {
        this.task.close();
    }

    public IExtractionResults extract() throws EngineException {
        return this.task.extract();
    }

    public Map getAppContext() {
        return this.task.getAppContext();
    }

    public boolean getCancelFlag() {
        return this.task.getCancelFlag();
    }

    public IReportEngine getEngine() {
        return this.task.getEngine();
    }

    public List getErrors() {
        return this.task.getErrors();
    }

    public int getID() {
        return this.task.getID();
    }

    public Locale getLocale() {
        return this.task.getLocale();
    }

    public List getMetaData() throws EngineException {
        return this.task.getMetaData();
    }

    public String getParameterDisplayText(String name) {
        return this.task.getParameterDisplayText(name);
    }

    public Object getParameterValue(String name) {
        return this.task.getParameterValue(name);
    }

    public HashMap getParameterValues() {
        return this.task.getParameterValues();
    }

    public IReportRunnable getReportRunnable() {
        return this.task.getReportRunnable();
    }

    public List getResultSetList() throws EngineException {
        return this.task.getResultSetList();
    }

    public int getStatus() {
        return this.task.getStatus();
    }

    public ULocale getULocale() {
        return this.task.getULocale();
    }

    public void selectColumns(String[] columnNames) {
        this.task.selectColumns(columnNames);
    }

    public void selectResultSet(String resultSetName) {
        this.task.selectResultSet(resultSetName);
    }

    public void setAppContext(Map context) {
        this.task.setAppContext(context);
    }

    public void setDataSource(IDocArchiveReader dataSource) {
        this.task.setDataSource(dataSource);
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.task.setFilters(simpleFilterExpression);
    }

    public void setInstanceID(InstanceID iid) {
        this.task.setInstanceID(iid);
    }

    public void setLocale(Locale locale) {
        this.task.setLocale(locale);
    }

    public void setLocale(ULocale locale) {
        this.task.setLocale(locale);
    }

    public void setParameter(String name, Object value, String displayText) {
        this.task.setParameter(name, value, displayText);
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.task.setParameterDisplayText(name, displayText);
    }

    public void setParameterValue(String name, Object value) {
        this.task.setParameterValue(name, value);
    }

    public void setParameterValues(Map params) {
        this.task.setParameterValues(params);
    }

    public boolean validateParameters() {
        return this.task.validateParameters();
    }

    public Logger getLogger() {
        return this.task.getLogger();
    }

    public int getTaskType() {
        return this.task.getTaskType();
    }

    public void setErrorHandlingOption(int option) {
        this.task.setErrorHandlingOption(option);
    }

    public void setLogger(Logger logger) {
        this.task.setLogger(logger);
    }
}

