/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.CascadingParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ParameterDefnBase;
import org.eclipse.birt.report.engine.api.impl.ParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.engine.api.impl.SelectionChoiceComparator;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;

public class GetParameterDefinitionTask
extends EngineTask
implements IGetParameterDefinitionTask {
    private static final String VALUE_PREFIX = "__VALUE__";
    private static final String LABEL_PREFIX = "__LABEL__";
    protected Collection parameterDefns = null;
    protected HashMap dataCache = null;
    private List labelColumnBindingNames = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GetParameterDefinitionTask(IReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 0);
    }

    public Collection getParameterDefns(boolean includeParameterGroups) {
        IParameterDefnBase pBase;
        DesignElementHandle handle = ((ReportRunnable)this.runnable).getDesignHandle();
        ArrayList original = this.getParameters((ReportDesignHandle)handle, includeParameterGroups);
        Iterator iter = original.iterator();
        this.parameterDefns = new ArrayList();
        while (iter.hasNext()) {
            pBase = (ParameterDefnBase)iter.next();
            try {
                this.parameterDefns.add(pBase.clone());
            }
            catch (CloneNotSupportedException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.parameterDefns != null) {
            iter = this.parameterDefns.iterator();
            while (iter.hasNext()) {
                pBase = (IParameterDefnBase)iter.next();
                if (pBase instanceof ScalarParameterDefn) {
                    ((ScalarParameterDefn)pBase).setReportDesign((ReportDesignHandle)this.runnable.getDesignHandle());
                    ((ScalarParameterDefn)pBase).setLocale(this.locale);
                    ((ScalarParameterDefn)pBase).evaluateSelectionList();
                    continue;
                }
                if (!(pBase instanceof ParameterGroupDefn)) continue;
                ((ParameterGroupDefn)pBase).setReportDesign((ReportDesignHandle)this.runnable.getDesignHandle());
                Iterator iter2 = ((ParameterGroupDefn)pBase).getContents().iterator();
                while (iter2.hasNext()) {
                    IParameterDefnBase p = (IParameterDefnBase)iter2.next();
                    if (!(p instanceof ScalarParameterDefn)) continue;
                    ((ScalarParameterDefn)p).setReportDesign((ReportDesignHandle)this.runnable.getDesignHandle());
                    ((ScalarParameterDefn)p).setLocale(this.locale);
                    ((ScalarParameterDefn)p).evaluateSelectionList();
                }
            }
        }
        return this.parameterDefns;
    }

    public void evaluateDefaults() throws EngineException {
    }

    public IParameterDefnBase getParameterDefn(String name) {
        IParameterDefnBase ret = null;
        if (name == null) {
            return ret;
        }
        DesignElementHandle handle = ((ReportRunnable)this.runnable).getDesignHandle();
        ArrayList original = this.getParameters((ReportDesignHandle)handle, true);
        Iterator iter = original.iterator();
        while (iter.hasNext()) {
            ret = this.getParamDefnBaseByName((ParameterDefnBase)iter.next(), name);
            if (ret != null) break;
        }
        if (ret != null) {
            if (ret instanceof ScalarParameterDefn) {
                ((ScalarParameterDefn)ret).setReportDesign((ReportDesignHandle)this.runnable.getDesignHandle());
                ((ScalarParameterDefn)ret).setLocale(this.locale);
                ((ScalarParameterDefn)ret).evaluateSelectionList();
            } else if (ret instanceof ParameterGroupDefn) {
                ((ParameterGroupDefn)ret).setReportDesign((ReportDesignHandle)this.runnable.getDesignHandle());
                ((ParameterGroupDefn)ret).setLocale(this.locale);
                Iterator iter2 = ((ParameterGroupDefn)ret).getContents().iterator();
                while (iter2.hasNext()) {
                    IParameterDefnBase p = (IParameterDefnBase)iter2.next();
                    if (!(p instanceof ScalarParameterDefn)) continue;
                    ((ScalarParameterDefn)p).setReportDesign((ReportDesignHandle)this.runnable.getDesignHandle());
                    ((ScalarParameterDefn)p).setLocale(this.locale);
                    ((ScalarParameterDefn)p).evaluateSelectionList();
                }
            }
        }
        return ret;
    }

    public SlotHandle getParameters() {
        ReportDesignHandle report = (ReportDesignHandle)this.runnable.getDesignHandle();
        return report.getParameters();
    }

    public ParameterHandle getParameter(String name) {
        ReportDesignHandle report = (ReportDesignHandle)this.runnable.getDesignHandle();
        return report.findParameter(name);
    }

    public HashMap getDefaultValues() {
        this.usingParameterValues();
        final HashMap values = new HashMap();
        new EngineTask.ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                String expr = param.getDefaultValue();
                String type = param.getDataType();
                Object value = GetParameterDefinitionTask.this.convertToType(expr, type);
                values.put(name, value);
                return true;
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object userData) {
                return this.visitParametersInGroup(group, userData);
            }
        }.visit((ReportDesignHandle)this.runnable.getDesignHandle());
        return values;
    }

    public Object getDefaultValue(IParameterDefnBase param) {
        return param == null ? null : this.getDefaultValue(param.getName());
    }

    public Object getDefaultValue(String name) {
        ReportDesignHandle report = (ReportDesignHandle)this.runnable.getDesignHandle();
        ScalarParameterHandle parameter = (ScalarParameterHandle)report.findParameter(name);
        if (parameter == null) {
            return null;
        }
        this.usingParameterValues();
        String expr = parameter.getDefaultValue();
        String dataType = parameter.getDataType();
        if (expr == null || expr.length() == 0 && !"string".equals(dataType)) {
            return null;
        }
        return this.convertToType(expr, dataType);
    }

    public Collection getSelectionList(String name) {
        this.usingParameterValues();
        ReportDesignHandle report = (ReportDesignHandle)this.runnable.getDesignHandle();
        ScalarParameterHandle parameter = (ScalarParameterHandle)report.findParameter(name);
        if (parameter == null) {
            return Collections.EMPTY_LIST;
        }
        String selectionType = parameter.getValueType();
        String dataType = parameter.getDataType();
        boolean fixedOrder = parameter.isFixedOrder();
        boolean sortByLabel = "label".equalsIgnoreCase(parameter.getSortBy());
        boolean sortDirectionValue = "asc".equalsIgnoreCase(parameter.getSortDirection());
        if ("dynamic".equals(selectionType)) {
            CascadingParameterGroupHandle group = null;
            if (this.isCascadingParameter(parameter)) {
                group = this.getCascadingGroup(parameter);
            }
            if (group != null && "single".equals(group.getDataSetMode())) {
                return this.getCascadingParameterList(parameter);
            }
            if (parameter.getDataSetName() != null) {
                return this.getChoicesFromParameterQuery(parameter);
            }
            if (group != null) {
                return this.getCascadingParameterList(parameter);
            }
        } else if ("static".equals(selectionType)) {
            Iterator iter = parameter.choiceIterator();
            ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
            while (iter.hasNext()) {
                SelectionChoiceHandle choice = (SelectionChoiceHandle)iter.next();
                String label = report.getMessage(choice.getLabelKey(), this.locale);
                if (label == null) {
                    label = choice.getLabel();
                }
                Object value = this.getStringValue(choice.getValue(), dataType);
                choices.add(new SelectionChoice(label, value));
            }
            if (!fixedOrder) {
                Collections.sort(choices, new SelectionChoiceComparator(sortByLabel, parameter.getPattern(), sortDirectionValue, ULocale.forLocale((Locale)this.locale)));
            }
            return choices;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getCascadingParameterList(ScalarParameterHandle parameter) {
        Object[] parameterValuesAhead = this.getParameterValuesAhead(parameter);
        return this.getChoicesFromParameterGroup(parameter, parameterValuesAhead);
    }

    private Object getStringValue(String value, String valueType) {
        try {
            if ("boolean".equals(valueType)) {
                return DataTypeUtil.toBoolean((Object)value);
            }
            if ("dateTime".equals(valueType)) {
                return DataTypeUtil.toDate((Object)value);
            }
            if ("date".equals(valueType)) {
                return DataTypeUtil.toSqlDate((Object)value);
            }
            if ("time".equals(valueType)) {
                return DataTypeUtil.toSqlTime((Object)value);
            }
            if ("decimal".equals(valueType)) {
                return DataTypeUtil.toBigDecimal((Object)value);
            }
            if ("float".equals(valueType)) {
                return DataTypeUtil.toDouble((Object)value);
            }
            if ("integer".equals(valueType)) {
                return DataTypeUtil.toInteger((Object)value);
            }
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return value;
    }

    private Collection createDynamicSelectionChoices(String pattern, String dataSetName, String labelStmt, String valueStmt, String dataType, int limit, boolean fixedOrder, boolean isDistinct, String sortDirection, String sortBy) {
        boolean sortDirectionValue = "asc".equalsIgnoreCase(sortDirection);
        boolean sortByLabel = "label".equalsIgnoreCase(sortBy);
        ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
        ReportDesignHandle report = (ReportDesignHandle)this.runnable.getDesignHandle();
        DataSetHandle dataSet = report.findDataSet(dataSetName);
        if (dataSet != null) {
            try {
                Binding binding;
                IDataEngine dataEngine = this.executionContext.getDataEngine();
                DataRequestSession dteSession = this.getDataSession();
                dataEngine.defineDataSet(dataSet);
                ScriptExpression labelExpr = null;
                if (labelStmt != null && labelStmt.length() > 0) {
                    labelExpr = new ScriptExpression(labelStmt);
                }
                ScriptExpression valueExpr = new ScriptExpression(valueStmt);
                QueryDefinition queryDefn = new QueryDefinition();
                queryDefn.setDataSetName(dataSetName);
                if (limit > 0) {
                    queryDefn.setMaxRows(limit);
                }
                Iterator paramIter = dataSet.paramBindingsIterator();
                while (paramIter.hasNext()) {
                    ParamBindingHandle binding2 = (ParamBindingHandle)paramIter.next();
                    String paramName = binding2.getParamName();
                    String paramExpr = binding2.getExpression();
                    queryDefn.getInputParamBindings().add(new InputParameterBinding(paramName, (IBaseExpression)new ScriptExpression(paramExpr)));
                }
                String labelColumnName = LABEL_PREFIX;
                String valueColumnName = VALUE_PREFIX;
                if (labelExpr != null) {
                    binding = new Binding(labelColumnName, (IBaseExpression)labelExpr);
                    queryDefn.addBinding((IBinding)binding);
                }
                binding = new Binding(valueColumnName, (IBaseExpression)valueExpr);
                queryDefn.addBinding((IBinding)binding);
                queryDefn.setAutoBinding(true);
                IPreparedQuery query = dteSession.prepare((IQueryDefinition)queryDefn, this.getAppContext());
                IQueryResults result = query.execute(this.executionContext.getSharedScope());
                IResultIterator iter = result.getResultIterator();
                int count = 0;
                HashMap<Object, Object> checkPool = new HashMap<Object, Object>();
                while (iter.next()) {
                    String label = null;
                    if (labelExpr != null) {
                        label = iter.getString(labelColumnName);
                    }
                    Object value = iter.getValue(valueColumnName);
                    value = this.convertToType(value, dataType);
                    if (isDistinct) {
                        if (!checkPool.containsKey(value)) {
                            checkPool.put(value, value);
                            choices.add(new SelectionChoice(label, value));
                            ++count;
                        }
                    } else {
                        choices.add(new SelectionChoice(label, value));
                        ++count;
                    }
                    if (limit == 0 || count < limit) {
                        continue;
                    }
                    break;
                }
            }
            catch (BirtException ex) {
                ex.printStackTrace();
            }
        }
        if (!fixedOrder) {
            Collections.sort(choices, new SelectionChoiceComparator(sortByLabel, pattern, sortDirectionValue, ULocale.forLocale((Locale)this.locale)));
        }
        return choices;
    }

    public void evaluateQuery(String parameterGroupName) {
        DataSetHandle dataSet;
        CascadingParameterGroupHandle parameterGroup = this.getCascadingParameterGroup(parameterGroupName);
        if (this.dataCache == null) {
            this.dataCache = new HashMap();
        }
        if (parameterGroup == null) {
            return;
        }
        IResultIterator iterOld = (IResultIterator)this.dataCache.get(parameterGroup.getName());
        if (iterOld != null) {
            this.dataCache.remove(parameterGroup.getName());
            try {
                IQueryResults iresultOld = iterOld.getQueryResults();
                iterOld.close();
                iresultOld.close();
            }
            catch (BirtException ex) {
                this.log.log(Level.WARNING, ex.getMessage());
            }
        }
        if ((dataSet = parameterGroup.getDataSet()) != null) {
            try {
                DataRequestSession dteSession = this.getDataSession();
                IDataEngine dataEngine = this.executionContext.getDataEngine();
                dataEngine.defineDataSet(dataSet);
                QueryDefinition queryDefn = new QueryDefinition();
                queryDefn.setDataSetName(dataSet.getQualifiedName());
                SlotHandle parameters = parameterGroup.getParameters();
                Iterator iter = parameters.iterator();
                if (this.labelColumnBindingNames == null) {
                    this.labelColumnBindingNames = new ArrayList();
                }
                while (iter.hasNext()) {
                    Object param = iter.next();
                    if (!(param instanceof ScalarParameterHandle)) continue;
                    String valueExpString = ((ScalarParameterHandle)param).getValueExpr();
                    ScriptExpression valueExpObject = new ScriptExpression(valueExpString);
                    String keyValue = VALUE_PREFIX + parameterGroup.getName() + "_" + ((ScalarParameterHandle)param).getName();
                    Binding binding = new Binding(keyValue, (IBaseExpression)valueExpObject);
                    queryDefn.addBinding((IBinding)binding);
                    String labelExpString = ((ScalarParameterHandle)param).getLabelExpr();
                    if (labelExpString != null && labelExpString.length() > 0) {
                        ScriptExpression labelExpObject = new ScriptExpression(labelExpString);
                        String keyLabel = LABEL_PREFIX + parameterGroup.getName() + "_" + ((ScalarParameterHandle)param).getName();
                        this.labelColumnBindingNames.add(keyLabel);
                        Binding labelBinding = new Binding(keyLabel, (IBaseExpression)labelExpObject);
                        queryDefn.addBinding((IBinding)labelBinding);
                    }
                    GroupDefinition groupDef = new GroupDefinition(null);
                    groupDef.setKeyExpression(valueExpString);
                    queryDefn.addGroup(groupDef);
                }
                queryDefn.setAutoBinding(true);
                IPreparedQuery query = dteSession.prepare((IQueryDefinition)queryDefn, this.getAppContext());
                IQueryResults result = query.execute(this.executionContext.getSharedScope());
                IResultIterator resultIter = result.getResultIterator();
                this.dataCache.put(parameterGroup.getName(), resultIter);
                return;
            }
            catch (BirtException ex) {
                ex.printStackTrace();
            }
        }
        this.dataCache.put(parameterGroup.getName(), null);
    }

    public Collection getSelectionListForCascadingGroup(String parameterGroupName, Object[] groupKeyValues) {
        CascadingParameterGroupHandle parameterGroup = this.getCascadingParameterGroup(parameterGroupName);
        if (parameterGroup == null) {
            return Collections.EMPTY_LIST;
        }
        SlotHandle slotHandle = parameterGroup.getParameters();
        if (groupKeyValues.length >= slotHandle.getCount()) {
            return Collections.EMPTY_LIST;
        }
        int i = 0;
        while (i < groupKeyValues.length) {
            String parameterName = ((ScalarParameterHandle)slotHandle.get(i)).getName();
            this.setParameterValue(parameterName, groupKeyValues[i]);
            ++i;
        }
        ScalarParameterHandle requestedParam = (ScalarParameterHandle)slotHandle.get(groupKeyValues.length);
        if (requestedParam == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getSelectionList(requestedParam.getName());
    }

    private Collection getChoicesFromParameterGroup(ScalarParameterHandle parameter, Object[] groupKeyValues) {
        if (!$assertionsDisabled && !this.isCascadingParameter(parameter)) {
            throw new AssertionError();
        }
        CascadingParameterGroupHandle parameterGroup = this.getCascadingGroup(parameter);
        String parameterGroupName = parameterGroup.getName();
        this.evaluateQuery(parameterGroupName);
        IResultIterator iter = (IResultIterator)this.dataCache.get(parameterGroupName);
        if (iter == null) {
            this.evaluateQuery(parameterGroupName);
            if (iter == null) {
                return Collections.EMPTY_LIST;
            }
        }
        String labelColumnName = LABEL_PREFIX + parameterGroupName + "_" + parameter.getName();
        String valueColumnName = VALUE_PREFIX + parameterGroupName + "_" + parameter.getName();
        int listLimit = parameter.getListlimit();
        ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
        int skipLevel = groupKeyValues.length + 1;
        try {
            if (skipLevel > 1) {
                iter.findGroup(groupKeyValues);
            }
            int startGroupLevel = skipLevel - 1;
            int count = 0;
            while (iter.next()) {
                String label = this.labelColumnBindingNames.contains(labelColumnName) ? iter.getString(labelColumnName) : null;
                Object value = iter.getValue(valueColumnName);
                choices.add(new SelectionChoice(label, value));
                if (listLimit == 0 || ++count < listLimit) {
                    iter.skipToEnd(skipLevel);
                    int endGroupLevel = iter.getEndingGroupLevel();
                    if (endGroupLevel > startGroupLevel) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
        if (!parameter.isFixedOrder()) {
            Collections.sort(choices, new SelectionChoiceComparator(true, parameter.getPattern(), ULocale.forLocale((Locale)this.locale)));
        }
        return choices;
    }

    private CascadingParameterGroupHandle getCascadingParameterGroup(String name) {
        ReportDesignHandle report = (ReportDesignHandle)this.runnable.getDesignHandle();
        return report.findCascadingParameterGroup(name);
    }

    public void close() {
        if (this.dataCache != null) {
            Iterator it = this.dataCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                IResultIterator iter = (IResultIterator)entry.getValue();
                if (iter == null) continue;
                try {
                    IQueryResults iresult = iter.getQueryResults();
                    iter.close();
                    iresult.close();
                }
                catch (BirtException ex) {
                    this.log.log(Level.WARNING, ex.getMessage());
                }
            }
            this.dataCache.clear();
            this.dataCache = null;
        }
        super.close();
    }

    private boolean isCascadingParameter(ScalarParameterHandle parameter) {
        return parameter.getContainer() instanceof CascadingParameterGroupHandle;
    }

    private Object[] getParameterValuesAhead(ScalarParameterHandle parameter) {
        if (!$assertionsDisabled && !this.isCascadingParameter(parameter)) {
            throw new AssertionError();
        }
        CascadingParameterGroupHandle parameterGroup = this.getCascadingGroup(parameter);
        SlotHandle parameters = parameterGroup.getParameters();
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        while (i < parameters.getCount()) {
            ScalarParameterHandle tempParameter = (ScalarParameterHandle)parameters.get(i);
            if (tempParameter == parameter) break;
            values.add(this.getParameterValue(tempParameter.getName()));
            ++i;
        }
        return values.toArray();
    }

    private CascadingParameterGroupHandle getCascadingGroup(ScalarParameterHandle parameter) {
        DesignElementHandle handle = parameter.getContainer();
        if (!$assertionsDisabled && !(handle instanceof CascadingParameterGroupHandle)) {
            throw new AssertionError();
        }
        CascadingParameterGroupHandle parameterGroup = (CascadingParameterGroupHandle)handle;
        return parameterGroup;
    }

    private Collection getChoicesFromParameterQuery(ScalarParameterHandle parameter) {
        String dataType = parameter.getDataType();
        boolean fixedOrder = parameter.isFixedOrder();
        String dataSetName = parameter.getDataSetName();
        String valueExpr = parameter.getValueExpr();
        String labelExpr = parameter.getLabelExpr();
        boolean isDistinct = parameter.distinct();
        String sortDirection = parameter.getSortDirection();
        String sortBy = parameter.getSortBy();
        int limit = parameter.getListlimit();
        String pattern = parameter.getPattern();
        return this.createDynamicSelectionChoices(pattern, dataSetName, labelExpr, valueExpr, dataType, limit, fixedOrder, isDistinct, sortDirection, sortBy);
    }

    private IParameterDefnBase getParamDefnBaseByName(ParameterDefnBase param, String name) {
        ParameterDefnBase ret = null;
        if (param instanceof ScalarParameterDefn && name.equals(param.getName())) {
            ret = param;
        } else if (param instanceof ParameterGroupDefn) {
            if (name.equals(param.getName())) {
                ret = param;
            } else {
                Iterator iter = ((ParameterGroupDefn)param).getContents().iterator();
                while (iter.hasNext()) {
                    ParameterDefnBase pBase = (ParameterDefnBase)iter.next();
                    if (!name.equals(pBase.getName())) continue;
                    ret = pBase;
                    break;
                }
            }
        }
        if (ret != null) {
            try {
                return (IParameterDefnBase)ret.clone();
            }
            catch (CloneNotSupportedException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return ret;
    }

    public ArrayList getParameters(ReportDesignHandle handle, boolean includeParameterGroups) {
        if (!$assertionsDisabled && handle == null) {
            throw new AssertionError();
        }
        ParameterIRVisitor visitor = new ParameterIRVisitor(handle);
        ArrayList<IParameterDefnBase> parameters = new ArrayList<IParameterDefnBase>();
        SlotHandle paramSlot = handle.getParameters();
        int i = 0;
        while (i < paramSlot.getCount()) {
            visitor.apply(paramSlot.get(i));
            if (!$assertionsDisabled && visitor.currentElement == null) {
                throw new AssertionError();
            }
            IParameterDefnBase param = (IParameterDefnBase)visitor.currentElement;
            if (!$assertionsDisabled && param.getName() == null) {
                throw new AssertionError();
            }
            parameters.add(param);
            ++i;
        }
        if (includeParameterGroups) {
            return parameters;
        }
        return this.flattenParameter(parameters);
    }

    protected ArrayList flattenParameter(ArrayList params) {
        if (!$assertionsDisabled && params == null) {
            throw new AssertionError();
        }
        ArrayList<IParameterDefnBase> allParameters = new ArrayList<IParameterDefnBase>();
        int n = 0;
        while (n < params.size()) {
            IParameterDefnBase param = (IParameterDefnBase)params.get(n);
            if (param.getParameterType() == 4 || param.getParameterType() == 5) {
                allParameters.addAll(this.flattenParameter(((IParameterGroupDefn)param).getContents()));
            } else {
                allParameters.add(param);
            }
            ++n;
        }
        return allParameters;
    }

    class ParameterIRVisitor
    extends DesignVisitor {
        protected ReportDesignHandle handle;
        protected Object currentElement;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        ParameterIRVisitor(ReportDesignHandle handle) {
            this.handle = handle;
        }

        public void visitParameterGroup(ParameterGroupHandle handle) {
            ParameterGroupDefn paramGroup = new ParameterGroupDefn();
            paramGroup.setHandle((ReportElementHandle)handle);
            paramGroup.setParameterType(4);
            paramGroup.setName(handle.getName());
            paramGroup.setDisplayName(handle.getDisplayName());
            paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
            paramGroup.setHelpText(handle.getHelpText());
            paramGroup.setHelpTextKey(handle.getHelpTextKey());
            SlotHandle parameters = handle.getParameters();
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            int size = parameters.getCount();
            int n = 0;
            while (n < size) {
                this.apply(parameters.get(n));
                if (this.currentElement != null) {
                    paramGroup.addParameter((IParameterDefnBase)this.currentElement);
                }
                ++n;
            }
            this.currentElement = paramGroup;
        }

        public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
            CascadingParameterGroupDefn paramGroup = new CascadingParameterGroupDefn();
            paramGroup.setHandle((ReportElementHandle)handle);
            paramGroup.setParameterType(5);
            paramGroup.setName(handle.getName());
            paramGroup.setDisplayName(handle.getDisplayName());
            paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
            paramGroup.setHelpText(handle.getHelpText());
            paramGroup.setHelpTextKey(handle.getHelpTextKey());
            paramGroup.setPromptText(handle.getPromptText());
            DataSetHandle dset = handle.getDataSet();
            if (dset != null) {
                paramGroup.setDataSet(dset.getName());
            }
            SlotHandle parameters = handle.getParameters();
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            int size = parameters.getCount();
            int n = 0;
            while (n < size) {
                this.apply(parameters.get(n));
                if (this.currentElement != null) {
                    paramGroup.addParameter((IParameterDefnBase)this.currentElement);
                }
                ++n;
            }
            this.currentElement = paramGroup;
        }

        public void visitScalarParameter(ScalarParameterHandle handle) {
            if (!$assertionsDisabled && handle.getName() == null) {
                throw new AssertionError();
            }
            ScalarParameterDefn scalarParameter = new ScalarParameterDefn();
            scalarParameter.setHandle((ReportElementHandle)handle);
            scalarParameter.setParameterType(0);
            scalarParameter.setName(handle.getName());
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                scalarParameter.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            String align = handle.getAlignment();
            if ("center".equals(align)) {
                scalarParameter.setAlignment(2);
            } else if ("left".equals(align)) {
                scalarParameter.setAlignment(1);
            } else if ("right".equals(align)) {
                scalarParameter.setAlignment(3);
            } else {
                scalarParameter.setAlignment(0);
            }
            scalarParameter.setAllowBlank(handle.allowBlank());
            scalarParameter.setAllowNull(handle.allowNull());
            scalarParameter.setIsRequired(handle.isRequired());
            String controlType = handle.getControlType();
            if ("check-box".equals(controlType)) {
                scalarParameter.setControlType(3);
            } else if ("list-box".equals(controlType)) {
                scalarParameter.setControlType(1);
            } else if ("radio-button".equals(controlType)) {
                scalarParameter.setControlType(2);
            } else {
                scalarParameter.setControlType(0);
            }
            scalarParameter.setDefaultValue(handle.getDefaultValue());
            scalarParameter.setDisplayName(handle.getDisplayName());
            scalarParameter.setDisplayNameKey(handle.getDisplayNameKey());
            scalarParameter.setFormat(handle.getPattern());
            scalarParameter.setHelpText(handle.getHelpText());
            scalarParameter.setHelpTextKey(handle.getHelpTextKey());
            scalarParameter.setPromptText(handle.getPromptText());
            scalarParameter.setPromptTextKey(handle.getPromptTextID());
            scalarParameter.setIsHidden(handle.isHidden());
            scalarParameter.setName(handle.getName());
            String valueType = handle.getDataType();
            if ("boolean".equals(valueType)) {
                scalarParameter.setDataType(5);
            } else if ("dateTime".equals(valueType)) {
                scalarParameter.setDataType(4);
            } else if ("date".equals(valueType)) {
                scalarParameter.setDataType(7);
            } else if ("time".equals(valueType)) {
                scalarParameter.setDataType(8);
            } else if ("decimal".equals(valueType)) {
                scalarParameter.setDataType(3);
            } else if ("float".equals(valueType)) {
                scalarParameter.setDataType(2);
            } else if ("string".equals(valueType)) {
                scalarParameter.setDataType(1);
            } else if ("integer".equals(valueType)) {
                scalarParameter.setDataType(6);
            } else {
                scalarParameter.setDataType(0);
            }
            ArrayList<ParameterSelectionChoice> values = new ArrayList<ParameterSelectionChoice>();
            Iterator selectionIter = handle.choiceIterator();
            while (selectionIter.hasNext()) {
                SelectionChoiceHandle selection = (SelectionChoiceHandle)selectionIter.next();
                ParameterSelectionChoice selectionChoice = new ParameterSelectionChoice(this.handle);
                selectionChoice.setLabel(selection.getLabelKey(), selection.getLabel());
                selectionChoice.setValue(selection.getValue(), scalarParameter.getDataType());
                values.add(selectionChoice);
            }
            scalarParameter.setSelectionList(values);
            scalarParameter.setAllowNewValues(!handle.isMustMatch());
            scalarParameter.setFixedOrder(handle.isFixedOrder());
            String paramType = handle.getValueType();
            if ("static".equals(paramType) && scalarParameter.getSelectionList() != null && scalarParameter.getSelectionList().size() > 0) {
                scalarParameter.setSelectionListType(2);
            } else if ("dynamic".equals(paramType)) {
                scalarParameter.setSelectionListType(1);
            } else {
                scalarParameter.setSelectionListType(0);
            }
            scalarParameter.setValueConcealed(handle.isConcealValue());
            this.currentElement = scalarParameter;
        }
    }

    static class SelectionChoice
    implements IParameterSelectionChoice {
        String label;
        Object value;

        SelectionChoice(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

