/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class TableContent
extends AbstractContent
implements ITableContent {
    protected ArrayList columns = new ArrayList();
    protected String caption;
    protected String captionKey;
    protected Boolean headerRepeat;
    protected static final short FIELD_COLUMNS = 1000;
    protected static final short FIELD_CAPTION = 1001;
    protected static final short FIELD_CAPTIONKEY = 1002;
    protected static final short FIELD_HEADERREPEAT = 1003;

    public int getContentType() {
        return 10;
    }

    public void setHeaderRepeat(boolean headerRepeat) {
        if (this.generateBy instanceof TableItemDesign && ((TableItemDesign)this.generateBy).isRepeatHeader() == headerRepeat) {
            this.headerRepeat = null;
            return;
        }
        this.headerRepeat = headerRepeat;
    }

    public boolean isHeaderRepeat() {
        if (this.headerRepeat != null) {
            return this.headerRepeat;
        }
        if (this.generateBy instanceof TableItemDesign) {
            return ((TableItemDesign)this.generateBy).isRepeatHeader();
        }
        return false;
    }

    public TableContent(IReportContent report) {
        super(report);
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitTable(this, value);
    }

    public String getCaption() {
        if (this.caption == null && this.generateBy instanceof TableItemDesign) {
            return ((TableItemDesign)this.generateBy).getCaption();
        }
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCaptionKey(String key) {
        this.captionKey = key;
    }

    public String getCaptionKey() {
        if (this.captionKey == null && this.generateBy instanceof TableItemDesign) {
            return ((TableItemDesign)this.generateBy).getCaptionKey();
        }
        return this.captionKey;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public IColumn getColumn(int index) {
        return (IColumn)this.columns.get(index);
    }

    public void addColumn(IColumn column) {
        this.columns.add(column);
    }

    public ITableBandContent getHeader() {
        return this.getTableBand(1);
    }

    public ITableBandContent getFooter() {
        return this.getTableBand(2);
    }

    protected ITableBandContent getTableBand(int type) {
        if (this.children == null) {
            return null;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            ITableBandContent tableBand;
            Object child = iter.next();
            if (!(child instanceof ITableBandContent) || (tableBand = (ITableBandContent)child).getBandType() != type) continue;
            return tableBand;
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.columns != null) {
            IOUtil.writeShort((OutputStream)out, (short)1000);
            IOUtil.writeInt((OutputStream)out, (int)this.columns.size());
            int i = 0;
            while (i < this.columns.size()) {
                Column column = (Column)this.columns.get(i);
                column.writeObject(out);
                ++i;
            }
        }
        if (this.caption != null) {
            IOUtil.writeShort((OutputStream)out, (short)1001);
            IOUtil.writeString((DataOutputStream)out, (String)this.caption);
        }
        if (this.captionKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)1002);
            IOUtil.writeString((DataOutputStream)out, (String)this.captionKey);
        }
        if (this.headerRepeat != null) {
            IOUtil.writeShort((OutputStream)out, (short)1003);
            IOUtil.writeBool((OutputStream)out, (boolean)this.headerRepeat);
        }
    }

    public boolean needSave() {
        return true;
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 1000: {
                int columnsSize = IOUtil.readInt((InputStream)in);
                int i = 0;
                while (i < columnsSize) {
                    Column column = new Column(this.report);
                    column.readObject(in);
                    this.addColumn(column);
                    ++i;
                }
                break;
            }
            case 1001: {
                this.caption = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 1002: {
                this.captionKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 1003: {
                this.headerRepeat = IOUtil.readBool((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }
}

