/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.emitter;

import java.util.LinkedList;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.emitter.ReportItemEmitterExecutor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class ReportEmitterExecutor
extends WrappedReportExecutor {
    LinkedList executors = new LinkedList();
    IReportContent report;
    IContentEmitter emitter;

    public ReportEmitterExecutor(IReportExecutor executor, IContentEmitter emitter) {
        super(executor);
        this.emitter = emitter;
    }

    protected void closeWrappedExecutor(IReportItemExecutor executor) {
        this.executors.addLast(executor);
    }

    protected IReportItemExecutor createWrappedExecutor(IReportItemExecutor executor) {
        ReportItemEmitterExecutor emitterExecutor = null;
        if (this.executors.isEmpty()) {
            emitterExecutor = new ReportItemEmitterExecutor(this, executor);
        } else {
            emitterExecutor = (ReportItemEmitterExecutor)this.executors.removeLast();
            emitterExecutor.setExecutor(executor);
        }
        return emitterExecutor;
    }

    public void close() {
        if (this.report != null) {
            this.emitter.end(this.report);
        }
        super.close();
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return this.reportExecutor.createPageExecutor(pageNumber, pageDesign);
    }

    public IReportContent execute() {
        this.report = super.execute();
        if (this.report != null) {
            this.emitter.start(this.report);
        }
        return this.report;
    }
}

