/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ITextItemEventHandler;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.TextItem;
import org.eclipse.birt.report.engine.script.internal.instance.TextItemInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;

public class TextItemScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(TextItemHandle textItemHandle, ExecutionContext context) {
        try {
            TextItem textItem = new TextItem(textItemHandle);
            ITextItemEventHandler eh = TextItemScriptExecutor.getEventHandler(textItemHandle, context);
            if (eh != null) {
                eh.onPrepare(textItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            TextItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            TextItemInstance textItem = null;
            if (content instanceof TextContent) {
                textItem = new TextItemInstance((ITextContent)content, context);
            } else if (content instanceof ForeignContent) {
                textItem = new TextItemInstance((IForeignContent)content, context);
            }
            if (TextItemScriptExecutor.handleJS(textItem, textItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ITextItemEventHandler eh = TextItemScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onCreate(textItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            TextItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            TextItemInstance textItem = null;
            if (content instanceof TextContent) {
                textItem = new TextItemInstance((ITextContent)content, context);
            } else if (content instanceof ForeignContent) {
                textItem = new TextItemInstance((IForeignContent)content, context);
            }
            if (TextItemScriptExecutor.handleJS(textItem, textItemDesign.getOnRender(), context).didRun()) {
                return;
            }
            ITextItemEventHandler eh = TextItemScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onRender(textItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            TextItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            TextItemInstance textItem = null;
            if (content instanceof TextContent) {
                textItem = new TextItemInstance((ITextContent)content, context);
            } else if (content instanceof ForeignContent) {
                textItem = new TextItemInstance((IForeignContent)content, context);
            }
            if (TextItemScriptExecutor.handleJS(textItem, textItemDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ITextItemEventHandler eh = TextItemScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onPageBreak(textItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            TextItemScriptExecutor.addException(context, e);
        }
    }

    private static ITextItemEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        if (design.getHandle() instanceof TextItemHandle) {
            TextItemHandle handle = (TextItemHandle)design.getHandle();
            if (handle == null) {
                return null;
            }
            return TextItemScriptExecutor.getEventHandler(handle, context);
        }
        return null;
    }

    private static ITextItemEventHandler getEventHandler(TextItemHandle handle, ExecutionContext context) {
        ITextItemEventHandler eh = null;
        try {
            eh = (ITextItemEventHandler)TextItemScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ITextItemEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TextItemScriptExecutor.addClassCastException(context, e, string, clazz);
        }
        return eh;
    }
}

