/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;

public class DimensionViewTask
extends AbstractCrosstabModelTask {
    protected DimensionViewHandle dimensionView = null;
    protected int axisType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.de.internal.DimensionViewTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DimensionViewTask(DimensionViewHandle focus) {
        super(focus);
        this.dimensionView = focus;
        this.axisType = this.dimensionView.getAxisType();
    }

    public LevelViewHandle insertLevel(LevelHandle levelHandle, int index) throws SemanticException {
        if (levelHandle != null) {
            if (!levelHandle.getContainer().getContainer().getQualifiedName().equals(this.dimensionView.getCubeDimensionName())) {
                this.dimensionView.getLogger().log(Level.WARNING, "");
                return null;
            }
            if (this.dimensionView.getLevel(levelHandle.getQualifiedName()) != null) {
                this.dimensionView.getLogger().log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_LEVEL", levelHandle.getQualifiedName());
                throw new CrosstabException(this.dimensionView.getModelHandle().getElement(), new String[]{levelHandle.getQualifiedName(), this.dimensionView.getModelHandle().getElement().getIdentifier()}, "Error.CrosstabException.DUPLICATE_LEVEL");
            }
        }
        CommandStack stack = this.dimensionView.getCommandStack();
        stack.startTrans(Messages.getString("DimensionViewTask.msg.insert.level"));
        LevelViewHandle levelView = null;
        try {
            ExtendedItemHandle extendedItemHandle = CrosstabExtendedItemFactory.createLevelView(this.dimensionView.getModuleHandle(), levelHandle);
            if (extendedItemHandle != null) {
                this.dimensionView.getLevelsProperty().add((DesignElementHandle)extendedItemHandle, index);
                levelView = (LevelViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItemHandle, "LevelView");
                if (levelHandle != null && this.crosstab != null) {
                    this.doPostInsert(levelView);
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return levelView;
    }

    private void doPostInsert(LevelViewHandle levelView) throws SemanticException {
        if (levelView.isInnerMost()) {
            if (CrosstabModelUtil.getAllLevelCount(this.crosstab, this.axisType) <= 1) {
                this.addAggregationForLevel(levelView, this.axisType);
                if (this.crosstab.getGrandTotal(this.axisType) == null) {
                    this.removeMeasureAggregations(this.axisType);
                }
            } else {
                this.addAggregationForLevel(levelView, this.axisType);
                LevelViewHandle precedingLevel = CrosstabModelUtil.getPrecedingLevel(levelView);
                int counterAxisType = CrosstabModelUtil.getOppositeAxisType(this.axisType);
                if (!$assertionsDisabled && precedingLevel == null) {
                    throw new AssertionError();
                }
                LevelViewHandle innerMostLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                if (precedingLevel.getAggregationHeader() != null) {
                    if (innerMostLevelView != null) {
                        String dimensionName = ((DimensionViewHandle)innerMostLevelView.getContainer()).getCubeDimensionName();
                        String levelName = innerMostLevelView.getCubeLevelName();
                        List measureList = precedingLevel.getAggregationMeasures();
                        ArrayList<String> functionList = new ArrayList<String>();
                        int i = 0;
                        while (i < measureList.size()) {
                            MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                            String function = precedingLevel.getAggregationFunction(measureView);
                            functionList.add(function);
                            ++i;
                        }
                        CrosstabModelUtil.addMeasureAggregations(this.crosstab, dimensionName, levelName, counterAxisType, ((DimensionViewHandle)precedingLevel.getContainer()).getCubeDimensionName(), precedingLevel.getCubeLevelName(), measureList, functionList);
                    }
                } else {
                    this.removeMeasureAggregations(precedingLevel);
                }
            }
        } else if (levelView.getAggregationHeader() != null) {
            this.addAggregationForLevel(levelView, this.axisType);
        }
    }

    private void addAggregationForLevel(LevelViewHandle levelView, int axisType) throws SemanticException {
        if (!$assertionsDisabled && !CrosstabModelUtil.isValidAxisType(axisType)) {
            throw new AssertionError();
        }
        if (levelView != null && levelView.getAxisType() != axisType) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle tempDimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < tempDimensionView.getLevelCount()) {
                boolean isInnerMost;
                LevelViewHandle tempLevelView = tempDimensionView.getLevel(level);
                if (!(levelView != null && (isInnerMost = levelView.isInnerMost()) && tempLevelView.isInnerMost() || tempLevelView.getAggregationHeader() == null)) {
                    List measureList = tempLevelView.getAggregationMeasures();
                    AbstractCrosstabModelTask.AggregationInfo infor = this.getAggregationInfo(levelView, tempLevelView);
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                        String function = tempLevelView.getAggregationFunction(measureView);
                        CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || CrosstabModelUtil.getAllLevelCount(this.crosstab, counterAxisType) == 0) {
            List measureList = this.crosstab.getAggregationMeasures(counterAxisType);
            AbstractCrosstabModelTask.AggregationInfo infor = this.getAggregationInfo(levelView, null);
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                String function = this.crosstab.getAggregationFunction(counterAxisType, measureView);
                CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
                ++i;
            }
        }
    }

    public void removeLevel(String name) throws SemanticException {
        LevelViewHandle levelView = this.dimensionView.getLevel(name);
        if (levelView != null) {
            this.removeLevel(levelView, true);
        }
    }

    void removeLevel(LevelViewHandle levelView, boolean needTransaction) throws SemanticException {
        if (!$assertionsDisabled && levelView == null) {
            throw new AssertionError();
        }
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.dimensionView.getCommandStack();
            stack.startTrans(Messages.getString("DimensionViewTask.msg.remove.level"));
        }
        try {
            if (this.crosstab != null) {
                this.doPreRemove(levelView);
            }
            levelView.getModelHandle().drop();
            if (this.crosstab != null) {
                this.validateFilterCondition();
                this.validateSort();
            }
        }
        catch (SemanticException e) {
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
    }

    public void removeLevel(int index) throws SemanticException {
        LevelViewHandle levelView = this.dimensionView.getLevel(index);
        if (levelView != null) {
            this.removeLevel(levelView, true);
        }
    }

    private void doPreRemove(LevelViewHandle levelView) throws SemanticException {
        if (this.crosstab == null) {
            return;
        }
        int axisType = this.dimensionView.getAxisType();
        if (levelView.isInnerMost()) {
            if (CrosstabModelUtil.getAllLevelCount(this.crosstab, axisType) <= 1) {
                if (this.crosstab.getGrandTotal(axisType) == null) {
                    this.addAggregationForLevel(null, axisType);
                }
                this.removeMeasureAggregations(levelView);
            } else {
                LevelViewHandle precedingLevel = CrosstabModelUtil.getPrecedingLevel(levelView);
                if (!$assertionsDisabled && precedingLevel == null) {
                    throw new AssertionError();
                }
                if (precedingLevel.getAggregationHeader() != null) {
                    int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
                    LevelViewHandle innerMostLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                    if (innerMostLevelView != null) {
                        this.removeMeasureAggregation(precedingLevel, innerMostLevelView);
                        precedingLevel.getAggregationHeaderProperty().drop(0);
                    } else {
                        precedingLevel.removeSubTotal();
                    }
                } else {
                    this.addAggregationForLevel(precedingLevel, axisType);
                }
                this.removeMeasureAggregations(levelView);
            }
        } else if (levelView.getAggregationHeader() != null) {
            this.removeMeasureAggregations(levelView);
        }
    }

    private void validateFilterCondition() throws SemanticException {
        this.validateProperty("filter", "expr", "member");
    }

    private void validateSort() throws SemanticException {
        this.validateProperty("sort", "key", "member");
    }

    private void validateProperty(String propName, String exprePropName, String memberValuePropName) throws SemanticException {
        if (!$assertionsDisabled && this.crosstab == null) {
            throw new AssertionError();
        }
        CubeHandle cube = this.crosstab.getCube();
        if (cube == null) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(this.axisType);
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle dimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < dimensionView.getLevelCount()) {
                LevelViewHandle levelView = dimensionView.getLevel(level);
                DesignElementHandle levelHandle = levelView.getModelHandle();
                int count = levelHandle.getContentCount(propName);
                int i = 0;
                while (i < count) {
                    DesignElementHandle item = levelHandle.getContent(propName, i);
                    String expression = item.getStringProperty(exprePropName);
                    this.validateMemberValue(cube, levelView, item, expression, memberValuePropName);
                    ++i;
                }
                ++level;
            }
            ++dimension;
        }
    }

    private void validateMemberValue(CubeHandle cube, LevelViewHandle levelView, DesignElementHandle item, String expression, String memberValuePropName) throws SemanticException {
        MemberValueHandle newMemberValue;
        if (!$assertionsDisabled && this.crosstab == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cube == null) {
            throw new AssertionError();
        }
        if (!(cube instanceof TabularCubeHandle) || expression == null || expression.length() == 0) {
            return;
        }
        List validatedLevelList = this.getReferencedLevels(levelView, expression);
        MemberValueHandle oldMemberValue = (MemberValueHandle)item.getContent(memberValuePropName, 0);
        HashMap<String, String> levelValueMap = new HashMap<String, String>();
        MemberValueHandle tempMember = oldMemberValue;
        while (tempMember != null) {
            String levelName = tempMember.getCubeLevelName();
            String levelValue = tempMember.getValue();
            levelValueMap.put(levelName, levelValue);
            tempMember = (MemberValueHandle)tempMember.getContent("memberValues", 0);
        }
        ElementFactory factory = this.dimensionView.getModuleHandle().getElementFactory();
        tempMember = newMemberValue = factory.newMemberValue();
        MemberValueHandle parentMember = null;
        if (validatedLevelList != null) {
            int i = 0;
            while (i < validatedLevelList.size()) {
                ILevelDefinition levelDefn = (ILevelDefinition)validatedLevelList.get(i);
                String levelName = this.getLevelHandle(levelDefn);
                tempMember.setStringProperty("level", levelName);
                tempMember.setProperty("value", levelValueMap.get(levelName));
                if (parentMember != null) {
                    parentMember.add("memberValues", (DesignElementHandle)tempMember, 0);
                }
                parentMember = tempMember;
                tempMember = factory.newMemberValue();
                ++i;
            }
        }
        item.clearProperty(memberValuePropName);
        item.add(memberValuePropName, (DesignElementHandle)newMemberValue);
    }

    private List getReferencedLevels(LevelViewHandle level, String bindingExpr) {
        DesignElementHandle dimensionHandle;
        List retList = new ArrayList();
        LevelHandle levelHandle = level.getCubeLevel();
        if (level.getCubeLevel() == null) {
            return retList;
        }
        DesignElementHandle hierarchyHandle = levelHandle.getContainer();
        DesignElementHandle designElementHandle = dimensionHandle = hierarchyHandle == null ? null : hierarchyHandle.getContainer();
        if (dimensionHandle == null) {
            return retList;
        }
        String targetLevel = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)levelHandle.getName());
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            cubeQueryDefn = CrosstabModelUtil.createBindingQuery(this.crosstab);
            retList = session.getCubeQueryUtil().getReferencedLevels(targetLevel, bindingExpr, cubeQueryDefn);
        }
        catch (Exception e) {
            this.dimensionView.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        return retList;
    }

    private String getLevelHandle(ILevelDefinition levelDefn) {
        if (!$assertionsDisabled && this.crosstab == null) {
            throw new AssertionError();
        }
        String levelName = levelDefn.getName();
        String dimensionName = levelDefn.getHierarchy().getDimension().getName();
        DimensionViewHandle dimension = this.crosstab.getDimension(dimensionName);
        if (!$assertionsDisabled && dimension == null) {
            throw new AssertionError();
        }
        LevelViewHandle level = dimension.findLevel(levelName);
        return level.getCubeLevelName();
    }
}

