/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractQuery;
import org.eclipse.cosmos.dc.common.api.impl.SimpleDataQueryResult;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.DataManagerImpl;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedParameter;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.spec.capabilitiy.DataBrokerCapability;
import org.w3c.dom.Element;

@ManagedResource
public class DataBroker
extends AbstractQuery
implements DataBrokerCapability {
    private static Class[] supportedTypes = new Class[]{String.class};
    private static String[] supportedDialects = new String[]{"SDMX"};
    public static final String NAMESPACE = "http://cosmos.eclipse.org/dc/databroker";
    public static final QName DATAMANAGERS_QNAME = new QName("http://cosmos.eclipse.org/dc/databroker", "DataManagers");
    public static final QName DATAMANAGER_QNAME = new QName("http://cosmos.eclipse.org/dc/databroker", "DataManager");
    public static final QName DATAMANAGER_CLASS_QNAME = new QName("http://cosmos.eclipse.org/dc/databroker", "Classification");
    public static final QName DATAMANAGER_DIALECT_QNAME = new QName("http://cosmos.eclipse.org/dc/databroker", "Dialect");
    public static final String CFG_NAMESPACE = "http://cosmos.eclipse.org/dc/databroker/1.0";
    public static String CONFIG_FILENAME = "/META-INF/config/DomainConfig.xml";
    public static int BROKER_PORT = 8080;
    public static String BROKER_CLASSIFICATION = "DataBroker";
    private SqlMapClient sqlMapper;
    @ManagedProperty(resourceID=true)
    private String identifier;

    public String getIdentifier() {
        return "DataBrokerIdentifierValue";
    }

    public DataBroker(ContributionManager manager, Element binding) {
        super(manager);
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/local/registry/persistence/sql/SqlMapConfig.xml");
                this.sqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
                reader.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class type = classArray[n];
                if (((IDataFilterService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataTransformService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n3 = classArray.length;
            while (n < n3) {
                Class type = classArray[n];
                if (((IDataTransformService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataResponseService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n4 = classArray.length;
            while (n < n4) {
                Class type = classArray[n];
                if (((IDataResponseService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public String[] getSupportedDialects() {
        return supportedDialects;
    }

    public String[] getSupportedResponses() {
        return null;
    }

    public IDataQueryResult pageQuery(String dialect, String response, String queryString, String dataSource, int max, int start) throws Exception {
        return null;
    }

    public IDataQueryResult query(String dialect, String response, String queryString, String dataSource) throws Exception {
        return null;
    }

    public boolean supportedQuery(String dialect, String response) {
        return false;
    }

    public Class[] getOutputTypes() {
        return null;
    }

    public IDataQueryResult getDataManagers(@ManagedParameter(displayName="classification") String classification) throws Exception {
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        Element dmNames = XmlUtils.createElement((QName)DATAMANAGERS_QNAME);
        if (classification == null) {
            classification = "all";
        }
        List obs = null;
        obs = "all".equalsIgnoreCase(classification) ? this.sqlMapper.queryForList("getAllDataManagers") : this.sqlMapper.queryForList("getDataManagers", (Object)classification);
        result.setRawResponseCollection(new ArrayList());
        for (DataManagerImpl ob : obs) {
            Element dmElement = XmlUtils.createElement((QName)DATAMANAGER_QNAME);
            dmElement.setAttribute("name", ob.getName());
            Date date = ob.getLastMsgTime();
            SimpleDateFormat sdf = new SimpleDateFormat();
            dmElement.setAttribute("lastmsgtime", sdf.format(date));
            Element dmClass = XmlUtils.createElement((QName)DATAMANAGER_CLASS_QNAME);
            dmClass.setTextContent(ob.getClassification());
            dmElement.appendChild(dmClass);
            Element dmDialect = XmlUtils.createElement((QName)DATAMANAGER_DIALECT_QNAME);
            dmDialect.setTextContent(ob.getDialect());
            dmElement.appendChild(dmDialect);
            Element dmEPR = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "EndpointReference"));
            Element dmAddress = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "Address"));
            dmAddress.setTextContent(ob.getEndpointAddress());
            Element dmRef = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters"));
            Element dmResid = XmlUtils.createElement((QName)new QName("http://www.w3.org/2005/08/addressing", "ResourceId"));
            dmResid.setTextContent(ob.getEndpointResourceId());
            dmRef.appendChild(dmResid);
            dmEPR.appendChild(dmAddress);
            dmEPR.appendChild(dmRef);
            dmElement.appendChild(dmEPR);
            dmNames.appendChild(dmElement);
        }
        result.setRawResponse((Object)dmNames);
        return result;
    }

    public boolean registerDataManager(@ManagedParameter(displayName="endpointAddress") String endpointAddress, @ManagedParameter(displayName="endpointResourceId") String endpointResourceId, @ManagedParameter(displayName="name") String name, @ManagedParameter(displayName="classification") String classification, @ManagedParameter(displayName="dialect") String dialect) throws Exception {
        DataManagerImpl dataManager = new DataManagerImpl();
        dataManager.setEndpointAddress(endpointAddress);
        dataManager.setEndpointResourceId(endpointResourceId);
        dataManager.setName(name);
        dataManager.setClassification(classification);
        dataManager.setDialect(dialect);
        dataManager.setLastMsgTime(new Date());
        this.sqlMapper.insert("addDataManager", (Object)dataManager);
        return true;
    }

    public boolean deregisterDataManager(@ManagedParameter(displayName="name") String name) throws Exception {
        int rowcount = this.sqlMapper.delete("deleteDataManager", (Object)name);
        return rowcount == 1;
    }

    public boolean pingDataBroker(@ManagedParameter(displayName="dataManagerName") String dataManagerName) throws Exception {
        DataManagerImpl dataManager = new DataManagerImpl();
        dataManager.setName(dataManagerName);
        dataManager.setLastMsgTime(new Date());
        int rowcount = this.sqlMapper.update("pingDataManager", (Object)dataManager);
        return rowcount == 1;
    }
}

