/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LoggingParsersPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.hyades.logging.parsers";
    protected static Logger logger = Logger.getLogger("org.eclipse.hyades.logging.parsers");
    private static LoggingParsersPlugin instance = null;
    private static ResourceBundle resourceBundle;

    public LoggingParsersPlugin() {
        instance = this;
        try {
            resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
    }

    public static LoggingParsersPlugin getPlugin() {
        return instance;
    }

    public static ResourceBundle getResourceBundle() {
        if (resourceBundle == null) {
            try {
                resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (MissingResourceException missingResourceException) {
                resourceBundle = null;
            }
        }
        return resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static void logError(String text) {
        LoggingParsersPlugin.logError(new Throwable(text));
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(4, PLUGIN_ID, 0, throwable.toString(), throwable);
        LoggingParsersPlugin.log((IStatus)status);
    }

    public static void logError(IStatus status) {
        LoggingParsersPlugin.log(status);
    }

    protected static void log(IStatus status) {
        if (instance == null) {
            LoggingParsersPlugin.logging(status);
        } else {
            instance.getLog().log(status);
        }
    }

    protected static void logging(IStatus status) {
        Level level = Level.INFO;
        switch (status.getSeverity()) {
            case 4: {
                level = Level.SEVERE;
                break;
            }
            case 8: {
                level = Level.INFO;
                break;
            }
            case 0: {
                level = Level.INFO;
                break;
            }
            case 1: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.WARNING;
            }
        }
        logger.log(level, status.getMessage(), status.getException());
    }

    public static void logInfo(String text) {
        Status status = new Status(1, PLUGIN_ID, 0, text, null);
        LoggingParsersPlugin.log((IStatus)status);
    }

    public static void logInfo(Throwable throwable) {
        Status status = new Status(1, PLUGIN_ID, 0, throwable.toString(), throwable);
        LoggingParsersPlugin.log((IStatus)status);
    }

    public static void logWarning(String text) {
        Status status = new Status(2, PLUGIN_ID, 0, text, new Throwable(text));
        LoggingParsersPlugin.log((IStatus)status);
    }

    public static void logWarning(Throwable throwable) {
        Status status = new Status(2, PLUGIN_ID, 0, throwable.toString(), throwable);
        LoggingParsersPlugin.log((IStatus)status);
    }
}

