/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.adapter.sensors;

import com.ibm.icu.util.ULocale;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.impl.SensorStatus;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StaticParserSensor
extends Sensor {
    public static final String PATH_SEPARATOR = System.getProperty("file.separator");
    protected String parserClassName = null;
    protected Parser parser = null;
    private String directory = null;
    private String fileName = null;
    protected String rawLogFileName = null;

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        String directory = null;
        String fileName = null;
        String className = null;
        String propertyName = null;
        String propertyValue = null;
        Element sensorProperty = null;
        Element sensorTypeInstance = null;
        Element element = this.getConfiguration();
        Hashtable sensorParameters = this.getProperties();
        Hashtable<String, Object> parserParameters = new Hashtable<String, Object>();
        boolean propertiesPresent = false;
        if (sensorParameters != null && !sensorParameters.isEmpty()) {
            parserParameters.putAll(sensorParameters);
            directory = (String)parserParameters.get("directory");
            fileName = (String)parserParameters.get("fileName");
            className = (String)parserParameters.get("parserClassName");
            propertiesPresent = true;
        } else if (element != null) {
            NodeList sensorNodes = element.getChildNodes();
            int i = 0;
            while (i < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item(i).getNodeType() == 1 && (sensorNode = (Element)sensorNodes.item(i)).getTagName().equals("sensor:StaticParserSensor")) {
                    String file;
                    String dir;
                    sensorTypeInstance = sensorNode;
                    if (sensorTypeInstance.hasAttribute("directory") && (dir = sensorTypeInstance.getAttribute("directory")) != null && dir.length() > 0 && directory == null) {
                        directory = dir;
                    }
                    if (sensorTypeInstance.hasAttribute("fileName") && (file = sensorTypeInstance.getAttribute("fileName")) != null && file.length() > 0 && fileName == null) {
                        fileName = file;
                    }
                    if (sensorTypeInstance.hasAttribute("parserClassName")) {
                        className = sensorTypeInstance.getAttribute("parserClassName");
                    }
                    sensorNodes = sensorNode.getChildNodes();
                    int j = 0;
                    while (j < sensorNodes.getLength()) {
                        if (sensorNodes.item(j).getNodeType() == 1) {
                            sensorProperty = (Element)sensorNodes.item(j);
                            if (sensorProperty.hasAttribute("propertyName")) {
                                propertyName = sensorProperty.getAttribute("propertyName");
                            }
                            if (sensorProperty.hasAttribute("propertyValue")) {
                                propertyValue = sensorProperty.getAttribute("propertyValue");
                            }
                            if (propertyName != null && propertyName.length() > 0 && propertyValue != null && propertyValue.length() > 0) {
                                parserParameters.put(propertyName, propertyValue);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (directory == null || directory.length() == 0 || fileName == null || fileName.length() == 0 || className == null || className.length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(directory);
        this.setFileName(fileName);
        this.setParserClassName(className);
        this.rawLogFileName = this.getDirectory().endsWith(PATH_SEPARATOR) ? String.valueOf(this.getDirectory()) + this.getFileName() : String.valueOf(this.getDirectory()) + PATH_SEPARATOR + this.getFileName();
        Locale locale = null;
        ULocale ulocale = null;
        boolean continuousContext = false;
        boolean enableICU = false;
        String charset = null;
        StaticParserSensor current = this;
        while (current != null) {
            if (current instanceof IContext) {
                IContext context = (IContext)current;
                charset = context.getCharset();
                if (context instanceof Context) {
                    continuousContext = ((Context)context).getContinuousOperation();
                    enableICU = ((Context)context).isEnableICU();
                    if (enableICU) {
                        ulocale = ((Context)context).getULocale();
                    }
                }
                if (enableICU) break;
                locale = context.getLocale();
                break;
            }
            current = current.getParent();
        }
        if (charset == null) {
            charset = System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? "IBM-1047" : "UTF-8";
        }
        if (enableICU && ulocale == null) {
            ulocale = ULocale.getDefault();
        } else if (!enableICU && locale == null) {
            locale = Locale.getDefault();
        }
        parserParameters.put("file_path", this.rawLogFileName);
        parserParameters.put("array_size", new Integer(this.maximumBlocking));
        parserParameters.put("file_footer_size", new Integer(this.fileFooterSize));
        parserParameters.put("confidence_buffer_size", new Integer(this.confidenceBufferSize));
        parserParameters.put("characater_set", charset);
        if (locale != null) {
            parserParameters.put("locale", locale);
        }
        if (ulocale != null) {
            parserParameters.put("ULocale", ulocale);
            parserParameters.put("locale", ulocale.toLocale());
            parserParameters.put("enableICU", new Boolean(enableICU));
        }
        parserParameters.put("continuous", new Boolean(continuousContext));
        if (!propertiesPresent) {
            parserParameters.put("directory", directory);
            parserParameters.put("fileName", fileName);
        }
        try {
            this.parser = (Parser)this.getParser(this.getParserClassName());
        }
        catch (AdapterInvalidConfig e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AdapterInvalidConfig(e);
        }
        try {
            this.parser.setConfiguration(parserParameters);
            this.parser.preParse();
        }
        catch (Throwable e) {
            throw new AdapterInvalidConfig(e);
        }
    }

    public Object[] testGetNext() {
        Object[] eventArray = new CommonBaseEvent[]{new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.config.sensors.StaticParserSensor").createCommonBaseEvent()};
        return eventArray;
    }

    public Object[] getNext() {
        if (this.parser == null) {
            return null;
        }
        Object[] messages = null;
        try {
            this.parser.setFlushingMode(this.flushingMode);
            messages = this.parser.parseNext();
        }
        catch (Throwable t) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Parsing_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.rawLogFileName, t.toString()});
            event.setSeverity((short)50);
            this.log(event);
        }
        if (messages != null && messages[0] != null) {
            int i = 0;
            while (i < messages.length) {
                if (messages[i] != null) {
                    this.incrementItemsProcessedCount();
                }
                ++i;
            }
            ((SensorStatus)this.status).setProcessedSize(this.parser.getProcessedSize());
            ((SensorStatus)this.status).setTotalSize(this.parser.getTotalSize());
            return messages;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.parser != null) {
                this.parser.postParse();
            }
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Parsing_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.rawLogFileName, e.toString()});
            event.setSeverity((short)60);
            this.log(event);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
        this.updateConfigurationPropertyChild("directory", directory);
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateConfigurationPropertyChild("fileName", fileName);
    }

    public String getParserClassName() {
        return this.parserClassName;
    }

    public void setParserClassName(String string) {
        this.parserClassName = string;
        this.updateConfigurationPropertyChild("parserClassName", string);
    }

    private IParser getParser(String classname) throws AdapterInvalidConfig {
        try {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "staticParser");
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                if (elem.getAttribute("name").equals(classname)) {
                    try {
                        return (IParser)elem.createExecutableExtension("name");
                    }
                    catch (Throwable e) {
                        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                        event.setMsg(String.valueOf(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_GetParser_Failure_ERROR_", (String)classname)) + "  " + Messages.getString((String)"EXCEPTION") + " = " + e.toString());
                        event.setSeverity((short)30);
                        this.log(event);
                        throw new AdapterException(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_GetParser_Failure_ERROR_", (String)classname), e);
                    }
                }
                ++i;
            }
        }
        catch (AdapterException e) {
            throw new AdapterInvalidConfig(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_Parser_Class_Load_ERROR_", (String)classname), (Throwable)e);
        }
        catch (Throwable throwable) {}
        try {
            return (IParser)Class.forName(this.getParserClassName()).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdapterInvalidConfig(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_Parser_Class_Load_ERROR_", (String)classname));
        }
        catch (Throwable t) {
            throw new AdapterInvalidConfig(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_Parser_Class_Load_ERROR_", (String)classname), t);
        }
    }
}

