/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.ITrueTypeWriter;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.TrueTypeFont;
import org.eclipse.birt.report.engine.emitter.postscript.util.FileUtil;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.w3c.dom.css.CSSValue;

public class PostscriptWriter {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES = "Times";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    protected static final int DEFAULT_PAGE_HEIGHT = 792;
    protected static final int DEFAULT_PAGE_WIDTH = 612;
    protected static final byte[] hd = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    protected PrintStream out = System.out;
    protected Color clr = Color.white;
    protected Font font = new Font(1, 12.0f, 0);
    private int pageIndex = 1;
    private int pageHeight = 792;
    private int pageWidth = 612;
    private static Set intrinsicFonts = new HashSet();
    private Map trueTypeFontWriters = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        intrinsicFonts.add(COURIER);
        intrinsicFonts.add(COURIER_BOLD);
        intrinsicFonts.add(COURIER_OBLIQUE);
        intrinsicFonts.add(COURIER_BOLDOBLIQUE);
        intrinsicFonts.add(HELVETICA);
        intrinsicFonts.add(HELVETICA_BOLD);
        intrinsicFonts.add(HELVETICA_OBLIQUE);
        intrinsicFonts.add(HELVETICA_BOLDOBLIQUE);
        intrinsicFonts.add(SYMBOL);
        intrinsicFonts.add(TIMES);
        intrinsicFonts.add(TIMES_ROMAN);
        intrinsicFonts.add(TIMES_BOLD);
        intrinsicFonts.add(TIMES_ITALIC);
        intrinsicFonts.add(TIMES_BOLDITALIC);
        intrinsicFonts.add(ZAPFDINGBATS);
    }

    public static boolean isIntrinsicFont(String fontName) {
        return intrinsicFonts.contains(fontName);
    }

    public PostscriptWriter(OutputStream o, String title) {
        this.out = new PrintStream(o);
        this.emitProlog(title);
        FontHandler.prepareFonts();
    }

    public void clipRect(float x, float y, float width, float height) {
        y = this.transformY(y);
        this.out.println(String.valueOf(x) + " " + y + " moveto");
        this.out.println(String.valueOf(x + width) + " " + y + " lineto");
        this.out.println(String.valueOf(x + width) + " " + (y - height) + " lineto");
        this.out.println(String.valueOf(x) + " " + (y - height) + " lineto");
        this.out.println(String.valueOf(x) + " " + y + " lineto");
        this.out.println("closepath eoclip newpath");
    }

    public void clipSave() {
        this.out.println("clipsave");
    }

    public void clipRestore() {
        this.out.println("cliprestore");
    }

    public void drawImage(InputStream imageStream, float x, float y, float width, float height) throws Exception {
        BufferedImage image = ImageIO.read(imageStream);
        this.drawImage(image, x, y, width, height, null);
    }

    public void drawImage(Image image, float x, float y, float width, float height, Color bgcolor) throws Exception {
        if (image == null) {
            throw new IllegalArgumentException("null image.");
        }
        ArrayImageSource imageSource = this.getImageSource(image);
        this.drawImage(imageSource, x, y, width, height, bgcolor);
    }

    private ArrayImageSource getImageSource(Image image) throws IOException {
        ImageIcon imageIcon = new ImageIcon(image);
        int w = imageIcon.getIconWidth();
        int h = imageIcon.getIconHeight();
        int[] pixels = new int[w * h];
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
            pg.grabPixels();
            if ((pg.getStatus() & 0x80) != 0) {
                throw new IOException("failed to load image contents");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("image load interrupted");
        }
        ArrayImageSource imageSource = new ArrayImageSource(w, h, pixels);
        return imageSource;
    }

    private void drawImage(ImageSource imageSource, float x, float y, float width, float height, Color bgcolor) {
        int originalWidth = imageSource.getWidth();
        int originalHeight = imageSource.getHeight();
        y = this.transformY(y);
        this.gSave();
        this.out.println("% build a temporary dictionary");
        this.out.println("20 dict begin");
        this.out.print("/pix ");
        this.out.print(originalWidth * 3);
        this.out.println(" string def");
        this.out.println("% define space for color conversions");
        this.out.print("/grays ");
        this.out.print(originalWidth);
        this.out.println(" string def  % space for gray scale line");
        this.out.println("% lower left corner");
        this.out.print(x);
        this.out.print(" ");
        this.out.print(y);
        this.out.println(" translate");
        if (height == 0.0f || width == 0.0f) {
            height = originalHeight;
            width = originalWidth;
        }
        this.out.println("% size of image");
        this.out.print(width);
        this.out.print(" ");
        this.out.print(height);
        this.out.println(" scale");
        this.out.print(originalWidth);
        this.out.print(" ");
        this.out.print(originalHeight);
        this.out.println(" 8");
        this.out.print("[");
        this.out.print(originalWidth);
        this.out.print(" 0 0 -");
        this.out.print(originalHeight);
        this.out.print(" 0 ");
        this.out.print(0);
        this.out.println("]");
        this.out.println("{currentfile pix readhexstring pop}");
        this.out.println("false 3 colorimage");
        this.out.println("");
        byte[] sb = new byte[originalHeight * originalWidth * 6];
        int offset = 0;
        int i = 0;
        while (i < originalHeight) {
            if (bgcolor == null) {
                int j = 0;
                while (j < originalWidth) {
                    int pixel = imageSource.getRGB(j, i);
                    int red = (pixel & 0xFF0000) >> 16;
                    int green = (pixel & 0xFF00) >> 8;
                    int blue = pixel & 0xFF;
                    offset = this.toBytes(offset, sb, red);
                    offset = this.toBytes(offset, sb, green);
                    offset = this.toBytes(offset, sb, blue);
                    ++j;
                }
            }
            ++i;
        }
        this.out.println(new String(sb));
        this.out.println("");
        this.out.println("end");
        this.gRestore();
    }

    private int toBytes(int offset, byte[] buffer, int value) {
        buffer[offset++] = hd[(value & 0xF0) >> 4];
        buffer[offset++] = hd[value & 0xF];
        return offset;
    }

    protected void drawRect(float x, float y, float width, float height, boolean fill) {
        this.drawRawRect(x, y, width, height);
        if (fill) {
            this.out.println("fill");
        } else {
            this.out.println("stroke");
        }
    }

    private void drawRawRect(float x, float y, float width, float height) {
        y = this.transformY(y) - height;
        this.out.print(x);
        this.out.print(" ");
        this.out.print(y);
        this.out.println(" moveto ");
        this.out.print(width);
        this.out.print(" ");
        this.out.print(0);
        this.out.println(" rlineto ");
        this.out.print(0);
        this.out.print(" ");
        this.out.print(height);
        this.out.println(" rlineto ");
        this.out.print(-width);
        this.out.print(" ");
        this.out.print(0);
        this.out.println(" rlineto ");
        this.out.print(0);
        this.out.print(" ");
        this.out.print(-height);
        this.out.println(" rlineto ");
    }

    /*
     * Exception decompiling
     */
    public void drawBackgroundImage(String imageURI, float x, float y, float width, float height, float positionX, float positionY, String repeat) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 275->279)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void drawLine(float startX, float startY, float endX, float endY) {
        startY = this.transformY(startY);
        endY = this.transformY(endY);
        this.out.print(startX);
        this.out.print(" ");
        this.out.print(startY);
        this.out.print(" moveto ");
        this.out.print(endX);
        this.out.print(" ");
        this.out.print(endY);
        this.out.println(" lineto stroke");
    }

    public void drawLine(float startX, float startY, float endX, float endY, float width, Color color, String lineStyle) {
        if (color == null || 0.0f == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        if ("double".equalsIgnoreCase(lineStyle)) {
            return;
        }
        this.gSave();
        if (color != null) {
            this.setColor(color);
        }
        this.setLineWidth(width);
        if ("dashed".equalsIgnoreCase(lineStyle)) {
            this.setDashLine(width);
        } else if ("dotted".equalsIgnoreCase(lineStyle)) {
            this.setDottedLine(width);
        }
        this.drawLine(startX, startY, endX, endY);
        this.gRestore();
    }

    private void gRestore() {
        this.out.println("grestore");
    }

    private void gSave() {
        this.out.println("gsave");
    }

    private void setLineWidth(float lineWidth) {
        this.out.print(lineWidth);
        this.out.println(" setlinewidth");
    }

    private void setDashLine(float lineWidth) {
        int width = (int)Math.ceil(lineWidth);
        this.out.println("[" + 3 * width + " " + 2 * width + "] 0 setdash");
    }

    private void setDottedLine(float lineWidth) {
        int width = (int)Math.ceil(lineWidth);
        this.out.println("[" + width + "] 0 setdash");
    }

    public void drawRect(int x, int y, int width, int height) {
        this.out.println("%drawRect");
        this.drawRect(x, y, width, height, false);
    }

    public void drawString(String str, float x, float y, FontInfo fontInfo, float letterSpacing, float wordSpacing, Color color, boolean linethrough, boolean overline, boolean underline, CSSValue align) {
        y = this.transformY(y);
        this.gSave();
        String text = str;
        if (fontInfo != null) {
            BaseFont baseFont = fontInfo.getBaseFont();
            String fontName = this.getFontName(baseFont);
            text = this.applyFont(fontName, fontInfo.getFontStyle(), fontInfo.getFontSize(), text);
        }
        color = color == null ? Color.black : color;
        this.setColor(color);
        this.out.print(x);
        this.out.print(" ");
        this.out.print(y);
        this.out.print(" moveto ");
        this.out.print(overline ? " 1 " : " 0 ");
        this.out.print(linethrough ? " 1 " : " 0 ");
        this.out.print(underline ? " 1 " : " 0 ");
        this.out.print(wordSpacing);
        this.out.print(" 0 8#040 ");
        this.out.print(letterSpacing);
        this.out.print(" 0 ");
        this.out.print(text);
        this.out.println("mshow stroke");
        this.gRestore();
    }

    private String getFontName(BaseFont baseFont) {
        String[][] familyFontNames = baseFont.getFamilyFontName();
        String[] family = familyFontNames[0];
        String fontName = family[family.length - 1];
        return fontName;
    }

    protected void emitProlog(String title) {
        this.out.println("%!PS-Adobe-3.0");
        if (title != null) {
            this.out.println("%%Title: " + title);
        }
        this.out.println("% (C)2006 Actuate Inc.");
        this.setFont(this.font);
    }

    public void fillRect(float x, float y, float width, float height, Color color) {
        this.gSave();
        this.setColor(color);
        this.out.println("%fillRect");
        this.drawRect(x, y, width, height, true);
        this.gRestore();
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        this.out.println("%dispose");
    }

    public Color getColor() {
        return this.clr;
    }

    public Font getFont() {
        return this.font;
    }

    public void scale(float sx, float sy) {
        this.out.print(sx);
        this.out.print(" ");
        this.out.print(sy);
        this.out.println(" scale");
    }

    public void setColor(Color c) {
        if (c == null) {
            return;
        }
        this.out.print((double)c.getRed() / 255.0);
        this.out.print(" ");
        this.out.print((double)c.getGreen() / 255.0);
        this.out.print(" ");
        this.out.print((double)c.getBlue() / 255.0);
        this.out.println(" setrgbcolor");
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
            String javaName = this.font.getFamilyname();
            int javaStyle = this.font.style();
            this.setFont(javaName, javaStyle);
        }
    }

    private void setFont(String fontName, int fontStyle, float fontSize) {
        String psName;
        if (fontName.equals(SYMBOL)) {
            psName = SYMBOL;
        } else if (fontName.equals(TIMES)) {
            psName = "Times-";
            switch (fontStyle) {
                case 0: {
                    psName = String.valueOf(psName) + "Roman";
                    break;
                }
                case 1: {
                    psName = String.valueOf(psName) + "Bold";
                    break;
                }
                case 2: {
                    psName = String.valueOf(psName) + "Italic";
                    break;
                }
                case 3: {
                    psName = String.valueOf(psName) + "BoldItalic";
                }
            }
        } else if (fontName.equals(HELVETICA) || fontName.equals(COURIER)) {
            psName = fontName;
            switch (fontStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    psName = String.valueOf(psName) + "-Bold";
                    break;
                }
                case 2: {
                    psName = String.valueOf(psName) + "-Oblique";
                    break;
                }
                case 3: {
                    psName = String.valueOf(psName) + "BoldOblique";
                }
            }
        } else {
            psName = COURIER;
        }
        this.setFont(psName, fontSize);
    }

    private void setFont(String psName, float size) {
        this.out.println("/" + psName + " findfont");
        this.out.print(size);
        this.out.println(" scalefont setfont");
    }

    private String applyFont(String fontName, int fontStyle, float fontSize, String text) {
        if (PostscriptWriter.isIntrinsicFont(fontName)) {
            return this.applyIntrinsicFont(fontName, fontStyle, fontSize, text);
        }
        try {
            String searchName = String.valueOf(fontName) + this.getFontSuffix(fontStyle);
            String fontPath = this.getFontPath(searchName);
            if (fontPath == null) {
                return this.applyIntrinsicFont(fontName, fontStyle, fontSize, text);
            }
            ITrueTypeWriter trueTypeWriter = this.getTrueTypeFontWriter(fontPath);
            String displayName = searchName.replace(' ', '_');
            trueTypeWriter.useDisplayName(displayName);
            trueTypeWriter.ensureGlyphsAvailable(text);
            this.setFont(displayName, fontSize);
            return this.toHexString(text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String applyIntrinsicFont(String fontName, int fontStyle, float fontSize, String text) {
        this.setFont(fontName, fontStyle, fontSize);
        return "(" + text + ")";
    }

    private String toHexString(String text) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        int i = 0;
        while (i < text.length()) {
            buffer.append(this.toHexString(text.charAt(i)));
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    private String toHexString(char c) {
        String[] padding = new String[]{"0", "00", "00"};
        String result = Integer.toHexString(c);
        if (result.length() < 4) {
            result = String.valueOf(padding[3 - result.length()]) + result;
        }
        return result;
    }

    private ITrueTypeWriter getTrueTypeFontWriter(String fontPath) throws DocumentException, IOException {
        File file = new File(fontPath);
        ITrueTypeWriter trueTypeWriter = (ITrueTypeWriter)this.trueTypeFontWriters.get(file);
        if (trueTypeWriter != null) {
            return trueTypeWriter;
        }
        TrueTypeFont ttFont = TrueTypeFont.getInstance(fontPath);
        trueTypeWriter = ttFont.getTrueTypeWriter(this.out);
        trueTypeWriter.initialize();
        this.trueTypeFontWriters.put(file, trueTypeWriter);
        return trueTypeWriter;
    }

    private String getFontSuffix(int fontStyle) {
        switch (fontStyle) {
            case 1: {
                return " Bold";
            }
            case 2: {
                return " Italic";
            }
            case 3: {
                return " BoldItalic";
            }
        }
        return "";
    }

    private String getFontPath(String fontName) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.lowagie.text.FontFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object fontImpl = this.getField(clazz, "fontImp", null);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.lowagie.text.FontFactoryImp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Properties trueTypeFonts = (Properties)this.getField(clazz2, "trueTypeFonts", fontImpl);
            String fontPath = trueTypeFonts.getProperty(fontName.toLowerCase());
            return fontPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getField(Class fontFactoryClass, String fieldName, Object instaces) throws NoSuchFieldException, IllegalAccessException {
        Field fldTrueTypeFonts = fontFactoryClass.getDeclaredField(fieldName);
        fldTrueTypeFonts.setAccessible(true);
        Object field = fldTrueTypeFonts.get(instaces);
        return field;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    protected float transformY(float y) {
        return (float)this.pageHeight - y;
    }

    public void translate(int x, int y) {
        this.out.print(x);
        this.out.print(" ");
        this.out.print(y);
        this.out.println(" translate");
    }

    public void startRenderer() throws IOException {
        FileUtil.load("org/eclipse/birt/report/engine/emitter/postscript/header.ps", this.out);
    }

    public void fillPage(Color color) {
        if (color == null) {
            return;
        }
        this.gSave();
        this.setColor(color);
        this.out.println("clippath fill");
        this.gRestore();
    }

    public void startPage(float pageWidth, float pageHeight) {
        this.pageHeight = Math.round(pageHeight);
        this.pageWidth = Math.round(pageWidth);
        this.out.println("%%Page: " + this.pageIndex + " " + this.pageIndex);
        this.out.println("%%PageBoundingBox: 0 0 " + this.pageWidth + " " + this.pageHeight);
        this.out.println("%%BeginPage");
        ++this.pageIndex;
    }

    public void endPage() {
        this.out.println("showpage");
        this.out.println("%%PageTrailer");
        this.out.println("%%EndPage");
    }

    public void stopRenderer() throws IOException {
        this.out.println("%%Trailer");
        this.out.println("%%Pages: " + (this.pageIndex - 1));
        this.out.println("%%EOF");
        this.out.flush();
    }

    public class ArrayImageSource
    extends ImageSource {
        private int[] imageSource;

        public ArrayImageSource(int width, int height, int[] imageSource) {
            super(width, height);
            this.imageSource = imageSource;
        }

        public int getRGB(int x, int y) {
            return this.imageSource[y * this.width + x];
        }
    }

    public abstract class ImageSource {
        protected int height;
        protected int width;

        public ImageSource(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public abstract int getRGB(int var1, int var2);
    }
}

