/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.management.IntrospectionException;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.routing.OSGiResourceRouter;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.OperationalStatus;
import org.apache.muse.ws.dm.muws.Participant;
import org.apache.muse.ws.dm.muws.RelationshipType;
import org.apache.muse.ws.dm.muws.Relationships;
import org.apache.muse.ws.dm.muws.events.Component;
import org.apache.muse.ws.dm.muws.events.ComponentAddress;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.dm.muws.events.Situation;
import org.apache.muse.ws.dm.muws.events.WefFactory;
import org.apache.muse.ws.dm.muws.events.impl.SimpleWefFactory;
import org.apache.muse.ws.dm.muws.impl.SimpleParticipant;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationshipType;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.properties.get.GetCapability;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.DestroyManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEvent;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEventSituation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEventSource;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedPropertyGetter;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedPropertySetter;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.dc.mgmt.api.EventSituation;
import org.eclipse.cosmos.dc.mgmt.api.EventSource;
import org.eclipse.cosmos.dc.mgmt.binding.Binding;
import org.eclipse.cosmos.dc.mgmt.binding.BindingExtension;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.common.StatusChangeListener;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBinding;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBindingUtil;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMNotificationInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMRelationInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.util.SchemaHelper;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.util.WSDMHelperRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDMBindingFactory
implements Binding,
ServiceFactory,
WSDMHelperRegistry {
    private static WSDMBindingFactory _default = new WSDMBindingFactory();
    private static WefFactory wefFactory = new SimpleWefFactory();
    public static final WSDMAttributeInfo[] EMPTY_ATTR_INFO_ARRAY = new WSDMAttributeInfo[0];
    public static final WSDMOperationInfo[] EMPTY_OPER_INFO_ARRAY = new WSDMOperationInfo[0];
    public static final WSDMRelationInfo[] EMPTY_RELATION_INFO_ARRAY = new WSDMRelationInfo[0];
    public static final WSDMNotificationInfo[] EMPTY_NOTIFICATION_INFO_ARRAY = new WSDMNotificationInfo[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static WeakHashMap<Object, WsResource> boundObjectMap = new WeakHashMap();
    private static WeakHashMap<Class, WSDMInfo> boundClassMap = new WeakHashMap();
    private static HashMap<String, EndpointReference> advertisementMap = new HashMap();
    private ResourceRouter _router;
    private ResourceManager _resourceManager;
    private ResourceManagementProvider _wsdmProvider;
    private ContributionManager _manager;
    private static Bundle _bundle;
    private StatusChangeListener.STATUS status = StatusChangeListener.STATUS.PARTIALLY_AVAILABLE;

    public static void setBundle(Bundle bundle) {
        _bundle = bundle;
    }

    public static WSDMBindingFactory getDefault() {
        return _default;
    }

    public void setWSDMProvider(ResourceManagementProvider wsdmProvider) {
        WSDMBindingFactory._default._wsdmProvider = this._wsdmProvider;
        this._wsdmProvider = wsdmProvider;
    }

    public void setResourceRouter(ResourceRouter router) {
        this._router = router;
        WSDMBindingFactory.loadAdvertisementTargets();
    }

    public void setResourceManager(ResourceManager manager) {
        this._resourceManager = manager;
    }

    public void setContributionManager(ContributionManager manager) {
        WSDMBindingFactory._default._manager = manager;
    }

    public static void register(Object resource) throws Exception {
        WSDMInfo wsdmInfo;
        Class resourceClass = resource.getClass();
        if (Proxy.isProxyClass(resourceClass) && ManagementProxy.class.isAssignableFrom(resourceClass)) {
            resourceClass = ((ManagementProxy)resource).getProxiedClass();
        }
        if ((wsdmInfo = boundClassMap.get(resourceClass)) == null) {
            ManagedEvent event_annotation;
            Field[] fields;
            ManagedResource resource_annotation = (ManagedResource)WSDMBindingUtil.getAnnotation(ManagedResource.class, resourceClass);
            if (resource_annotation == null) {
                throw new Exception("Invalid Resource - does not contain ManagedResource annotation: " + resource.getClass().getName());
            }
            ArrayList<WSDMAttributeInfo> attrInfoList = new ArrayList<WSDMAttributeInfo>();
            ArrayList<WSDMOperationInfo> operInfoList = new ArrayList<WSDMOperationInfo>();
            ArrayList<WSDMNotificationInfo> notificationInfoList = new ArrayList<WSDMNotificationInfo>();
            ArrayList<WSDMRelationInfo> relationInfoList = new ArrayList<WSDMRelationInfo>();
            HashMap<String, Field> map = new HashMap<String, Field>();
            Class workingClass = resourceClass;
            while (workingClass != Object.class) {
                WSDMBindingUtil.extractFields(workingClass, map);
                workingClass = workingClass.getSuperclass();
            }
            Field[] fieldArray = fields = map.values().toArray(EMPTY_FIELD_ARRAY);
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field field = fieldArray[n];
                ManagedRelation relation_annotation = field.getAnnotation(ManagedRelation.class);
                ManagedProperty property_annotation = field.getAnnotation(ManagedProperty.class);
                event_annotation = field.getAnnotation(ManagedEvent.class);
                ManagedFrameworkAutowire autowire = field.getAnnotation(ManagedFrameworkAutowire.class);
                if (relation_annotation != null) {
                    relationInfoList.add(WSDMBindingFactory.processRelation(relation_annotation, field));
                } else if (property_annotation != null) {
                    attrInfoList.add(WSDMBindingFactory.processProperty(property_annotation, field, resourceClass));
                } else if (autowire != null) {
                    WSDMBindingFactory.processAutowire(autowire, field, resourceClass, resource);
                }
                if (event_annotation != null) {
                    WSDMNotificationInfo notificationInfo = WSDMBindingFactory.processNotification(event_annotation, field, resourceClass);
                    notificationInfo.setSpecCapabilityURI("http://docs.oasis-open.org/wsrf/r-2");
                    notificationInfoList.add(notificationInfo);
                }
                ++n;
            }
            ManagedEvent methods = resourceClass.getMethods();
            HashMap<QName, ManagedEvent> propsGetterMap = new HashMap<QName, ManagedEvent>();
            HashMap<QName, ManagedEvent> propsSetterMap = new HashMap<QName, ManagedEvent>();
            event_annotation = methods;
            int n3 = 0;
            int property_annotation = ((Method[])event_annotation).length;
            while (n3 < property_annotation) {
                QName propName;
                String namespace;
                ManagedEvent method = event_annotation[n3];
                ManagedOperation operation_annotation = (ManagedOperation)WSDMBindingUtil.getMethodAnnotation(ManagedOperation.class, (Method)method);
                CreateManagedRelation create_annotation = (CreateManagedRelation)WSDMBindingUtil.getMethodAnnotation(CreateManagedRelation.class, (Method)method);
                DestroyManagedRelation destroy_annotation = (DestroyManagedRelation)WSDMBindingUtil.getMethodAnnotation(DestroyManagedRelation.class, (Method)method);
                ManagedEvent event_annotation2 = (ManagedEvent)WSDMBindingUtil.getMethodAnnotation(ManagedEvent.class, (Method)method);
                ManagedEventConsumer event_consumer = (ManagedEventConsumer)WSDMBindingUtil.getMethodAnnotation(ManagedEventConsumer.class, (Method)method);
                ManagedPropertyGetter prop_getter_annotation = (ManagedPropertyGetter)WSDMBindingUtil.getMethodAnnotation(ManagedPropertyGetter.class, (Method)method);
                ManagedPropertySetter prop_setter_annotation = (ManagedPropertySetter)WSDMBindingUtil.getMethodAnnotation(ManagedPropertySetter.class, (Method)method);
                ManagedResourceCapability capability_annotation = (ManagedResourceCapability)WSDMBindingUtil.getMethodAnnotation(ManagedResourceCapability.class, (Method)method);
                String capabilityURI = null;
                if (operation_annotation != null) {
                    operInfoList.add(WSDMBindingFactory.processOperation(operation_annotation, (Method)method));
                } else if (create_annotation != null) {
                    capabilityURI = "http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships";
                    relationInfoList.add(WSDMBindingFactory.processRelation(create_annotation, (Method)method));
                } else if (destroy_annotation != null) {
                    capabilityURI = "http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships";
                    relationInfoList.add(WSDMBindingFactory.processRelation(destroy_annotation, (Method)method));
                } else if (event_consumer != null) {
                    operInfoList.add(WSDMBindingFactory.processOperation(event_consumer, (Method)method));
                } else if (prop_getter_annotation != null) {
                    namespace = "";
                    if (capability_annotation != null) {
                        namespace = capability_annotation.namespace();
                    }
                    propName = new QName(namespace, prop_getter_annotation.property());
                    propsGetterMap.put(propName, method);
                } else if (prop_setter_annotation != null) {
                    namespace = "";
                    if (capability_annotation != null) {
                        namespace = capability_annotation.namespace();
                    }
                    propName = new QName(namespace, prop_setter_annotation.property());
                    propsSetterMap.put(propName, method);
                }
                if (event_annotation2 != null) {
                    WSDMNotificationInfo notificationInfo = WSDMBindingFactory.processNotification(event_annotation2, (Method)method, resourceClass);
                    if (capabilityURI != null) {
                        notificationInfo.setSpecCapabilityURI(capabilityURI);
                    }
                    notificationInfoList.add(notificationInfo);
                }
                ++n3;
            }
            if (!propsGetterMap.isEmpty()) {
                for (QName propName : propsGetterMap.keySet()) {
                    Method getter = (Method)propsGetterMap.get(propName);
                    Method setter = (Method)propsSetterMap.remove(propName);
                    attrInfoList.add(WSDMBindingFactory.processProperty(propName, getter, setter));
                }
            }
            wsdmInfo = WSDMBindingFactory.processResource(resource_annotation, resourceClass, attrInfoList, operInfoList, relationInfoList, notificationInfoList);
            boundClassMap.put(resourceClass, wsdmInfo);
            WSDMBindingFactory._default._wsdmProvider.deployManagementService(_bundle, "cosmos", wsdmInfo.getResourceName(), "");
            OSGiResourceRouter.getDefault().setDelegateBundle(_bundle, "cosmos", wsdmInfo.getResourceName());
            wsdmInfo.compileCapabilties(WSDMBindingFactory._default._router.getEnvironment());
        }
        WSDMBinding binding = new WSDMBinding(wsdmInfo, resource);
        binding.setLog(WSDMBindingFactory._default._router.getLog());
        binding.setEnvironment(WSDMBindingFactory._default._router.getEnvironment());
        binding.setResourceManager(WSDMBindingFactory._default._resourceManager);
        binding.setContextPath("/" + wsdmInfo.getResourceName());
        binding.setWsdlPath("");
        binding.setWsdlPortType(new QName(wsdmInfo.getTargetNamespace(), String.valueOf(wsdmInfo.getResourceName()) + "PortType"));
        binding.initialize();
        WSDMBindingFactory._default._resourceManager.addResource(binding.getEndpointReference(), (Resource)binding);
        boundObjectMap.put(resource, binding);
        if (resource instanceof ManagementProxy) {
            boundObjectMap.put(((ManagementProxy)resource).getProxiedObject(), binding);
        }
        System.out.println("Bound" + (Object)((Object)binding));
    }

    private static void processAutowire(ManagedFrameworkAutowire autowire, Field field, Class<? extends Object> resourceClass, Object resource) {
        String name = field.getName();
        name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        String setterName = "set" + name;
        Class[] setterParm = new Class[]{field.getType()};
        Method setterMethod = null;
        Object autowireTarget = WSDMBindingFactory._default._manager.getAutowireTarget(autowire.name());
        if (autowireTarget != null && field.getType().isAssignableFrom(autowireTarget.getClass())) {
            try {
                setterMethod = resourceClass.getMethod(setterName, setterParm);
                if (!setterMethod.getReturnType().equals(Void.TYPE)) {
                    setterMethod = null;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                if (setterMethod != null) {
                    Object target = resource;
                    if (resource instanceof ManagementProxy) {
                        target = ((ManagementProxy)resource).getProxiedObject();
                    }
                    setterMethod.invoke(target, autowireTarget);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected static WSDMInfo processResource(ManagedResource resource, Class resourceClass, ArrayList<WSDMAttributeInfo> attrInfo, ArrayList<WSDMOperationInfo> operInfo, ArrayList<WSDMRelationInfo> relationInfo, ArrayList<WSDMNotificationInfo> notificationInfo) {
        ArrayList<String> namespaceList = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(resourceClass.getName(), ".");
        while (toker.hasMoreTokens()) {
            namespaceList.add(toker.nextToken());
        }
        String[] names = namespaceList.toArray(new String[0]);
        StringBuffer namespaceBuffer = new StringBuffer("http:/");
        if (names.length < 2) {
            namespaceBuffer.append("/default");
        } else {
            int i = names.length - 2;
            while (i >= 0) {
                namespaceBuffer.append("/" + names[i]);
                --i;
            }
        }
        return new WSDMInfo(resourceClass.getName(), resource.description(), namespaceBuffer.toString(), attrInfo.toArray(EMPTY_ATTR_INFO_ARRAY), null, operInfo.toArray(EMPTY_OPER_INFO_ARRAY), relationInfo.toArray(EMPTY_RELATION_INFO_ARRAY), notificationInfo.toArray(EMPTY_NOTIFICATION_INFO_ARRAY), resourceClass.getAnnotations());
    }

    protected static WSDMRelationInfo processRelation(ManagedRelation relation, Field field) {
        return new WSDMRelationInfo(relation, field);
    }

    protected static WSDMRelationInfo processRelation(CreateManagedRelation relation, Method method) {
        return new WSDMRelationInfo(method.getAnnotations(), method, true);
    }

    protected static WSDMRelationInfo processRelation(DestroyManagedRelation relation, Method method) {
        return new WSDMRelationInfo(method.getAnnotations(), method, false);
    }

    protected static WSDMAttributeInfo processProperty(ManagedProperty property, Field field, Class resourceClass) {
        String description = property.description();
        String name = field.getName();
        name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        String getterName = "get" + name;
        String setterName = "set" + name;
        Class[] setterParm = new Class[]{field.getType()};
        Class[] getterParm = new Class[]{};
        Method getterMethod = null;
        Method setterMethod = null;
        try {
            getterMethod = resourceClass.getMethod(getterName, getterParm);
            if (!getterMethod.getReturnType().equals(field.getType())) {
                getterMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            setterMethod = resourceClass.getMethod(setterName, setterParm);
            if (!setterMethod.getReturnType().equals(Void.TYPE)) {
                setterMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            return new WSDMAttributeInfo(field.getName(), property.namespace(), description, getterMethod, setterMethod, field.getAnnotations());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static WSDMAttributeInfo processProperty(QName propName, Method getterMethod, Method setterMethod) {
        String description = "";
        Class<?> retType = getterMethod.getReturnType();
        if (setterMethod != null) {
            Class<?>[] parmTypes = setterMethod.getParameterTypes();
            if (parmTypes.length != 1) {
                return null;
            }
            if (!parmTypes[0].equals(retType)) {
                return null;
            }
        }
        try {
            return new WSDMAttributeInfo(propName.getLocalPart(), propName.getNamespaceURI(), description, getterMethod, setterMethod, WSDMBindingUtil.getAnnotations(getterMethod));
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static WSDMNotificationInfo processNotification(ManagedEvent event, Field field, Class resourceClass) {
        return new WSDMNotificationInfo(new String[0], event.topic(), event.description(), event.namespace(), null);
    }

    protected static WSDMNotificationInfo processNotification(ManagedEvent event, Method method, Class resourceClass) {
        String namespace = event.namespace();
        if ("".equals(event.namespace())) {
            Class<?>[] interfazes;
            Class<?>[] classArray = interfazes = resourceClass.getInterfaces();
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class<?> interfaze = classArray[n];
                ManagedResourceCapability cap = (ManagedResourceCapability)WSDMBindingUtil.getAnnotationFromInterface(ManagedResourceCapability.class, interfaze);
                if (cap != null) {
                    Method[] methods;
                    Method[] methodArray = methods = interfaze.getMethods();
                    int n3 = 0;
                    int n4 = methodArray.length;
                    while (n3 < n4) {
                        Method imethod = methodArray[n3];
                        if (WSDMBindingUtil.equivalentMethod(method, imethod)) {
                            namespace = cap.namespace();
                            break;
                        }
                        ++n3;
                    }
                    if (!"".equals(namespace)) break;
                }
                ++n;
            }
        }
        return new WSDMNotificationInfo(new String[0], event.topic(), event.description(), namespace, null);
    }

    protected static WSDMOperationInfo processOperation(ManagedOperation operation, Method method) {
        return new WSDMOperationInfo(operation.description(), method, WSDMBindingUtil.getAnnotations(method));
    }

    protected static WSDMOperationInfo processOperation(ManagedEventConsumer consumer, Method method) {
        return new WSDMOperationInfo("event consumer", method, WSDMBindingUtil.getAnnotations(method));
    }

    public void addBindingExtension(Object key, BindingExtension extension) {
        System.out.println("adding binding extension");
    }

    public void bindContribution(Object contribution) {
        try {
            WSDMBindingFactory.register(contribution);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unbindContribution(Object contribution) {
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return WSDMBindingFactory.getDefault();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public void addRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
        System.out.println("Adding relationship");
        WsResource resource = boundObjectMap.get(object);
        if (resource == null || !(resource instanceof WSDMBinding)) {
            return;
        }
        try {
            Relationships relCap = (Relationships)resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
            if (relCap == null) {
                return;
            }
            WsResource targetResource = boundObjectMap.get(args[0]);
            if (targetResource == null) {
                System.out.println("cannot locate relationship target");
                return;
            }
            String name = "contains";
            String relationType = "container";
            String[] role = new String[]{"container", "contained"};
            Annotation[] annotationArray = annotations;
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                ManagedRelation managedRelation;
                Annotation annotation = annotationArray[n];
                if (annotation instanceof ManagedRelation) {
                    managedRelation = (ManagedRelation)annotation;
                    if (!"".equals(managedRelation.name())) {
                        name = managedRelation.name();
                    }
                    role = managedRelation.roles();
                    relationType = managedRelation.type();
                } else if (annotation instanceof CreateManagedRelation) {
                    managedRelation = (CreateManagedRelation)annotation;
                    if (!"".equals(managedRelation.name())) {
                        name = managedRelation.name();
                    }
                    role = managedRelation.roles();
                    relationType = managedRelation.type();
                }
                ++n;
            }
            Participant[] participants = new Participant[2];
            QName[] typeNames = new QName[]{new QName(((WSDMBinding)resource).getNamespace(), relationType, "tns")};
            SimpleRelationshipType type = new SimpleRelationshipType(typeNames);
            participants[0] = new SimpleParticipant(resource, role[0]);
            participants[1] = new SimpleParticipant(targetResource, role[1]);
            relCap.addRelationship(name, (RelationshipType)type, participants);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void raiseEvent(Object object, Method method, Object[] args, Object ret, Annotation[] annotations) {
        WsResource binding = boundObjectMap.get(object);
        if (binding == null || !(binding instanceof WSDMBinding)) {
            return;
        }
        Capability wsnCapability = binding.getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        if (wsnCapability != null && wsnCapability instanceof NotificationProducer) {
            ManagedEvent event = null;
            Annotation[] annotationArray = annotations;
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation annotation = annotationArray[n];
                if (annotation instanceof ManagedEvent) {
                    event = (ManagedEvent)annotation;
                    break;
                }
                ++n;
            }
            String namespace = event.namespace();
            String format = event.format();
            if ("".equals(namespace)) {
                Annotation[] annotationArray2 = annotations;
                int n3 = 0;
                int n4 = annotationArray2.length;
                while (n3 < n4) {
                    Annotation annotation = annotationArray2[n3];
                    if (annotation instanceof ManagedResourceCapability) {
                        namespace = ((ManagedResourceCapability)annotation).namespace();
                        break;
                    }
                    ++n3;
                }
                if ("".equals(namespace)) {
                    namespace = ((WSDMBinding)binding).getNamespace();
                }
            }
            QName topicName = new QName(namespace, event.topic(), "dyn");
            try {
                Element payload = XmlUtils.createElement((QName)topicName, (Object)"value");
                if (ret != null) {
                    if (ret instanceof Element) {
                        payload = (Element)ret;
                    } else {
                        Serializer ser = SerializerRegistry.getInstance().getSerializer(ret.getClass());
                        if (ser != null) {
                            payload = ser.toXML(ret, topicName);
                        }
                    }
                }
                if ("wef".equals(format)) {
                    ManagementEvent wefEvent = wefFactory.createEvent();
                    wefEvent.setEventID(event.topic());
                    if (payload != null) {
                        wefEvent.addExtendedElement(payload);
                    }
                    Component reporter = wefFactory.createComponent(binding.getEndpointReference().toXML());
                    reporter.setName(new QName(((WSDMBinding)binding).getNamespace(), "reporter", "dyn"));
                    wefEvent.setReporter(reporter);
                    Date currentTime = new Date(System.currentTimeMillis());
                    wefEvent.setReportTime(currentTime);
                    Annotation[][] parmAnnotationList = method.getParameterAnnotations();
                    int currentParmIndex = 0;
                    EventSource sourceHelper = null;
                    EventSituation situationHelper = null;
                    Annotation[][] annotationArray3 = parmAnnotationList;
                    int n5 = 0;
                    int n6 = annotationArray3.length;
                    while (n5 < n6) {
                        Annotation[] parmAnnotations = annotationArray3[n5];
                        if (parmAnnotations.length > 0) {
                            Annotation[] annotationArray4 = parmAnnotations;
                            int n7 = 0;
                            int n8 = annotationArray4.length;
                            while (n7 < n8) {
                                Object arg;
                                Annotation annotation = annotationArray4[n7];
                                if (annotation instanceof ManagedEventSource && (arg = args[currentParmIndex]) instanceof EventSource) {
                                    sourceHelper = (EventSource)arg;
                                }
                                if (annotation instanceof ManagedEventSituation && (arg = args[currentParmIndex]) instanceof EventSituation) {
                                    situationHelper = (EventSituation)arg;
                                }
                                ++n7;
                            }
                        }
                        ++currentParmIndex;
                        ++n5;
                    }
                    Component source = wefFactory.createComponent();
                    if (sourceHelper != null) {
                        source.setName(sourceHelper.getName());
                        Object managedSource = sourceHelper.getManagedObject();
                        if (managedSource != null) {
                            WsResource sourceBinding = boundObjectMap.get(object);
                            ComponentAddress sourceAddress = null;
                            sourceAddress = sourceBinding != null ? wefFactory.createComponentAddress(sourceBinding.getEndpointReference().toXML()) : wefFactory.createComponentAddress();
                            source.setAddress(sourceAddress);
                            Properties props = sourceHelper.getSourceProperties();
                            for (Object key : props.keySet()) {
                                if (!(key instanceof QName)) continue;
                                source.addExtendedElement((QName)key, props.get(key));
                            }
                        }
                    } else {
                        source.setName(new QName("bogus", "source"));
                        ComponentAddress sourceAddress = wefFactory.createComponentAddress();
                        source.setAddress(sourceAddress);
                    }
                    wefEvent.setSource(source);
                    Situation situation = wefFactory.createSituation();
                    if (situationHelper != null) {
                        situation.setCategoryType(situationHelper.getCategoryType());
                        situation.setMessage(situationHelper.getMessage());
                        situation.setSeverity(situationHelper.getSeverity());
                        situation.setPriority(situationHelper.getPriority());
                        situation.setSuccessDisposition(situationHelper.getSuccessDisposition());
                    } else {
                        situation.setCategoryType(new QName("bugus", "category"));
                        situation.setMessage("Hello there");
                        situation.setPriority((short)10);
                        situation.setSeverity((short)1);
                        situation.setSituationTime(currentTime);
                    }
                    wefEvent.setSituation(situation);
                    payload = wefEvent.toXML();
                }
                ((NotificationProducer)wsnCapability).publish(topicName, payload);
            }
            catch (SoapFault e) {
                e.printStackTrace();
            }
        }
    }

    public void removeRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
        System.out.println("Removing relationship");
        WsResource resource = boundObjectMap.get(object);
        if (resource == null || !(resource instanceof WSDMBinding)) {
            return;
        }
        try {
            WsResource[] relationships;
            Relationships relCap = (Relationships)resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
            if (relCap == null) {
                return;
            }
            WsResource targetResource = boundObjectMap.get(args[0]);
            if (targetResource == null) {
                System.out.println("cannot locate relationship target");
                return;
            }
            String name = "contains";
            String relationType = "container";
            String[] role = new String[]{"container", "contained"};
            Annotation[] annotationArray = annotations;
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation annotation = annotationArray[n];
                if (annotation instanceof ManagedRelation) {
                    ManagedRelation managedRelation = (ManagedRelation)annotation;
                    if (!"".equals(managedRelation.name())) {
                        name = managedRelation.name();
                    }
                    role = managedRelation.roles();
                    relationType = managedRelation.type();
                }
                ++n;
            }
            Participant[] participants = new Participant[2];
            QName[] typeNames = new QName[]{new QName(((WSDMBinding)resource).getNamespace(), relationType, "tns")};
            new SimpleRelationshipType(typeNames);
            participants[0] = new SimpleParticipant(resource, role[0]);
            participants[1] = new SimpleParticipant(targetResource, role[1]);
            WsResource[] wsResourceArray = relationships = relCap.getRelationship();
            int n3 = 0;
            int n4 = wsResourceArray.length;
            while (n3 < n4) {
                WsResource relationship = wsResourceArray[n3];
                System.out.println(relationship);
                GetCapability getCap = (GetCapability)relationship.getCapability("http://docs.oasis-open.org/wsrf/rpw-2/Get");
                if (getCap != null) {
                    Element[] typeMatch;
                    Element[] testParts = getCap.getResourceProperty(MuwsConstants.PARTICIPANT_QNAME);
                    Element[] testType = getCap.getResourceProperty(MuwsConstants.TYPE_QNAME);
                    Element[] testName = getCap.getResourceProperty(MuwsConstants.NAME_QNAME);
                    String testNameValue = testName[0].getTextContent();
                    if (name.equals(testNameValue) && (typeMatch = XmlUtils.getElements((Node)testType[0], (QName)typeNames[0])).length != 0) {
                        SimpleParticipant tp1 = new SimpleParticipant(testParts[0]);
                        SimpleParticipant tp2 = new SimpleParticipant(testParts[1]);
                        if (this.isSameParticipant(participants[0], (Participant)tp1) && this.isSameParticipant(participants[1], (Participant)tp2)) {
                            System.out.println("Got a match!!!");
                        }
                    }
                }
                ++n3;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean isSameParticipant(Participant p1, Participant p2) {
        if (!p1.getManageabilityReference().equals((Object)p2.getManageabilityReference())) {
            return false;
        }
        if (!p1.getResourceId().equals(p2.getResourceId())) {
            return false;
        }
        return p1.getRole().equals(p2.getRole());
    }

    public void statusChanged(Object object, StatusChangeListener.STATUS newStatus) {
        WsResource binding = boundObjectMap.get(object);
        if (binding != null) {
            Capability capability = binding.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus");
            if (capability != null && capability instanceof OperationalStatus) {
                if (newStatus == StatusChangeListener.STATUS.AVAILABLE || newStatus == StatusChangeListener.STATUS.PARTIALLY_AVAILABLE || newStatus == StatusChangeListener.STATUS.UNAVAILABLE) {
                    // empty if block
                }
                try {
                    ((OperationalStatus)capability).setOperationalStatus("Unknown");
                }
                catch (BaseFault baseFault) {}
            }
        } else if (object == this) {
            this.status = newStatus;
        }
    }

    protected static void loadAdvertisementTargets() {
        Enumeration entries = _bundle.findEntries("/OSGI-INF/Advertisement", "*.*", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL obj = (URL)entries.nextElement();
                System.out.println("Entry " + obj);
                String value = obj.toString();
                int location = value.indexOf("/OSGI-INF/Advertisement");
                value = value.substring(location + 24);
                location = value.lastIndexOf(".");
                if (location != -1) {
                    value = value.substring(0, location);
                }
                try {
                    InputStream stream = obj.openStream();
                    Document doc = XmlUtils.createDocument((InputStream)stream);
                    EndpointReference ref = new EndpointReference(doc.getDocumentElement());
                    System.out.println("Ref is " + ref);
                    advertisementMap.put(value, ref);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static EndpointReference getAdvertisementTarget(String key) {
        EndpointReference ref = advertisementMap.get(key);
        if (ref == null) {
            ref = advertisementMap.get("default");
        }
        return ref;
    }

    public StatusChangeListener.STATUS getStatus() {
        return this.status;
    }

    public Object getBindingForObject(Object boundObject) {
        return boundObjectMap.get(boundObject);
    }

    @Override
    public void registerSchemaHelper(Class type, SchemaHelper helper) {
        WSDMBindingUtil.registerSchemaHelper(type, helper);
    }

    @Override
    public void registerSerializer(Class type, Serializer serializer) {
        SerializerRegistry.getInstance().registerSerializer(type, serializer);
    }

    public String getBindingName() {
        return "WSDM";
    }
}

