/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResourceCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDMOperationInfo
extends MBeanOperationInfo {
    private static final long serialVersionUID = 2830134962483961246L;
    private Method method;
    private static final Annotation[] EMPTY_ANNOTATION_LIST = new Annotation[0];
    private boolean isMetaData = false;
    private boolean isOperationStatus = false;
    private boolean isState = false;
    private boolean isEventConsumer = false;
    private String namespace = "";
    private Annotation[] methodAnnotations;

    public Method getOperationMethod() {
        return this.method;
    }

    public boolean isMetaDataMethod() {
        return this.isMetaData;
    }

    public boolean isEventConsumer() {
        return this.isEventConsumer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected <T extends Annotation> T getAnnotation(Class<T> annotation) {
        Annotation[] annotationArray = this.methodAnnotations;
        int n = 0;
        int n2 = annotationArray.length;
        while (n < n2) {
            Annotation target = annotationArray[n];
            if (target.annotationType().equals(annotation)) {
                return (T)target;
            }
            ++n;
        }
        return null;
    }

    public WSDMOperationInfo(String description, Method method, Annotation[] methodAnnotations) throws IllegalArgumentException {
        super(description, method);
        ManagedEventConsumer eventConsumer;
        this.method = method;
        this.methodAnnotations = methodAnnotations;
        ManagedOperation managedOperation = this.getAnnotation(ManagedOperation.class);
        if (managedOperation != null) {
            ManagedResourceCapability capability;
            if (managedOperation.isMetaDataMethod() && !"http://schemas.xmlsoap.org/wsdl/".equals(managedOperation.MetaDataType()) && !"".equals(managedOperation.MetaDataType())) {
                this.isMetaData = true;
            }
            this.namespace = managedOperation.namespace();
            if ("".equals(this.namespace) && (capability = this.getAnnotation(ManagedResourceCapability.class)) != null) {
                this.namespace = capability.namespace();
            }
        }
        if ((eventConsumer = this.getAnnotation(ManagedEventConsumer.class)) != null) {
            this.isEventConsumer = true;
        }
    }

    public Annotation[] getAnnotationsForParameter(MBeanParameterInfo info) {
        MBeanParameterInfo[] parms = this.getSignature();
        if (parms == null) {
            return EMPTY_ANNOTATION_LIST;
        }
        int i = 0;
        MBeanParameterInfo[] mBeanParameterInfoArray = parms;
        int n = 0;
        int n2 = mBeanParameterInfoArray.length;
        while (n < n2) {
            MBeanParameterInfo parm = mBeanParameterInfoArray[n];
            if (parm.equals(info)) break;
            ++i;
            ++n;
        }
        if (i < parms.length) {
            Annotation[][] annotations = this.method.getParameterAnnotations();
            return annotations[i];
        }
        return EMPTY_ANNOTATION_LIST;
    }
}

