/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class MemberHandle
extends SimpleValueHandle {
    protected CachedMemberRef memberRef;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.MemberHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MemberHandle(DesignElementHandle element, MemberRef ref) {
        super(element);
        this.memberRef = new CachedMemberRef(ref);
        if (!this.memberRef.checkOrCacheStructure(this.elementHandle.getModule(), this.elementHandle.getElement())) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
    }

    public MemberHandle(StructureHandle structHandle, StructPropertyDefn member) {
        super(structHandle.getElementHandle());
        this.memberRef = new CachedMemberRef(structHandle.getReference(), member);
        if (!this.memberRef.checkOrCacheStructure(this.elementHandle.getModule(), this.elementHandle.getElement())) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
    }

    public IPropertyDefn getDefn() {
        return this.memberRef.getMemberDefn();
    }

    public Object getValue() {
        Object value = this.memberRef.getValue(this.getModule(), this.getElement());
        return ModelUtil.wrapPropertyValue(this.getModule(), (PropertyDefn)this.getDefn(), value);
    }

    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.setMember(this.memberRef, value);
    }

    public void removeItem(int posn) throws PropertyValueException {
        block3: {
            ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
            try {
                cmd.removeItem((MemberRef)this.memberRef, posn);
            }
            catch (PropertyValueException e) {
                throw e;
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void addItem(Object item) throws SemanticException {
        if (item == null) {
            return;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.addItem((MemberRef)this.memberRef, item);
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.memberRef.getPropDefn();
    }

    public MemberRef getReference() {
        return this.memberRef;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }
}

