/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class SimpleGroupElementHandle
extends GroupElementHandle {
    protected final Module module;
    protected List elements = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.SimpleGroupElementHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SimpleGroupElementHandle(ModuleHandle moduleHandle, List elements) {
        if (!$assertionsDisabled && moduleHandle == null) {
            throw new AssertionError();
        }
        this.module = moduleHandle.getModule();
        if (!$assertionsDisabled && elements == null) {
            throw new AssertionError();
        }
        this.elements = elements;
    }

    public List getElements() {
        return this.elements;
    }

    public Module getModule() {
        return this.module;
    }

    public ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.module.getHandle(this.module);
    }

    public List getCommonProperties() {
        if (this.elements.size() == 1) {
            return Collections.unmodifiableList(((DesignElementHandle)this.elements.get(0)).getElement().getPropertyDefns());
        }
        List minProps = this.getMinPropDefns();
        ArrayList commonProps = new ArrayList(minProps);
        Iterator iter = minProps.iterator();
        block0: while (iter.hasNext()) {
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            int i = 0;
            while (i < this.elements.size()) {
                if (((DesignElementHandle)this.elements.get(i)).getElement().getPropertyDefn(propDefn.getName()) == null) {
                    commonProps.remove(propDefn);
                    continue block0;
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(commonProps);
    }

    private List getMinPropDefns() {
        int min = Integer.MAX_VALUE;
        List rtnPropDefns = Collections.EMPTY_LIST;
        int j = 0;
        while (j < this.elements.size()) {
            Object item = this.elements.get(j);
            if (!(item instanceof DesignElementHandle)) {
                return Collections.EMPTY_LIST;
            }
            List propDefns = ((DesignElementHandle)item).getElement().getPropertyDefns();
            if (propDefns.size() < min) {
                min = propDefns.size();
                rtnPropDefns = propDefns;
            }
            ++j;
        }
        return rtnPropDefns;
    }

    public boolean isSameType() {
        if (this.elements.size() == 0) {
            return false;
        }
        IElementDefn baseDefn = null;
        int i = 0;
        while (i < this.elements.size()) {
            Object item = this.elements.get(i);
            if (!(item instanceof DesignElementHandle)) {
                return false;
            }
            IElementDefn elemDefn = ((DesignElementHandle)item).getDefn();
            if (baseDefn == null) {
                baseDefn = elemDefn;
            }
            if (elemDefn != baseDefn) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Iterator visiblePropertyIterator() {
        List list = this.getCommonProperties();
        ArrayList<IElementPropertyDefn> visibleList = new ArrayList<IElementPropertyDefn>();
        int i = 0;
        while (i < list.size()) {
            IElementPropertyDefn propDefn = (IElementPropertyDefn)list.get(i);
            if (this.isPropertyVisible(propDefn.getName())) {
                visibleList.add(propDefn);
            }
            ++i;
        }
        return new GroupElementHandle.GroupPropertyIterator(visibleList);
    }

    protected boolean isPropertyVisible(String propName) {
        List elements = this.getElements();
        int i = 0;
        while (i < elements.size()) {
            PropertyHandle propertyHandle = ((DesignElementHandle)elements.get(i)).getPropertyHandle(propName);
            if (propertyHandle != null && !propertyHandle.isVisible() || propertyHandle == null) {
                return false;
            }
            ++i;
        }
        return !this.needHide(propName);
    }

    public void clearLocalProperties() throws SemanticException {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans();
        try {
            Iterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                Object localValue;
                GroupPropertyHandle propHandle = (GroupPropertyHandle)iter.next();
                String propName = propHandle.getPropertyDefn().getName();
                if ("extends".equals(propName) || "name".equals(propName) || "extensionName".equals(propName) || propHandle.isExtensionModelProperty() || propHandle.getPropertyDefn().getTypeCode() == 23 || (localValue = propHandle.getLocalValue()) == null) continue;
                propHandle.clearValue();
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public boolean isExtendedElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle designHandle = (DesignElementHandle)next;
            if (designHandle.getExtends() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean allExtendedElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle elementHandle = (DesignElementHandle)next;
            if (elementHandle.getExtends() != null || elementHandle.getElement().getBaseId() > 0L) continue;
            return false;
        }
        return true;
    }

    protected boolean isPropertyReadOnly(String propName) {
        int i = 0;
        while (i < this.elements.size()) {
            PropertyHandle propertyHandle = ((DesignElementHandle)this.elements.get(i)).getPropertyHandle(propName);
            if (propertyHandle != null && propertyHandle.isReadOnly() || propertyHandle == null) {
                return true;
            }
            ++i;
        }
        return this.needHide(propName);
    }

    /*
     * Unable to fully structure code
     */
    private boolean needHide(String propName) {
        if (!("bookmark".equals(propName) || "toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName) || "pageBreakInside".equals(propName) || "drop".equals(propName))) {
            return false;
        }
        i = 0;
        while (i < this.elements.size()) {
            block7: {
                current = (DesignElementHandle)this.elements.get(i);
                container = current.getContainer();
                if (!"drop".equals(propName)) ** GOTO lbl13
                if (!(current instanceof CellHandle) || container == null || container.getContainer() instanceof GroupHandle) break block7;
                return true;
lbl-1000:
                // 1 sources

                {
                    if (container instanceof MasterPageHandle) {
                        return true;
                    }
                    container = container.getContainer();
lbl13:
                    // 2 sources

                    ** while (container != null)
                }
            }
            ++i;
        }
        return false;
    }

    public GroupPropertyHandle getPropertyHandle(String propName) {
        List commProps = this.getCommonProperties();
        int i = 0;
        while (i < commProps.size()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)commProps.get(i);
            if (propDefn.getName().equalsIgnoreCase(propName)) {
                return new GroupPropertyHandle(this, propDefn);
            }
            ++i;
        }
        return null;
    }

    protected boolean isInGroup(DesignElementHandle element) {
        return this.elements.contains(element);
    }
}

