/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class MemberRecord
extends SimpleRecord {
    protected DesignElement element;
    protected Module module;
    protected MemberRef memberRef;
    protected Structure structure;
    protected Object newValue;
    protected Object oldValue;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.MemberRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MemberRecord(Module module, DesignElement obj, MemberRef ref, Object value) {
        this.element = obj;
        this.memberRef = ref;
        this.newValue = value;
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.structure = this.memberRef.getStructure(module, this.element);
        this.oldValue = this.memberRef.getLocalValue(module, this.element);
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{this.memberRef.getPropDefn().getDisplayName()});
    }

    protected void perform(boolean undo) {
        PropertyDefn prop = this.memberRef.getMemberDefn();
        if (this.structure != null) {
            this.structure.setProperty(prop, undo ? this.oldValue : this.newValue);
        }
    }

    public DesignElement getTarget() {
        return this.element;
    }

    public NotificationEvent getEvent() {
        return new PropertyEvent(this.element, this.memberRef.getPropDefn().getName());
    }

    protected List getPostTasks() {
        ArrayList<NotificationRecordTask> retList = new ArrayList<NotificationRecordTask>();
        retList.addAll(super.getPostTasks());
        NotificationEvent ev = this.getEvent();
        retList.add(new NotificationRecordTask(this.element, ev));
        if (this.structure != null && this.structure.isReferencable()) {
            ReferencableStructure refValue = (ReferencableStructure)this.structure;
            retList.add(new NotificationRecordTask(refValue, ev));
        }
        return retList;
    }
}

