/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.repository.internal.ISMLRepositoryConstants;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceFacet;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceInstance;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceProperty;
import org.eclipse.cosmos.rm.repository.internal.application.impl.NodeIterator;
import org.eclipse.cosmos.rm.repository.internal.application.impl.SMLFileResourceFacet;
import org.eclipse.cosmos.rm.repository.internal.application.impl.SMLFileResourceInstance;
import org.eclipse.cosmos.rm.repository.internal.application.impl.SMLResourceProperty;
import org.eclipse.cosmos.rm.repository.internal.application.impl.TypeInfoHandler;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLIFIdentity;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class SMLRepositoryUtil {
    public static String extractReference(Node root) {
        NodeIterator nodeIterator = new NodeIterator(root, "http://schemas.serviceml.org/sml/2007/02", "uri");
        if (!nodeIterator.hasNext()) {
            return "";
        }
        Node uriElement = (Node)nodeIterator.next();
        NodeList children = uriElement.getChildNodes();
        StringBuffer reference = new StringBuffer();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            if (children.item(i).getNodeType() == 3) {
                String value = children.item(i).getNodeValue();
                value = value.trim();
                value = value.replaceAll("\n", "");
                reference.append(value);
            }
            ++i;
        }
        return reference.toString();
    }

    public static ISMLResourceInstance[] retrieveResources(ISMLRepository repository, ISMLResourceInstance document, Node root) {
        if (document == null || root == null) {
            return new ISMLResourceInstance[0];
        }
        SMLRepositoryUtil.parseDocument(document, repository);
        ArrayList resourceList = new ArrayList();
        SMLRepositoryUtil.loadResources(repository, document, resourceList, root, 0, 1);
        return resourceList.toArray(new ISMLResourceInstance[resourceList.size()]);
    }

    public static ISMLResourceFacet[] retrieveFacets(ISMLResourceInstance document, Node root, ISMLRepository repository) {
        if (document == null || root == null) {
            return new ISMLResourceFacet[0];
        }
        SMLRepositoryUtil.parseDocument(document, repository);
        ArrayList facetList = new ArrayList();
        SMLRepositoryUtil.loadFacets(repository, document, facetList, root, 0, 1);
        return facetList.toArray(new ISMLResourceFacet[facetList.size()]);
    }

    private static void loadResources(ISMLRepository repository, ISMLResourceInstance document, List resourceList, Node root, int currentDepth, int maximumDepth) {
        SMLRepositoryUtil.loadChildren(repository, resourceList, document, root, currentDepth, maximumDepth, null, "itemType", "itemRef", SMLFileResourceInstance.class);
    }

    private static void loadFacets(ISMLRepository repository, ISMLResourceInstance document, List facetList, Node root, int currentDepth, int maximumDepth) {
        SMLRepositoryUtil.loadChildren(repository, facetList, document, root, currentDepth, maximumDepth, "facetsType", "facetBaseType", "facetRef", SMLFileResourceFacet.class);
    }

    private static boolean isDerivedType(ISMLRepository repository, Node child, String uri, String localTypeName) {
        Map typeInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", (Object)null);
        Map hierarchyInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.HIERARCHY_INFORMATION", (Object)null);
        if (hierarchyInfo == null || typeInfo == null) {
            return false;
        }
        String expectedType = String.valueOf(uri) + ":" + localTypeName;
        String currentType = SMLRepositoryUtil.retrieveType(typeInfo, child.getNamespaceURI(), child.getLocalName());
        do {
            if (currentType == null || !currentType.equals(expectedType)) continue;
            return true;
        } while ((currentType = SMLRepositoryUtil.getParent(hierarchyInfo, currentType)) != null);
        return false;
    }

    private static String retrieveType(Map typeInfo, String namespaceURI, String localTypeName) {
        if (namespaceURI == null || localTypeName == null) {
            return null;
        }
        Map types = SMLValidatorUtil.retrieveNestedMap((Map)typeInfo, (String)namespaceURI, (boolean)false);
        return types == null ? null : (String)types.get(localTypeName);
    }

    private static String getParent(Map hierarchyInfo, String type) {
        String[] typeTokens = SMLRepositoryUtil.tokenizeQualifiedName(type);
        if (typeTokens[0] == null || typeTokens[1] == null) {
            return null;
        }
        Map hierarchy = SMLValidatorUtil.retrieveNestedMap((Map)hierarchyInfo, (String)typeTokens[0], (boolean)false);
        if (hierarchy == null) {
            return null;
        }
        return (String)hierarchy.get(typeTokens[1]);
    }

    private static void parseDocument(ISMLResourceInstance document, ISMLRepository repository) {
        Map typeInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", (Object)null);
        Map hierarchyInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.HIERARCHY_INFORMATION", (Object)null);
        typeInfo = typeInfo == null ? new Hashtable() : typeInfo;
        hierarchyInfo = hierarchyInfo == null ? new Hashtable() : hierarchyInfo;
        try {
            Node schemaLocation;
            Node root = ((SMLFileResourceInstance)document).getDOMDocument().getFirstChild();
            NamedNodeMap attributes = root.getAttributes();
            Node node = schemaLocation = attributes == null ? null : attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (schemaLocation == null) {
                return;
            }
            StringTokenizer schemaFiles = new StringTokenizer(schemaLocation.getNodeValue());
            while (schemaFiles.hasMoreTokens()) {
                String uri = schemaFiles.nextToken();
                String location = schemaFiles.nextToken();
                SMLRepositoryUtil.processSchemaFile(SMLRepositoryUtil.getDocumentPath(document), typeInfo, hierarchyInfo, uri, location);
            }
        }
        catch (RepositoryOperationException e) {
            e.printStackTrace();
            return;
        }
        repository.setProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", typeInfo);
        repository.setProperty("org.eclipse.cosmos.rm.repository.HIERARCHY_INFORMATION", hierarchyInfo);
    }

    private static void processSchemaFile(String parentLocation, Map typeInfo, Map hierarchyInfo, String uri, String location) {
        if (typeInfo.get(uri) != null) {
            return;
        }
        try {
            parentLocation = parentLocation.replace('\\', '/');
            if (!location.startsWith(parentLocation)) {
                int lastSegment = parentLocation.lastIndexOf(47);
                String parentFolder = lastSegment < 0 ? parentLocation : parentLocation.substring(0, lastSegment);
                location = String.valueOf(parentFolder) + "/" + location;
            }
            FileInputStream fis = new FileInputStream(location);
            TypeInfoHandler typeInfoHandler = new TypeInfoHandler(typeInfo, hierarchyInfo);
            SMLValidatorUtil.saxParseDocument((InputStream)fis, (DefaultHandler)typeInfoHandler);
            Map importedStatement = typeInfoHandler.getImportStatements();
            for (String importedURI : importedStatement.keySet()) {
                SMLRepositoryUtil.processSchemaFile(location, typeInfo, hierarchyInfo, importedURI, (String)importedStatement.get(importedURI));
            }
        }
        catch (Exception exception) {}
    }

    public static ISMLResourceProperty[] retrieveProperties(ISMLRepository repository, ISMLResourceInstance document, Node root) {
        if (document == null || root == null) {
            return new ISMLResourceProperty[0];
        }
        SMLRepositoryUtil.parseDocument(document, repository);
        ArrayList propertiesList = new ArrayList();
        SMLRepositoryUtil.loadProperties(repository, document, propertiesList, root, 0, 1);
        return propertiesList.toArray(new ISMLResourceProperty[propertiesList.size()]);
    }

    private static void loadProperties(ISMLRepository repository, ISMLResourceInstance document, List propertiesList, Node root, int currentDepth, int maxDepth) {
        SMLRepositoryUtil.loadChildren(repository, propertiesList, document, root, currentDepth, maxDepth, "propertiesType", "propertyBaseType", "propertyRef", SMLResourceProperty.class);
    }

    private static void loadChildren(ISMLRepository repository, List list, ISMLResourceInstance document, Node root, int currentDepth, int maxDepth, String groupElementType, String elementType, String referenceType, Class entity) {
        NodeList children = root.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (groupElementType != null && currentDepth < maxDepth && SMLRepositoryUtil.isDerivedType(repository, child, "http://www.cosmos.rm/dataCenter/core", groupElementType)) {
                    SMLRepositoryUtil.loadChildren(repository, list, document, child, currentDepth + 1, maxDepth, groupElementType, elementType, referenceType, entity);
                } else if (SMLRepositoryUtil.isDerivedType(repository, child, "http://www.cosmos.rm/dataCenter/core", elementType) || "http://www.cosmos.rm/dataCenter/core".equals(child.getNamespaceURI()) && referenceType.equals(child.getLocalName())) {
                    try {
                        Object item = entity.getMethod("load", ISMLRepository.class, Node.class).invoke(null, repository, children.item(i));
                        if (item != null) {
                            entity.getMethod("setParentDocument", ISMLDocument.class).invoke(item, document);
                            list.add(item);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public static String retrieveRootAttribute(Node node, String uri, String localName) {
        Node attribute;
        NamedNodeMap attributes = node == null ? null : node.getAttributes();
        Node node2 = attribute = attributes == null ? null : attributes.getNamedItemNS(uri, localName);
        if (attribute == null && attributes != null) {
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                Node currentAttribute = attributes.item(i);
                if (localName.equals(currentAttribute.getLocalName())) {
                    attribute = currentAttribute;
                    break;
                }
                ++i;
            }
        }
        return attribute == null ? null : attribute.getNodeValue();
    }

    public static String firstSegment(String path, int index) {
        StringTokenizer segments = new StringTokenizer(path, "\\/");
        if (index > segments.countTokens()) {
            return null;
        }
        String desiredSegment = null;
        int i = 0;
        while (i < index) {
            desiredSegment = segments.nextToken();
            ++i;
        }
        return desiredSegment;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    public static void appendSMLIFIdentityInformation(StringBuffer buffer, ISMLIFIdentity identity) {
        buffer.append(ISMLRepositoryConstants.smlifStart).append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"name")).append(identity.getName()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"name"));
        if (!SMLRepositoryUtil.isNullOrEmpty(identity.getVersion())) {
            buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"version")).append(identity.getVersion()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"version"));
        }
        if (!SMLRepositoryUtil.isNullOrEmpty(identity.getDisplayName())) {
            buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"displayName")).append(identity.getDisplayName()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"displayName"));
        }
        buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"baseURI")).append(identity.getBaseURI()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"baseURI")).append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"description")).append("\n").append("\t").append("\t").append("\t").append(identity.getDescription()).append("\n").append("\t").append("\t").append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"description")).append("\n").append("\t").append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"identity")).append("\n");
    }

    public static String getAlternativeId(ISMLRepository repository, String id) {
        String contextDirectory = repository.getProperty("root.directory", "");
        if (id.startsWith(contextDirectory)) {
            return id.substring(contextDirectory.length() + 1);
        }
        return String.valueOf(contextDirectory) + (contextDirectory.endsWith("/") || contextDirectory.endsWith("\\") ? "" : "/") + id;
    }

    public static String getDocumentName(ISMLDocument document) {
        return SMLRepositoryUtil.findDocumentLocation(document, false);
    }

    public static String getDocumentPath(ISMLDocument document) {
        return SMLRepositoryUtil.findDocumentLocation(document, true);
    }

    private static String findDocumentLocation(ISMLDocument document, boolean absolute) {
        ISMLRepository repository = ((SMLFileDocument)document).getRepository();
        String contextDirectory = repository.getProperty("root.directory", "");
        String id = document.getMetadata().getId();
        boolean startsWithContext = id.startsWith(contextDirectory);
        return absolute ? (startsWithContext ? id : SMLRepositoryUtil.getAlternativeId(repository, id)) : (startsWithContext ? SMLRepositoryUtil.getAlternativeId(repository, id) : id);
    }

    public static String[] tokenizeQualifiedName(String name) {
        if (name == null) {
            return new String[2];
        }
        int colonInx = -1;
        colonInx = name.lastIndexOf(58);
        String prefix = colonInx < 0 ? null : name.substring(0, colonInx);
        name = colonInx < 0 ? name : name.substring(colonInx + 1);
        return new String[]{prefix, name};
    }

    public static String retrieveAlias(ISMLDocument document, Map aliases) {
        String id = document.getMetadata().getId();
        String[] documentAliases = (String[])aliases.get(id);
        return documentAliases == null || documentAliases.length < 0 ? SMLRepositoryUtil.getDocumentName(document) : documentAliases[0];
    }

    public static String[] toStringArray(Collection map) {
        if (map == null || map.size() <= 0) {
            return new String[0];
        }
        ArrayList<String> finalList = new ArrayList<String>();
        for (List ruleList : map) {
            int i = 0;
            int ruleListCount = ruleList.size();
            while (i < ruleListCount) {
                String rule = (String)ruleList.get(i);
                if (!finalList.contains(rule)) {
                    finalList.add(rule);
                }
                ++i;
            }
        }
        return finalList.toArray(new String[finalList.size()]);
    }
}

