/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.BIRTContainer");
dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit._Container");



 dojo.declare(
	'cosmos.widget.BIRTContainer',
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
		templatePath:dojo.moduleUrl("cosmos.widget", "html/BIRTContainer.html"),
		widgetClass:'cosmos:BIRTContainer',
		widgetId: "birtcontainer",
		// width
		width : "100%",
		// height
		height : "400",
		content_provider: "",
		postCreate: function(){
			//call superclass
			cosmos.widget.BIRTContainer.superclass.postCreate.apply(this, arguments);
		  	dojo.subscribe("initializeWidget", this, this.initWidget);				
			
		},		
		initWidget: function(message){
			initParam = message.styles.getStyles()[this.widgetClass];
		    this.subscribe = initParam.subscribe;
		    this.handler = initParam.handler;
			dojo.subscribe(this.subscribe, this, this.refreshContent);	
			console.debug("initalizing birt container "  + this.id);	
		},		
		URLEncode: function(sStr) {
		    return escape(sStr)
       			.replace(/\+/g, '%2B')
          			.replace(/\"/g,'%22')
             			.replace(/\'/g, '%27');
  		},			
	    refreshContent:function(message) {
	    	if (typeof(message.contextMap) != 'undefined'){
		  	//should add a javascript method that will render itself and make a call
			//back to the server.  It will get the context from a queue.			
				resourceContext = message.contextMap['RESOURCE_CONTEXT'];	
				type = this.URLEncode(message.contextMap['REPORT_TYPE']);	
				datasource = this.URLEncode(message.contextMap['DATASOURCE_KEY']);	
			}
			//make REST call to get content data
	    	if ((typeof(resourceContext) != 'undefined') && (typeof(type) != 'undefined')){
			dojo.xhrGet({
					changeit : this.changeit,
					widgetId: this.widgetId,
					url: this.handler+"&context="+resourceContext+"&type="+type+"&datasource="+datasource,    
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
								this.changeit(response, this.widgetId);						 		
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
			}
			else{
			//reset page
				this.changeit(this.blankPath, this.widgetId);
			}
	    },
		changeit:function(url, id){
  			document.getElementById(id).src=url;
		},
	    
		// definitions
		blankPath:dojo.moduleUrl("cosmos.widget", "html/blank.html")
	}
);
