/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.PropertiesTable");
dojo.require("dojo.widget.FilteringTable");
dojo.require("dojo.event.topic");


dojo.declare(
	// class
	"cosmos.widget.PropertiesTable",
	// superclass	
	[dojo.widget.FilteringTable],
	
	// member variables/functions
	{
		widgetClass:'cosmos:PropertiesTable',
		postCreate: function(){
			//call superclass
			cosmos.widget.PropertiesTable.superclass.postCreate.apply(this, arguments);
		  	dojo.subscribe("initializeWidget", this, "initWidget");				
		},
		setRegistry: function(registryObj){
			this.renderDojoCell=registryObj;
		},
		initWidget: function(styles){
			if (typeof(styles) != 'undefined'){
				initParam = styles.getStyles()[this.widgetClass];
			    this.subscribe = initParam.subscribe;
			    this.handler = initParam.handler;
				dojo.subscribe(this.subscribe, this, "refreshTable");					
		    }
			//intialize table
			
			var columns =[{ field: "Name" },
				{ field: "Value"}
				];	
			for (var x = 0; x<columns.length; x++) {
				this.columns.push(this.createMetaData(columns[x]));
			}
			dojo.publish("pullRegistry", this);
			console.debug("initalizing PropertiesTable"  + this.id);	
		},
				
	    refreshTable:function(contextMap) {
	    
	    	if (typeof(contextMap) != 'undefined'){
		  	//should add a javascript method that will render itself and make a call
			//back to the server.  It will get the context from a queue.			
				resourceContext = contextMap['RESOURCE_CONTEXT'];	
			}
			//make REST call to get content data
	    	if (typeof(resourceContext) != 'undefined'){
				dojo.io.bind({storeFunction : this.store,
					url: this.handler+"?context="+resourceContext,    
					load: function(type, data, evt){
					try{
						this.storeFunction.setData(data);
						}catch(e){
						console.debug(e);
						}
					 },    
				 error: function(type, error){
				 	console.debug(error.message);
				 },
					mimetype: "application/json"
				});											
			}
	    },		
		mixInProperties: function(args, fragment, parent){
			this.valueField = "id";
		
			//call superclass						
			cosmos.widget.PropertiesTable.superclass.mixInProperties.apply(this, arguments);
		},
		createRow:function (obj) {
			var row = document.createElement("tr");
			dojo.html.disableSelection(row);
			if (obj.key != null) {
				row.setAttribute("value", obj.key);
			}
			for (var j = 0; j < this.columns.length; j++) {
				var cell = document.createElement("td");
				cell.setAttribute("align", this.columns[j].align);
				cell.setAttribute("valign", this.columns[j].valign);
				dojo.html.disableSelection(cell);
				var val = this.store.getField(obj.src, this.columns[j].getField());
				if (typeof (val) == "undefined") {
					val = "";
				}				
				if ((typeof(this.renderDojoCell) != "undefined") && (this.isObject(val))){
					this.renderDojoCell.dojoCellFactory(val, cell);
				}
				else
					this.fillCell(cell, this.columns[j], val);
				row.appendChild(cell);
			}
			return row;
		
		},		
		isObject:function(obj){
			if (obj.constructor.toString().indexOf("Object") == -1)
				return false;
			return true;
		}				
	}
);
