/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.Property");
dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit._Container");

dojo.declare("cosmos.widget.Property", 
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
    indent: 0,
	templateString:"<div dojoAttachPoint=\"propertyNode\" class=\"cosmosProperty\"></div>", 
	templateCssString:".cosmosProperty {font-size:0.8em;padding:2px;border:1px solid #ccc;	background: #ccc;margin-left:${this.indent}px}\n", 
	templateCssPath:dojo.moduleUrl("cosmos.widget", "templates/PropertyTemplate.css"),
	properties:[],  
	postCreate:function () {
	    if (this.properties){	        
			for (i=0;i < this.properties.length;i++){
				p = document.createElement("div");	
				this.propertyNode.appendChild(p);
				p.appendChild(document.createTextNode(this.properties[i].name+" : "+this.properties[i].value));
			}
		}
	
		if (this.propertyNodeClass) {
			dojo.html.addClass(this.propertyNode, this.propertyNodeClass);
		}
		
	}
}
);

