/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.ReportChooser");
dojo.require("dojo.data.JsonItemStore");
dojo.require("dijit.form.Button");
dojo.require("dijit.Menu");


dojo.declare(
	// class
	"cosmos.widget.ReportChooser",

	// superclass	
	[dijit.form.Button],
	
	// member variables/functions
	{

		postCreate: function(){
			dojo.xhrGet({
					url: this.handler+"&value="+this.value,  
					value: this.value,
					srcNodeRef: this.srcNodeRef,
					reportChooser: this,
					publish: this.publish,  
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
			                		if (response.length > 0){
			                			this.reportChooser.setLabel(response[0].caption);
			                			this.reportChooser.onClick = function(){
													var params= new Array();
													params['RESOURCE_CONTEXT']=this.value;
													params['REPORT_TYPE']=response[0].value;
													params['DATASOURCE_KEY']=this.datasource;
													console.debug(this.datasource);
													if (typeof(this.publish) != 'undefined'){
															for (i=0;i < this.publish.length;i++){
																dojo.publish(this.publish[i], [{contextMap:params}]);
												 			}
										 			}	    
											    }
			                			
			                		}
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
			cosmos.widget.ReportChooser.superclass.postCreate.apply(this, arguments);
		}
	}
);
